#!/bin/bash

# This file is part of Trip Server 2, a program to support trip recording and
# itinerary planning.
#
# Copyright (C) 2022-2024 Frank Dean <frank.dean@fdsd.co.uk>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

set -x
set -e
PUSH=${PUSH:-y}
PUSH_DB=${PUSH_DB:-$PUSH}
PUSH_TRIP=${PUSH_TRIP:-$PUSH}
MAKEFLAGS=${MAKEFLAGS:-'-j 1'}
BUILD=${BUILD:-y}
BUILD_DB=${BUILD_DB:-$BUILD}
BUILD_TRIP=${BUILD_TRIP:-$BUILD}
DOCKER=${DOCKER:-docker}

if [ $BUILD_DB == 'y' ];then
    ${DOCKER} pull docker.io/library/postgres:15-bookworm
    ${DOCKER} build --platform=linux/amd64 -f Dockerfile-postgis -t fdean/trip-database:latest-amd64 .
    ${DOCKER} build --platform=linux/arm64 -f Dockerfile-postgis -t fdean/trip-database:latest-arm64 .
fi
if [ $PUSH_DB == 'y' ]; then
    ${DOCKER} push fdean/trip-database:latest-amd64
    ${DOCKER} push fdean/trip-database:latest-arm64
    if [ -n "$(${DOCKER} images -q fdean/trip-database:latest 2> /dev/null)" ]; then
	${DOCKER} manifest rm fdean/trip-database:latest
    fi
    ${DOCKER} manifest create fdean/trip-database:latest fdean/trip-database:latest-amd64 fdean/trip-database:latest-arm64
    ${DOCKER} push fdean/trip-database:latest
fi

if [ $BUILD_TRIP == 'y' ];then
    ${DOCKER} pull docker.io/library/debian:bookworm-slim
    ${DOCKER} build --platform=linux/arm64 --build-arg MAKEFLAGS="$MAKEFLAGS" -t fdean/trip-server-2:latest-arm64 .
    ${DOCKER} build --platform=linux/amd64 --build-arg MAKEFLAGS="$MAKEFLAGS" -t fdean/trip-server-2:latest-amd64 .
fi
if [ $PUSH_TRIP == 'y' ]; then
    ${DOCKER} push fdean/trip-server-2:latest-arm64
    ${DOCKER} push fdean/trip-server-2:latest-amd64
    if [ -n "$(${DOCKER} images -q fdean/trip-server-2:latest 2> /dev/null)" ]; then
	${DOCKER} manifest rm fdean/trip-server-2:latest
    fi
    ${DOCKER} manifest create fdean/trip-server-2:latest fdean/trip-server-2:latest-amd64 fdean/trip-server-2:latest-arm64
    ${DOCKER} push fdean/trip-server-2:latest
fi

if [ $PUSH_DB == 'y' ]; then
    if [ -z "$(${DOCKER} images -q fdean/trip-database:2.5.2 2> /dev/null)" ]; then
	${DOCKER} tag fdean/trip-database:latest fdean/trip-database:2.5.2
	${DOCKER} push fdean/trip-database:2.5.2
    fi
fi
if [ $PUSH_TRIP == 'y' ]; then
    if [ -z "$(${DOCKER} images -q fdean/trip-server-2:2.5.2 2> /dev/null)" ]; then
	${DOCKER} tag fdean/trip-server-2:latest fdean/trip-server-2:2.5.2
	${DOCKER} push fdean/trip-server-2:2.5.2
    fi
fi

if [ -n "$(${DOCKER} images -q fdean/trip-database:latest-amd64 2> /dev/null)" ]; then
    ${DOCKER} image inspect --format='{{println .Config.Labels}}' fdean/trip-database:latest-amd64
fi
if [ -n "$(${DOCKER} images -q fdean/trip-database:latest-arm64 2> /dev/null)" ]; then
    ${DOCKER} image inspect --format='{{println .Config.Labels}}' fdean/trip-database:latest-arm64
fi
if [ -n "$(${DOCKER} images -q fdean/trip-server-2:latest-amd64 2> /dev/null)" ]; then
    ${DOCKER} image inspect --format='{{println .Config.Labels}}' fdean/trip-server-2:latest-amd64
fi
if [ -n "$(${DOCKER} images -q fdean/trip-server-2:latest-arm64 2> /dev/null)" ]; then
    ${DOCKER} image inspect --format='{{println .Config.Labels}}' fdean/trip-server-2:latest-arm64
fi
