--
-- PostgreSQL database dump
--

-- Dumped from database version 13.13 (Debian 13.13-0+deb11u1)
-- Dumped by pg_dump version 13.13 (Debian 13.13-0+deb11u1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

ALTER TABLE IF EXISTS ONLY public.user_role DROP CONSTRAINT IF EXISTS user_role_user_id_fkey;
ALTER TABLE IF EXISTS ONLY public.user_role DROP CONSTRAINT IF EXISTS user_role_role_id_fkey;
ALTER TABLE IF EXISTS ONLY public.session DROP CONSTRAINT IF EXISTS session_user_id_fkey;
ALTER TABLE IF EXISTS ONLY public.session_data DROP CONSTRAINT IF EXISTS session_data_session_id_fkey;
ALTER TABLE IF EXISTS ONLY public.location DROP CONSTRAINT IF EXISTS location_user_id_fkey;
ALTER TABLE IF EXISTS ONLY public.location_sharing DROP CONSTRAINT IF EXISTS location_sharing_shared_to_id_fkey;
ALTER TABLE IF EXISTS ONLY public.location_sharing DROP CONSTRAINT IF EXISTS location_sharing_shared_by_id_fkey;
ALTER TABLE IF EXISTS ONLY public.itinerary_waypoint DROP CONSTRAINT IF EXISTS itinerary_waypoint_itinerary_id_fkey;
ALTER TABLE IF EXISTS ONLY public.itinerary DROP CONSTRAINT IF EXISTS itinerary_user_id_fkey;
ALTER TABLE IF EXISTS ONLY public.itinerary_track_segment DROP CONSTRAINT IF EXISTS itinerary_track_segment_itinerary_track_id_fkey;
ALTER TABLE IF EXISTS ONLY public.itinerary_track_point DROP CONSTRAINT IF EXISTS itinerary_track_point_itinerary_track_segment_id_fkey;
ALTER TABLE IF EXISTS ONLY public.itinerary_track DROP CONSTRAINT IF EXISTS itinerary_track_itinerary_id_fkey;
ALTER TABLE IF EXISTS ONLY public.itinerary_sharing DROP CONSTRAINT IF EXISTS itinerary_sharing_shared_to_id_fkey;
ALTER TABLE IF EXISTS ONLY public.itinerary_sharing DROP CONSTRAINT IF EXISTS itinerary_sharing_itinerary_id_fkey;
ALTER TABLE IF EXISTS ONLY public.itinerary_route_point DROP CONSTRAINT IF EXISTS itinerary_route_point_itinerary_route_id_fkey;
ALTER TABLE IF EXISTS ONLY public.itinerary_route DROP CONSTRAINT IF EXISTS itinerary_route_itinerary_id_fkey;
DROP INDEX IF EXISTS public.location_geog_idx;
DROP INDEX IF EXISTS public.itinerary_waypoint_geog_idx;
DROP INDEX IF EXISTS public.itineary_track_point_geog_idx;
DROP INDEX IF EXISTS public.itineary_route_point_geog_idx;
DROP INDEX IF EXISTS public.idx_time_inverse;
ALTER TABLE IF EXISTS ONLY public.waypoint_symbol DROP CONSTRAINT IF EXISTS waypoint_symbol_value_key;
ALTER TABLE IF EXISTS ONLY public.waypoint_symbol DROP CONSTRAINT IF EXISTS waypoint_symbol_pkey;
ALTER TABLE IF EXISTS ONLY public.usertable DROP CONSTRAINT IF EXISTS usertable_uuid_key;
ALTER TABLE IF EXISTS ONLY public.usertable DROP CONSTRAINT IF EXISTS usertable_pkey;
ALTER TABLE IF EXISTS ONLY public.usertable DROP CONSTRAINT IF EXISTS usertable_nickname_key;
ALTER TABLE IF EXISTS ONLY public.usertable DROP CONSTRAINT IF EXISTS usertable_email_key;
ALTER TABLE IF EXISTS ONLY public.user_role DROP CONSTRAINT IF EXISTS user_role_pkey;
ALTER TABLE IF EXISTS ONLY public.path_color DROP CONSTRAINT IF EXISTS track_color_value_key;
ALTER TABLE IF EXISTS ONLY public.path_color DROP CONSTRAINT IF EXISTS track_color_pkey;
ALTER TABLE IF EXISTS ONLY public.tile DROP CONSTRAINT IF EXISTS tile_pkey;
ALTER TABLE IF EXISTS ONLY public.session DROP CONSTRAINT IF EXISTS session_pkey;
ALTER TABLE IF EXISTS ONLY public.session_data DROP CONSTRAINT IF EXISTS session_data_pkey;
ALTER TABLE IF EXISTS ONLY public.role DROP CONSTRAINT IF EXISTS role_pkey;
ALTER TABLE IF EXISTS ONLY public.role DROP CONSTRAINT IF EXISTS role_name_key;
ALTER TABLE IF EXISTS ONLY public.location_sharing DROP CONSTRAINT IF EXISTS location_sharing_pkey;
ALTER TABLE IF EXISTS ONLY public.location DROP CONSTRAINT IF EXISTS location_pkey;
ALTER TABLE IF EXISTS ONLY public.itinerary_waypoint DROP CONSTRAINT IF EXISTS itinerary_waypoint_pkey;
ALTER TABLE IF EXISTS ONLY public.itinerary_track_segment DROP CONSTRAINT IF EXISTS itinerary_track_segment_pkey;
ALTER TABLE IF EXISTS ONLY public.itinerary_track_point DROP CONSTRAINT IF EXISTS itinerary_track_point_pkey;
ALTER TABLE IF EXISTS ONLY public.itinerary_track DROP CONSTRAINT IF EXISTS itinerary_track_pkey;
ALTER TABLE IF EXISTS ONLY public.itinerary_sharing DROP CONSTRAINT IF EXISTS itinerary_sharing_pkey;
ALTER TABLE IF EXISTS ONLY public.itinerary_route_point DROP CONSTRAINT IF EXISTS itinerary_route_point_pkey;
ALTER TABLE IF EXISTS ONLY public.itinerary_route DROP CONSTRAINT IF EXISTS itinerary_route_pkey;
ALTER TABLE IF EXISTS ONLY public.itinerary DROP CONSTRAINT IF EXISTS itinerary_pkey;
ALTER TABLE IF EXISTS ONLY public.georef_format DROP CONSTRAINT IF EXISTS georef_format_value_key;
ALTER TABLE IF EXISTS ONLY public.georef_format DROP CONSTRAINT IF EXISTS georef_format_pkey;
ALTER TABLE IF EXISTS public.role ALTER COLUMN id DROP DEFAULT;
ALTER TABLE IF EXISTS public.itinerary_waypoint ALTER COLUMN id DROP DEFAULT;
ALTER TABLE IF EXISTS public.itinerary_track_segment ALTER COLUMN id DROP DEFAULT;
ALTER TABLE IF EXISTS public.itinerary_track_point ALTER COLUMN id DROP DEFAULT;
ALTER TABLE IF EXISTS public.itinerary_track ALTER COLUMN id DROP DEFAULT;
ALTER TABLE IF EXISTS public.itinerary_route_point ALTER COLUMN id DROP DEFAULT;
ALTER TABLE IF EXISTS public.itinerary_route ALTER COLUMN id DROP DEFAULT;
ALTER TABLE IF EXISTS public.itinerary ALTER COLUMN id DROP DEFAULT;
DROP TABLE IF EXISTS public.waypoint_symbol;
DROP TABLE IF EXISTS public.usertable;
DROP SEQUENCE IF EXISTS public.usertable_seq;
DROP TABLE IF EXISTS public.user_role;
DROP TABLE IF EXISTS public.tile_metric;
DROP SEQUENCE IF EXISTS public.tile_download_seq;
DROP TABLE IF EXISTS public.tile;
DROP TABLE IF EXISTS public.session_data;
DROP TABLE IF EXISTS public.session;
DROP SEQUENCE IF EXISTS public.role_seq;
DROP TABLE IF EXISTS public.role;
DROP TABLE IF EXISTS public.path_color;
DROP TABLE IF EXISTS public.location_sharing;
DROP TABLE IF EXISTS public.location;
DROP SEQUENCE IF EXISTS public.location_seq;
DROP SEQUENCE IF EXISTS public.itinerary_waypoint_seq;
DROP TABLE IF EXISTS public.itinerary_waypoint;
DROP SEQUENCE IF EXISTS public.itinerary_track_seq;
DROP SEQUENCE IF EXISTS public.itinerary_track_segment_seq;
DROP TABLE IF EXISTS public.itinerary_track_segment;
DROP SEQUENCE IF EXISTS public.itinerary_track_point_seq;
DROP TABLE IF EXISTS public.itinerary_track_point;
DROP TABLE IF EXISTS public.itinerary_track;
DROP TABLE IF EXISTS public.itinerary_sharing;
DROP SEQUENCE IF EXISTS public.itinerary_seq;
DROP SEQUENCE IF EXISTS public.itinerary_route_seq;
DROP SEQUENCE IF EXISTS public.itinerary_route_point_seq;
DROP TABLE IF EXISTS public.itinerary_route_point;
DROP TABLE IF EXISTS public.itinerary_route;
DROP TABLE IF EXISTS public.itinerary;
DROP TABLE IF EXISTS public.georef_format;
DROP EXTENSION IF EXISTS postgis;
DROP EXTENSION IF EXISTS pgcrypto;
DROP EXTENSION IF EXISTS plpgsql;
--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


--
-- Name: pgcrypto; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS pgcrypto WITH SCHEMA public;


--
-- Name: EXTENSION pgcrypto; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION pgcrypto IS 'cryptographic functions';


--
-- Name: postgis; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis WITH SCHEMA public;


--
-- Name: EXTENSION postgis; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis IS 'PostGIS geometry, geography, and raster spatial types and functions';


SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: georef_format; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.georef_format (
    key text NOT NULL,
    value text NOT NULL,
    ord integer NOT NULL
);


ALTER TABLE public.georef_format OWNER TO trip;

--
-- Name: itinerary; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.itinerary (
    id integer NOT NULL,
    title text NOT NULL,
    description text,
    user_id integer NOT NULL,
    archived boolean DEFAULT false,
    start timestamp with time zone,
    finish timestamp with time zone
);


ALTER TABLE public.itinerary OWNER TO trip;

--
-- Name: itinerary_route; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.itinerary_route (
    id integer NOT NULL,
    itinerary_id integer NOT NULL,
    name text,
    distance numeric(12,2),
    ascent numeric(9,1),
    descent numeric(9,1),
    lowest numeric(8,1),
    highest numeric(8,1),
    color text
);


ALTER TABLE public.itinerary_route OWNER TO trip;

--
-- Name: itinerary_route_point; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.itinerary_route_point (
    id integer NOT NULL,
    itinerary_route_id integer NOT NULL,
    name text,
    comment text,
    description text,
    symbol text,
    altitude numeric(11,5),
    geog public.geography(Point,4326) NOT NULL
);


ALTER TABLE public.itinerary_route_point OWNER TO trip;

--
-- Name: itinerary_route_point_seq; Type: SEQUENCE; Schema: public; Owner: trip
--

CREATE SEQUENCE public.itinerary_route_point_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.itinerary_route_point_seq OWNER TO trip;

--
-- Name: itinerary_route_point_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: trip
--

ALTER SEQUENCE public.itinerary_route_point_seq OWNED BY public.itinerary_route_point.id;


--
-- Name: itinerary_route_seq; Type: SEQUENCE; Schema: public; Owner: trip
--

CREATE SEQUENCE public.itinerary_route_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.itinerary_route_seq OWNER TO trip;

--
-- Name: itinerary_route_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: trip
--

ALTER SEQUENCE public.itinerary_route_seq OWNED BY public.itinerary_route.id;


--
-- Name: itinerary_seq; Type: SEQUENCE; Schema: public; Owner: trip
--

CREATE SEQUENCE public.itinerary_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.itinerary_seq OWNER TO trip;

--
-- Name: itinerary_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: trip
--

ALTER SEQUENCE public.itinerary_seq OWNED BY public.itinerary.id;


--
-- Name: itinerary_sharing; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.itinerary_sharing (
    itinerary_id integer NOT NULL,
    shared_to_id integer NOT NULL,
    active boolean
);


ALTER TABLE public.itinerary_sharing OWNER TO trip;

--
-- Name: itinerary_track; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.itinerary_track (
    id integer NOT NULL,
    itinerary_id integer NOT NULL,
    name text,
    color text,
    distance numeric(12,2),
    ascent numeric(9,1),
    descent numeric(9,1),
    lowest numeric(8,1),
    highest numeric(8,1)
);


ALTER TABLE public.itinerary_track OWNER TO trip;

--
-- Name: itinerary_track_point; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.itinerary_track_point (
    id integer NOT NULL,
    itinerary_track_segment_id integer NOT NULL,
    "time" timestamp with time zone,
    hdop numeric(6,1),
    altitude numeric(11,5),
    geog public.geography(Point,4326) NOT NULL
);


ALTER TABLE public.itinerary_track_point OWNER TO trip;

--
-- Name: itinerary_track_point_seq; Type: SEQUENCE; Schema: public; Owner: trip
--

CREATE SEQUENCE public.itinerary_track_point_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.itinerary_track_point_seq OWNER TO trip;

--
-- Name: itinerary_track_point_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: trip
--

ALTER SEQUENCE public.itinerary_track_point_seq OWNED BY public.itinerary_track_point.id;


--
-- Name: itinerary_track_segment; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.itinerary_track_segment (
    id integer NOT NULL,
    itinerary_track_id integer NOT NULL,
    distance numeric(12,2),
    ascent numeric(9,1),
    descent numeric(9,1),
    lowest numeric(8,1),
    highest numeric(8,1)
);


ALTER TABLE public.itinerary_track_segment OWNER TO trip;

--
-- Name: itinerary_track_segment_seq; Type: SEQUENCE; Schema: public; Owner: trip
--

CREATE SEQUENCE public.itinerary_track_segment_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.itinerary_track_segment_seq OWNER TO trip;

--
-- Name: itinerary_track_segment_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: trip
--

ALTER SEQUENCE public.itinerary_track_segment_seq OWNED BY public.itinerary_track_segment.id;


--
-- Name: itinerary_track_seq; Type: SEQUENCE; Schema: public; Owner: trip
--

CREATE SEQUENCE public.itinerary_track_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.itinerary_track_seq OWNER TO trip;

--
-- Name: itinerary_track_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: trip
--

ALTER SEQUENCE public.itinerary_track_seq OWNED BY public.itinerary_track.id;


--
-- Name: itinerary_waypoint; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.itinerary_waypoint (
    id integer NOT NULL,
    itinerary_id integer NOT NULL,
    name text,
    "time" timestamp with time zone,
    comment text,
    symbol text,
    altitude numeric(11,5),
    description text,
    type text,
    avg_samples integer,
    geog public.geography(Point,4326) NOT NULL,
    extended_attributes text
);


ALTER TABLE public.itinerary_waypoint OWNER TO trip;

--
-- Name: itinerary_waypoint_seq; Type: SEQUENCE; Schema: public; Owner: trip
--

CREATE SEQUENCE public.itinerary_waypoint_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.itinerary_waypoint_seq OWNER TO trip;

--
-- Name: itinerary_waypoint_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: trip
--

ALTER SEQUENCE public.itinerary_waypoint_seq OWNED BY public.itinerary_waypoint.id;


--
-- Name: location_seq; Type: SEQUENCE; Schema: public; Owner: trip
--

CREATE SEQUENCE public.location_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.location_seq OWNER TO trip;

--
-- Name: location; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.location (
    id integer DEFAULT nextval('public.location_seq'::regclass) NOT NULL,
    user_id integer NOT NULL,
    "time" timestamp with time zone DEFAULT now() NOT NULL,
    hdop numeric(6,1),
    altitude numeric(11,5),
    speed numeric(6,1),
    bearing numeric(11,5),
    sat smallint,
    provider text,
    battery numeric(4,1),
    note text,
    geog public.geography(Point,4326) NOT NULL
);


ALTER TABLE public.location OWNER TO trip;

--
-- Name: location_sharing; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.location_sharing (
    shared_by_id integer NOT NULL,
    shared_to_id integer NOT NULL,
    recent_minutes integer,
    max_minutes integer,
    active boolean
);


ALTER TABLE public.location_sharing OWNER TO trip;

--
-- Name: path_color; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.path_color (
    key text NOT NULL,
    value text NOT NULL,
    html_code text
);


ALTER TABLE public.path_color OWNER TO trip;

--
-- Name: role; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.role (
    id integer NOT NULL,
    name text NOT NULL
);


ALTER TABLE public.role OWNER TO trip;

--
-- Name: role_seq; Type: SEQUENCE; Schema: public; Owner: trip
--

CREATE SEQUENCE public.role_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.role_seq OWNER TO trip;

--
-- Name: role_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: trip
--

ALTER SEQUENCE public.role_seq OWNED BY public.role.id;


--
-- Name: session; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.session (
    id uuid NOT NULL,
    user_id integer NOT NULL,
    updated timestamp without time zone NOT NULL
);


ALTER TABLE public.session OWNER TO trip;

--
-- Name: session_data; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.session_data (
    session_id uuid NOT NULL,
    key text NOT NULL,
    value text
);


ALTER TABLE public.session_data OWNER TO trip;

--
-- Name: tile; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.tile (
    server_id integer DEFAULT 0 NOT NULL,
    x integer NOT NULL,
    y integer NOT NULL,
    z smallint NOT NULL,
    image bytea,
    updated timestamp without time zone DEFAULT now() NOT NULL,
    expires timestamp without time zone NOT NULL
);


ALTER TABLE public.tile OWNER TO trip;

--
-- Name: tile_download_seq; Type: SEQUENCE; Schema: public; Owner: trip
--

CREATE SEQUENCE public.tile_download_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tile_download_seq OWNER TO trip;

--
-- Name: tile_metric; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.tile_metric (
    "time" timestamp with time zone DEFAULT now() NOT NULL,
    count integer NOT NULL
);


ALTER TABLE public.tile_metric OWNER TO trip;

--
-- Name: user_role; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.user_role (
    user_id integer NOT NULL,
    role_id integer NOT NULL
);


ALTER TABLE public.user_role OWNER TO trip;

--
-- Name: usertable_seq; Type: SEQUENCE; Schema: public; Owner: trip
--

CREATE SEQUENCE public.usertable_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.usertable_seq OWNER TO trip;

--
-- Name: usertable; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.usertable (
    id integer DEFAULT nextval('public.usertable_seq'::regclass) NOT NULL,
    firstname text NOT NULL,
    lastname text NOT NULL,
    email text NOT NULL,
    uuid uuid NOT NULL,
    password text NOT NULL,
    nickname text NOT NULL,
    tl_settings text
);


ALTER TABLE public.usertable OWNER TO trip;

--
-- Name: waypoint_symbol; Type: TABLE; Schema: public; Owner: trip
--

CREATE TABLE public.waypoint_symbol (
    key text NOT NULL,
    value text NOT NULL
);


ALTER TABLE public.waypoint_symbol OWNER TO trip;

--
-- Name: itinerary id; Type: DEFAULT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary ALTER COLUMN id SET DEFAULT nextval('public.itinerary_seq'::regclass);


--
-- Name: itinerary_route id; Type: DEFAULT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_route ALTER COLUMN id SET DEFAULT nextval('public.itinerary_route_seq'::regclass);


--
-- Name: itinerary_route_point id; Type: DEFAULT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_route_point ALTER COLUMN id SET DEFAULT nextval('public.itinerary_route_point_seq'::regclass);


--
-- Name: itinerary_track id; Type: DEFAULT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_track ALTER COLUMN id SET DEFAULT nextval('public.itinerary_track_seq'::regclass);


--
-- Name: itinerary_track_point id; Type: DEFAULT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_track_point ALTER COLUMN id SET DEFAULT nextval('public.itinerary_track_point_seq'::regclass);


--
-- Name: itinerary_track_segment id; Type: DEFAULT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_track_segment ALTER COLUMN id SET DEFAULT nextval('public.itinerary_track_segment_seq'::regclass);


--
-- Name: itinerary_waypoint id; Type: DEFAULT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_waypoint ALTER COLUMN id SET DEFAULT nextval('public.itinerary_waypoint_seq'::regclass);


--
-- Name: role id; Type: DEFAULT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.role ALTER COLUMN id SET DEFAULT nextval('public.role_seq'::regclass);


--
-- Data for Name: georef_format; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.georef_format (key, value, ord) FROM stdin;
%d°%M′%S″%c	DMS+	1
%d°%M′%c	DM+	2
%d°%c	D+	3
%i%d	D	4
%p%d	±D	5
plus+code	OLC plus+code	6
osgb36	OS GB 1936 (BNG)	7
%dd%M'%S"%c	Proj4	8
%c%D° %M	QLandkarte GT	9
%c%d°%M′%S″	+DMS	10
%c%d°	+D	12
%d° %M′ %S″ %c	D M S +	13
%d° %M′ %c	D M +	14
%d° %c	D +	15
%c %d° %M′ %S″	+ D M S	16
%c %d° %M′	+ D M	17
%c %d°	+ D	18
%d %m %s%c	Plain DMS+	18
%d %m%c	Plain DM+	19
%d%c	Plain D+	20
%c%d %m %s	Plain +DMS	21
%c%d %m	Plain +DM	22
%c%d	Plain +D	23
IrishGrid	Irish Grid	24
ITM	Irish Transverse Mercator	25
%c%d°%M′	+DM	11
\.


--
-- Data for Name: itinerary; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.itinerary (id, title, description, user_id, archived, start, finish) FROM stdin;
929	Itinerary for tests - DO NOT DELETE	# Test modified Itinerary\n\n## Lorem ipsum modified too\n\nSo this is my nice little *itinerary description*.\n\n - *Action one*\n - Action two\n\n    Code **indented**\n\n---\n\n\n    <script>alert('xss'); </script>\n\n> Block quote\n\nend\n	29	f	2015-11-22 00:00:00+00	\N
1744	Test itinerary - DO NOT DELETE	## Note\n\nUsed to add waypoints to.  The waypoints can be deleted.\n	29	f	2016-10-31 00:00:00+00	\N
982	Owned by admin	Test	1	f	2016-10-29 23:00:00+00	\N
983	Owned by orange	test	791	f	2016-10-29 23:00:00+00	\N
2419	Eiffel Tower	\N	29	f	\N	\N
2425	Test Itinerary - DO NOT DELETE	Tests for editing tracks	29	f	\N	\N
2333	Test itinerary 2333 - DO NOT DELETE	# Test modified Itinerary\n\n## Lorem ipsum modified too\n	29	f	\N	\N
2430	Test itinerary for itinerary searches - DO NOT DELETE	\N	29	f	2020-02-01 00:00:00+00	2020-02-14 00:00:00+00
2432	Test 10	\N	29	f	\N	\N
2433	Test 20	\N	29	f	\N	\N
2434	Test 11	\N	29	f	\N	\N
2435	Test 12	\N	29	f	\N	\N
2436	Test 13	\N	29	f	\N	\N
2437	Test 14	\N	29	f	\N	\N
2438	Test 15	\N	29	f	\N	\N
2439	Test 16	\N	29	f	\N	\N
2440	Test 17	\N	29	f	\N	\N
2441	Test 18	\N	29	f	\N	\N
2442	Test 19	\N	29	f	\N	\N
\.


--
-- Data for Name: itinerary_route; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.itinerary_route (id, itinerary_id, name, distance, ascent, descent, lowest, highest, color) FROM stdin;
8303	929	Test One	\N	\N	\N	\N	\N	\N
8309	983	Test One	\N	\N	\N	\N	\N	\N
8310	983	Modified route name	\N	\N	\N	\N	\N	\N
8312	2425	Test route 01	60.33	1194.0	1445.2	41.4	420.2	Green
8313	2425	Test route 02	60.33	1445.2	1194.0	41.4	420.2	Blue
8304	929	Modified route name	\N	\N	\N	\N	\N	\N
8320	2430	\N	18.26	60.0	53.0	31.0	73.0	\N
8319	2430	Route 01	13.22	81.0	91.0	30.0	69.0	Blue
8321	2430	Route 02	20.46	74.0	131.0	31.0	121.0	DarkRed
8326	2432	Route 01	13.22	81.0	91.0	30.0	69.0	Blue
8327	2432	\N	18.26	60.0	53.0	31.0	73.0	\N
8328	2432	Route 02	20.46	74.0	131.0	31.0	121.0	DarkRed
8329	2433	Route 01	13.22	81.0	91.0	30.0	69.0	Blue
8330	2433	Route 02	20.46	74.0	131.0	31.0	121.0	DarkRed
8331	2433	\N	18.26	60.0	53.0	31.0	73.0	\N
8332	2434	Route 01	13.22	81.0	91.0	30.0	69.0	Blue
8333	2434	\N	18.26	60.0	53.0	31.0	73.0	\N
8334	2434	Route 02	20.46	74.0	131.0	31.0	121.0	DarkRed
8335	2435	Route 01	13.22	81.0	91.0	30.0	69.0	Blue
8336	2435	\N	18.26	60.0	53.0	31.0	73.0	\N
8337	2435	Route 02	20.46	74.0	131.0	31.0	121.0	DarkRed
8338	2436	Route 01	13.22	81.0	91.0	30.0	69.0	Blue
8339	2436	Route 02	20.46	74.0	131.0	31.0	121.0	DarkRed
8340	2436	\N	18.26	60.0	53.0	31.0	73.0	\N
8341	2437	Route 01	13.22	81.0	91.0	30.0	69.0	Blue
8342	2437	\N	18.26	60.0	53.0	31.0	73.0	\N
8343	2437	Route 02	20.46	74.0	131.0	31.0	121.0	DarkRed
8344	2438	Route 01	13.22	81.0	91.0	30.0	69.0	Blue
8345	2438	\N	18.26	60.0	53.0	31.0	73.0	\N
8346	2438	Route 02	20.46	74.0	131.0	31.0	121.0	DarkRed
8347	2439	Route 02	20.46	74.0	131.0	31.0	121.0	DarkRed
8348	2439	\N	18.26	60.0	53.0	31.0	73.0	\N
8349	2439	Route 01	13.22	81.0	91.0	30.0	69.0	Blue
8350	2440	Route 01	13.22	81.0	91.0	30.0	69.0	Blue
8351	2440	\N	18.26	60.0	53.0	31.0	73.0	\N
8352	2440	Route 02	20.46	74.0	131.0	31.0	121.0	DarkRed
8353	2441	Route 01	13.22	81.0	91.0	30.0	69.0	Blue
8354	2441	\N	18.26	60.0	53.0	31.0	73.0	\N
8355	2441	Route 02	20.46	74.0	131.0	31.0	121.0	DarkRed
8356	2442	Route 01	13.22	81.0	91.0	30.0	69.0	Blue
8357	2442	\N	18.26	60.0	53.0	31.0	73.0	\N
8358	2442	Route 02	20.46	74.0	131.0	31.0	121.0	DarkRed
\.


--
-- Data for Name: itinerary_route_point; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.itinerary_route_point (id, itinerary_route_id, name, comment, description, symbol, altitude, geog) FROM stdin;
91539	8309	001	p1	p1	Small City	100.00000	0101000020E6100000C53D963E74C250C0C328081EDF644F40
91540	8309	002	p2	p2	Small City	\N	0101000020E6100000CD7344BE4B735740041E1840F8025040
91541	8309	003	p3	p3	Small City	\N	0101000020E610000061A92EE0E5EB614082E15CC30C0540C0
91542	8309	004	p4	p4	Small City	\N	0101000020E6100000ECA2E8818F95394095D233BDC4B642C0
91543	8309	005	p5	p5	Small City	\N	0101000020E610000096CFF23CB8894EC0DE57E542E5CD49C0
91544	8309	006	p6	p6	Small City	\N	0101000020E6100000CB67791EDC275DC073309B00C3F24D40
91545	8310	001	p1	p1	Small City	\N	0101000020E61000001E87C1FC15FA45C05CCAF962EF893E40
91546	8310	002	p2	p2	Small City	\N	0101000020E6100000D48041D2A7D52640C173EFE192D140C0
91547	8310	003	p3	p3	Small City	\N	0101000020E61000007D5D86FF74A1524043AA285E65E93240
91548	8310	004	p4	p4	Small City	\N	0101000020E6100000F7CC920035475640A69BC420B0104C40
91549	8310	005	p5	p5	Small City	\N	0101000020E61000008202EFE4D30F3B4093C9A99D61BE3140
91506	8303	001	p1	p1	Small City	100.00000	0101000020E6100000C53D963E74C250C0C328081EDF644F40
91507	8303	002	p2	p2	Small City	\N	0101000020E6100000CD7344BE4B735740041E1840F8025040
91508	8303	003	p3	p3	Small City	\N	0101000020E610000061A92EE0E5EB614082E15CC30C0540C0
91509	8303	004	p4	p4	Small City	\N	0101000020E6100000ECA2E8818F95394095D233BDC4B642C0
91510	8303	005	p5	p5	Small City	\N	0101000020E610000096CFF23CB8894EC0DE57E542E5CD49C0
91511	8303	006	p6	p6	Small City	\N	0101000020E6100000CB67791EDC275DC073309B00C3F24D40
91512	8304	001	p1	p1	Small City	\N	0101000020E61000001E87C1FC15FA45C05CCAF962EF893E40
91513	8304	002	p2	p2	Small City	\N	0101000020E6100000D48041D2A7D52640C173EFE192D140C0
91514	8304	003	p3	p3	Small City	\N	0101000020E61000007D5D86FF74A1524043AA285E65E93240
91515	8304	004	p4	p4	Small City	\N	0101000020E6100000F7CC920035475640A69BC420B0104C40
91516	8304	005	p5	p5	Small City	\N	0101000020E61000008202EFE4D30F3B4093C9A99D61BE3140
91573	8312	001	p1	p1	Small City	292.60000	0101000020E6100000C11A67D3114010C0BDFBE3BD6A474940
91574	8312	002	p2	p2	Small City	170.60000	0101000020E6100000527E52EDD34110C06939D0436D494940
91575	8312	003	p3	p3	Small City	177.60000	0101000020E6100000FB3A70CE883210C0F9A23D5E484B4940
91576	8312	004	p4	p4	Small City	284.00000	0101000020E610000003249A40111B10C09C1727BEDA4B4940
91577	8312	005	p5	p5	Small City	150.30000	0101000020E610000064CF9ECBD40410C029CC7B9C694C4940
91578	8312	006	p6	p6	Small City	244.10000	0101000020E61000006CEBA7FFACD90FC0352905DD5E4C4940
91579	8312	007	p7	p7	Small City	217.20000	0101000020E6100000D47FD6FCF8AB0FC0185DDE1CAE4B4940
91580	8312	008	p8	p8	Small City	385.90000	0101000020E61000002123A0C211840FC0134548DDCE4A4940
91581	8312	009	p9	p9	Small City	326.20000	0101000020E6100000331AF9BCE2490FC0F7729F1C054A4940
91582	8312	010	p10	p10	Small City	102.40000	0101000020E6100000490ED8D5E4290FC0F4C308E1D1484940
91583	8312	011	p11	p11	Small City	56.40000	0101000020E6100000857B65DEAAEB0EC0FB90B75CFD4A4940
91584	8312	012	p12	p12	Small City	121.60000	0101000020E6100000527E52EDD3D10EC09259BDC3ED4C4940
91585	8312	013	p13	p13	Small City	410.50000	0101000020E610000044F9821612D00EC010C99063EB4F4940
91586	8312	014	p14	p14	Small City	317.60000	0101000020E610000014ED2AA4FCE40EC0F86F5E9CF8524940
91587	8312	015	p15	p15	Small City	420.20000	0101000020E6100000E5EC9DD156E50EC0D388997D1E594940
91588	8312	016	p16	p16	Small City	218.90000	0101000020E61000000740DCD5AB080FC064062AE3DF5B4940
91589	8312	017	p17	p17	Small City	283.70000	0101000020E61000008255F5F23B2D0FC0A8E0F08288604940
91590	8312	018	p18	p18	Small City	162.70000	0101000020E610000047E867EA756B0FC0020CCB9F6F5B4940
91591	8312	019	p19	p19	Small City	336.40000	0101000020E6100000D15B3CBCE7800FC0EB6F09C03F554940
91592	8312	020	p20	p20	Small City	339.20000	0101000020E610000032CC09DAE4B00FC0B41F2922C3524940
91593	8312	021	p21	p21	Small City	62.00000	0101000020E61000007BF5F1D0770710C0C47C7901F64F4940
91594	8312	022	p22	p22	Small City	182.10000	0101000020E61000009599D2FA5B3210C0C87C40A033514940
91595	8312	023	p23	p23	Small City	41.40000	0101000020E610000068925852EE2E10C047B071FDBB4E4940
91596	8313	023	p23	p23	Small City	41.40000	0101000020E610000068925852EE2E10C047B071FDBB4E4940
91597	8313	022	p22	p22	Small City	182.10000	0101000020E61000009599D2FA5B3210C0C87C40A033514940
91598	8313	021	p21	p21	Small City	62.00000	0101000020E61000007BF5F1D0770710C0C47C7901F64F4940
91599	8313	020	p20	p20	Small City	339.20000	0101000020E610000032CC09DAE4B00FC0B41F2922C3524940
91600	8313	019	p19	p19	Small City	336.40000	0101000020E6100000D15B3CBCE7800FC0EB6F09C03F554940
91601	8313	018	p18	p18	Small City	162.70000	0101000020E610000047E867EA756B0FC0020CCB9F6F5B4940
91602	8313	017	p17	p17	Small City	283.70000	0101000020E61000008255F5F23B2D0FC0A8E0F08288604940
91603	8313	016	p16	p16	Small City	218.90000	0101000020E61000000740DCD5AB080FC064062AE3DF5B4940
91604	8313	015	p15	p15	Small City	420.20000	0101000020E6100000E5EC9DD156E50EC0D388997D1E594940
91605	8313	014	p14	p14	Small City	317.60000	0101000020E610000014ED2AA4FCE40EC0F86F5E9CF8524940
91606	8313	013	p13	p13	Small City	410.50000	0101000020E610000044F9821612D00EC010C99063EB4F4940
91607	8313	012	p12	p12	Small City	121.60000	0101000020E6100000527E52EDD3D10EC09259BDC3ED4C4940
91608	8313	011	p11	p11	Small City	56.40000	0101000020E6100000857B65DEAAEB0EC0FB90B75CFD4A4940
91609	8313	010	p10	p10	Small City	102.40000	0101000020E6100000490ED8D5E4290FC0F4C308E1D1484940
91610	8313	009	p9	p9	Small City	326.20000	0101000020E6100000331AF9BCE2490FC0F7729F1C054A4940
91611	8313	008	p8	p8	Small City	385.90000	0101000020E61000002123A0C211840FC0134548DDCE4A4940
91612	8313	007	p7	p7	Small City	217.20000	0101000020E6100000D47FD6FCF8AB0FC0185DDE1CAE4B4940
91613	8313	006	p6	p6	Small City	244.10000	0101000020E61000006CEBA7FFACD90FC0352905DD5E4C4940
91614	8313	005	p5	p5	Small City	150.30000	0101000020E610000064CF9ECBD40410C029CC7B9C694C4940
91615	8313	004	p4	p4	Small City	284.00000	0101000020E610000003249A40111B10C09C1727BEDA4B4940
91616	8313	003	p3	p3	Small City	177.60000	0101000020E6100000FB3A70CE883210C0F9A23D5E484B4940
91617	8313	002	p2	p2	Small City	170.60000	0101000020E6100000527E52EDD34110C06939D0436D494940
91618	8313	001	p1	p1	Small City	292.60000	0101000020E6100000C11A67D3114010C0BDFBE3BD6A474940
91763	8319	\N	\N	\N	\N	57.00000	0101000020E610000001000000835B024019096EA3D46D4840
91764	8319	\N	\N	\N	\N	31.00000	0101000020E610000001000000E6520240966D080E266E4840
91765	8319	\N	\N	\N	\N	50.00000	0101000020E6100000010000001056024084F69977776E4840
91766	8319	\N	\N	\N	\N	57.00000	0101000020E610000001000000EE5902404D40AAECBB6E4840
91767	8319	\N	\N	\N	\N	69.00000	0101000020E6100000010000009F5D0240F1633F211C6F4840
91768	8319	\N	\N	\N	\N	63.00000	0101000020E610000001000000645C0240D7E83039E06F4840
91769	8319	\N	\N	\N	\N	50.00000	0101000020E6100000010000000E76024033FFFB7A556F4840
91770	8319	\N	\N	\N	\N	34.00000	0101000020E610000001000000508E024065DC7960DB6E4840
91771	8319	\N	\N	\N	\N	30.00000	0101000020E6100000010000008B8F02406EBF0C9F9A6E4840
91772	8319	\N	\N	\N	\N	37.00000	0101000020E610000001000000BDC6024033A43095BC6D4840
91773	8319	\N	\N	\N	\N	49.00000	0101000020E610000001000000FDD10240266E1B3ADD6E4840
91774	8319	\N	\N	\N	\N	44.00000	0101000020E610000000000000EEE00240EAC63B6CA96E4840
91775	8319	\N	\N	\N	\N	41.00000	0101000020E61000000100000050E80240F8C83C14046F4840
91776	8319	\N	\N	\N	\N	40.00000	0101000020E610000001000000F3EA0240D095822DEA6E4840
91777	8319	\N	\N	\N	\N	64.00000	0101000020E6100000010000002018034096A347C4736E4840
91778	8319	\N	\N	\N	\N	51.00000	0101000020E610000001000000C22A0340AE92DC969F6C4840
91779	8319	\N	\N	\N	\N	47.00000	0101000020E6100000010000003350034057A8B910686C4840
91780	8320	\N	\N	\N	\N	37.00000	0101000020E61000000100000094FF0140465CD3459A714840
91781	8320	\N	\N	\N	\N	37.00000	0101000020E610000001000000823E0240E6E15B4167704840
91782	8320	\N	\N	\N	\N	50.00000	0101000020E61000000100000090120240DC4204B9786C4840
91783	8320	\N	\N	\N	\N	31.00000	0101000020E610000001000000BE2F02403FE31D01506C4840
91784	8320	\N	\N	\N	\N	36.00000	0101000020E61000000100000032520240613E66C1296E4840
91785	8320	\N	\N	\N	\N	39.00000	0101000020E6100000010000003A590240FA0613F2F56D4840
91786	8320	\N	\N	\N	\N	44.00000	0101000020E610000001000000BC4F0240DCBE11355E6D4840
91787	8320	\N	\N	\N	\N	39.00000	0101000020E610000001000000785702406CA7F710E46C4840
91788	8320	\N	\N	\N	\N	44.00000	0101000020E610000001000000167D024013A9EF63326C4840
91789	8320	\N	\N	\N	\N	73.00000	0101000020E610000001000000428D024059A2876F206B4840
91790	8320	\N	\N	\N	\N	70.00000	0101000020E6100000010000000C9602409D1EC53E2F6B4840
91791	8320	\N	\N	\N	\N	62.00000	0101000020E6100000010000003ECD0240A63015C32F6A4840
91792	8320	\N	\N	\N	\N	44.00000	0101000020E610000001000000C40A0340AFBABC65846B4840
91793	8321	\N	\N	\N	\N	121.00000	0101000020E610000001000000F813024023310B9E04674840
91794	8321	\N	\N	\N	\N	90.00000	0101000020E6100000010000001A100240B8678CB755684840
91795	8321	\N	\N	\N	\N	83.00000	0101000020E610000001000000951C024030FC4134D9684840
91796	8321	\N	\N	\N	\N	66.00000	0101000020E61000000100000072300240827D755016694840
91797	8321	\N	\N	\N	\N	39.00000	0101000020E610000001000000B02E02404E88D5287C694840
91798	8321	\N	\N	\N	\N	43.00000	0101000020E610000001000000274E02402A10E24A996A4840
91799	8321	\N	\N	\N	\N	44.00000	0101000020E610000001000000345F02409D1EC53E2F6B4840
91800	8321	\N	\N	\N	\N	52.00000	0101000020E610000001000000556B0240AFBABC65846B4840
91801	8321	\N	\N	\N	\N	48.00000	0101000020E610000001000000336F0240AC557EE8966B4840
91802	8321	\N	\N	\N	\N	46.00000	0101000020E610000001000000DC6B02407EDD2119DF6B4840
91803	8321	\N	\N	\N	\N	40.00000	0101000020E610000001000000936902400067A8AD856C4840
91804	8321	\N	\N	\N	\N	39.00000	0101000020E6100000010000006A560240656FBEEAE56C4840
91805	8321	\N	\N	\N	\N	44.00000	0101000020E610000001000000624F02409D1C8DE8616D4840
91806	8321	\N	\N	\N	\N	31.00000	0101000020E610000001000000B9520240B5AEC2E1B86D4840
91807	8321	\N	\N	\N	\N	39.00000	0101000020E610000001000000595802407D8FC5CBF76D4840
91808	8321	\N	\N	\N	\N	35.00000	0101000020E6100000010000C0665D02408120235E286E4840
91809	8321	\N	\N	\N	\N	41.00000	0101000020E610000001000000D6710240B31B6831586D4840
91810	8321	\N	\N	\N	\N	37.00000	0101000020E6100000010000C0BE7D02407CE7303D4B6D4840
91811	8321	\N	\N	\N	\N	41.00000	0101000020E6100000010000808E8402409BB58239456D4840
91812	8321	\N	\N	\N	\N	44.00000	0101000020E6100000010000C0E58302403CC6A1D7E66C4840
91813	8321	\N	\N	\N	\N	43.00000	0101000020E6100000010000C07788024044A82D87686C4840
91814	8321	\N	\N	\N	\N	45.00000	0101000020E610000001000080849D024078DD93A9FB6C4840
91815	8321	\N	\N	\N	\N	45.00000	0101000020E61000000100000028C502402B486514096D4840
91816	8321	\N	\N	\N	\N	32.00000	0101000020E610000001000000F4DA02406EA961CCB56C4840
91817	8321	\N	\N	\N	\N	43.00000	0101000020E610000000000000EAF30240BBD2A2E53C6D4840
91818	8321	\N	\N	\N	\N	44.00000	0101000020E610000001000000D3FB02408E01B1A10E6D4840
91819	8321	\N	\N	\N	\N	51.00000	0101000020E610000001000000C22A0340F1D645A2926C4840
91820	8321	\N	\N	\N	\N	50.00000	0101000020E6100000010000006E5103403519D7F55C6C4840
91821	8321	\N	\N	\N	\N	52.00000	0101000020E610000001000000D65203400231D851ED6C4840
91822	8321	\N	\N	\N	\N	58.00000	0101000020E6100000010000003350034000D595815A6D4840
91823	8321	\N	\N	\N	\N	64.00000	0101000020E6100000000000009764034080D22A528E6D4840
91898	8326	\N	\N	\N	\N	57.00000	0101000020E610000004000000835B02401B096EA3D46D4840
91899	8327	\N	\N	\N	\N	37.00000	0101000020E61000000800000094FF0140455CD3459A714840
91901	8326	\N	\N	\N	\N	31.00000	0101000020E610000007000000E6520240926D080E266E4840
91900	8328	\N	\N	\N	\N	121.00000	0101000020E610000006000000F813024023310B9E04674840
91902	8327	\N	\N	\N	\N	37.00000	0101000020E61000000A000000823E0240E9E15B4167704840
91903	8326	\N	\N	\N	\N	50.00000	0101000020E61000000B0000001056024081F69977776E4840
91904	8328	\N	\N	\N	\N	90.00000	0101000020E6100000F9FFFFFF19100240BE678CB755684840
91905	8327	\N	\N	\N	\N	50.00000	0101000020E61000000B00000090120240D84204B9786C4840
91906	8326	\N	\N	\N	\N	57.00000	0101000020E610000001000000EE5902404E40AAECBB6E4840
91907	8328	\N	\N	\N	\N	83.00000	0101000020E610000002000000951C024031FC4134D9684840
91908	8327	\N	\N	\N	\N	31.00000	0101000020E6100000F6FFFFFFBD2F02403BE31D01506C4840
91909	8328	\N	\N	\N	\N	66.00000	0101000020E6100000FFFFFFFF71300240857D755016694840
91910	8326	\N	\N	\N	\N	69.00000	0101000020E6100000060000009F5D0240F0633F211C6F4840
91911	8327	\N	\N	\N	\N	36.00000	0101000020E6100000FFFFFFFF315202405D3E66C1296E4840
91912	8328	\N	\N	\N	\N	39.00000	0101000020E61000000B000000B02E02405288D5287C694840
91913	8326	\N	\N	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C0240DAE83039E06F4840
91914	8327	\N	\N	\N	\N	39.00000	0101000020E6100000F9FFFFFF39590240010713F2F56D4840
91915	8328	\N	\N	\N	\N	43.00000	0101000020E610000001000000274E02402910E24A996A4840
91916	8327	\N	\N	\N	\N	44.00000	0101000020E610000003000000BC4F0240DBBE11355E6D4840
91917	8326	\N	\N	\N	\N	50.00000	0101000020E6100000010000000E7602402EFFFB7A556F4840
91918	8328	\N	\N	\N	\N	44.00000	0101000020E610000008000000345F02409F1EC53E2F6B4840
91919	8327	\N	\N	\N	\N	39.00000	0101000020E610000006000000785702406BA7F710E46C4840
91920	8326	\N	\N	\N	\N	34.00000	0101000020E61000000B000000508E024067DC7960DB6E4840
91921	8328	\N	\N	\N	\N	52.00000	0101000020E610000002000000556B0240A9BABC65846B4840
91922	8327	\N	\N	\N	\N	44.00000	0101000020E6100000FCFFFFFF157D024012A9EF63326C4840
91923	8326	\N	\N	\N	\N	30.00000	0101000020E6100000FEFFFFFF8A8F024069BF0C9F9A6E4840
91924	8328	\N	\N	\N	\N	48.00000	0101000020E6100000F8FFFFFF326F0240AE557EE8966B4840
91925	8327	\N	\N	\N	\N	73.00000	0101000020E61000000A000000428D024056A2876F206B4840
91926	8326	\N	\N	\N	\N	37.00000	0101000020E6100000FCFFFFFFBCC6024038A43095BC6D4840
91927	8328	\N	\N	\N	\N	46.00000	0101000020E610000003000000DC6B02407ADD2119DF6B4840
91928	8326	\N	\N	\N	\N	49.00000	0101000020E6100000FCFFFFFFFCD10240216E1B3ADD6E4840
91929	8327	\N	\N	\N	\N	70.00000	0101000020E6100000F8FFFFFF0B9602409F1EC53E2F6B4840
91930	8328	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFF926902400467A8AD856C4840
91931	8326	\N	\N	\N	\N	44.00000	0101000020E610000001000000EEE00240E5C63B6CA96E4840
91932	8327	\N	\N	\N	\N	62.00000	0101000020E6100000F6FFFFFF3DCD0240A43015C32F6A4840
91933	8328	\N	\N	\N	\N	39.00000	0101000020E6100000040000006A5602405E6FBEEAE56C4840
91934	8327	\N	\N	\N	\N	44.00000	0101000020E6100000FDFFFFFFC30A0340A9BABC65846B4840
91935	8326	\N	\N	\N	\N	41.00000	0101000020E61000000B00000050E80240F4C83C14046F4840
91936	8328	\N	\N	\N	\N	44.00000	0101000020E61000000A000000624F02409E1C8DE8616D4840
91937	8326	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFFF2EA0240D695822DEA6E4840
91938	8328	\N	\N	\N	\N	31.00000	0101000020E6100000FFFFFFFFB8520240B1AEC2E1B86D4840
91939	8326	\N	\N	\N	\N	64.00000	0101000020E6100000000000002018034090A347C4736E4840
91940	8328	\N	\N	\N	\N	39.00000	0101000020E6100000FFFFFFFF58580240798FC5CBF76D4840
91941	8326	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340AE92DC969F6C4840
91942	8328	\N	\N	\N	\N	35.00000	0101000020E6100000FDFFFFBF665D02408320235E286E4840
91943	8326	\N	\N	\N	\N	47.00000	0101000020E6100000F8FFFFFF325003405AA8B910686C4840
91944	8328	\N	\N	\N	\N	41.00000	0101000020E6100000FCFFFFFFD5710240AC1B6831586D4840
91945	8328	\N	\N	\N	\N	37.00000	0101000020E6100000020000C0BE7D024075E7303D4B6D4840
91946	8328	\N	\N	\N	\N	41.00000	0101000020E6100000090000808E84024096B58239456D4840
91947	8328	\N	\N	\N	\N	44.00000	0101000020E6100000030000C0E583024042C6A1D7E66C4840
91948	8328	\N	\N	\N	\N	43.00000	0101000020E6100000020000C07788024041A82D87686C4840
91949	8328	\N	\N	\N	\N	45.00000	0101000020E610000005000080849D02407DDD93A9FB6C4840
91950	8328	\N	\N	\N	\N	45.00000	0101000020E6100000FAFFFFFF27C502402E486514096D4840
91951	8328	\N	\N	\N	\N	32.00000	0101000020E610000008000000F4DA02406AA961CCB56C4840
91952	8328	\N	\N	\N	\N	43.00000	0101000020E610000004000000EAF30240C2D2A2E53C6D4840
91953	8328	\N	\N	\N	\N	44.00000	0101000020E6100000F8FFFFFFD2FB02408801B1A10E6D4840
91954	8328	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340F6D645A2926C4840
91955	8328	\N	\N	\N	\N	50.00000	0101000020E6100000010000006E5103403919D7F55C6C4840
91956	8328	\N	\N	\N	\N	52.00000	0101000020E6100000FCFFFFFFD55203400731D851ED6C4840
91957	8328	\N	\N	\N	\N	58.00000	0101000020E6100000F8FFFFFF3250034003D595815A6D4840
91958	8328	\N	\N	\N	\N	64.00000	0101000020E6100000F5FFFFFF9664034085D22A528E6D4840
91959	8329	\N	\N	\N	\N	57.00000	0101000020E610000004000000835B02401B096EA3D46D4840
91960	8329	\N	\N	\N	\N	31.00000	0101000020E610000007000000E6520240926D080E266E4840
91961	8329	\N	\N	\N	\N	50.00000	0101000020E61000000B0000001056024081F69977776E4840
91962	8329	\N	\N	\N	\N	57.00000	0101000020E610000001000000EE5902404E40AAECBB6E4840
91963	8330	\N	\N	\N	\N	121.00000	0101000020E610000006000000F813024023310B9E04674840
91964	8329	\N	\N	\N	\N	69.00000	0101000020E6100000060000009F5D0240F0633F211C6F4840
91966	8329	\N	\N	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C0240DAE83039E06F4840
91969	8329	\N	\N	\N	\N	50.00000	0101000020E6100000010000000E7602402EFFFB7A556F4840
91972	8329	\N	\N	\N	\N	34.00000	0101000020E61000000B000000508E024067DC7960DB6E4840
91975	8329	\N	\N	\N	\N	30.00000	0101000020E6100000FEFFFFFF8A8F024069BF0C9F9A6E4840
91978	8329	\N	\N	\N	\N	37.00000	0101000020E6100000FCFFFFFFBCC6024038A43095BC6D4840
91981	8329	\N	\N	\N	\N	49.00000	0101000020E6100000FCFFFFFFFCD10240216E1B3ADD6E4840
91984	8329	\N	\N	\N	\N	44.00000	0101000020E610000001000000EEE00240E5C63B6CA96E4840
91987	8329	\N	\N	\N	\N	41.00000	0101000020E61000000B00000050E80240F4C83C14046F4840
91990	8329	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFFF2EA0240D695822DEA6E4840
91993	8329	\N	\N	\N	\N	64.00000	0101000020E6100000000000002018034090A347C4736E4840
91996	8329	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340AE92DC969F6C4840
91999	8329	\N	\N	\N	\N	47.00000	0101000020E6100000F8FFFFFF325003405AA8B910686C4840
92020	8332	\N	\N	\N	\N	57.00000	0101000020E610000004000000835B02401B096EA3D46D4840
92022	8332	\N	\N	\N	\N	31.00000	0101000020E610000007000000E6520240926D080E266E4840
92024	8332	\N	\N	\N	\N	50.00000	0101000020E61000000B0000001056024081F69977776E4840
92027	8332	\N	\N	\N	\N	57.00000	0101000020E610000001000000EE5902404E40AAECBB6E4840
92030	8332	\N	\N	\N	\N	69.00000	0101000020E6100000060000009F5D0240F0633F211C6F4840
92033	8332	\N	\N	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C0240DAE83039E06F4840
92036	8332	\N	\N	\N	\N	50.00000	0101000020E6100000010000000E7602402EFFFB7A556F4840
92039	8332	\N	\N	\N	\N	34.00000	0101000020E61000000B000000508E024067DC7960DB6E4840
92042	8332	\N	\N	\N	\N	30.00000	0101000020E6100000FEFFFFFF8A8F024069BF0C9F9A6E4840
92045	8332	\N	\N	\N	\N	37.00000	0101000020E6100000FCFFFFFFBCC6024038A43095BC6D4840
92049	8332	\N	\N	\N	\N	49.00000	0101000020E6100000FCFFFFFFFCD10240216E1B3ADD6E4840
92052	8332	\N	\N	\N	\N	44.00000	0101000020E610000001000000EEE00240E5C63B6CA96E4840
92055	8332	\N	\N	\N	\N	41.00000	0101000020E61000000B00000050E80240F4C83C14046F4840
92059	8332	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFFF2EA0240D695822DEA6E4840
92061	8332	\N	\N	\N	\N	64.00000	0101000020E6100000000000002018034090A347C4736E4840
92063	8332	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340AE92DC969F6C4840
92065	8332	\N	\N	\N	\N	47.00000	0101000020E6100000F8FFFFFF325003405AA8B910686C4840
91965	8330	\N	\N	\N	\N	90.00000	0101000020E6100000F9FFFFFF19100240BE678CB755684840
91967	8330	\N	\N	\N	\N	83.00000	0101000020E610000002000000951C024031FC4134D9684840
91971	8330	\N	\N	\N	\N	66.00000	0101000020E6100000FFFFFFFF71300240857D755016694840
91973	8330	\N	\N	\N	\N	39.00000	0101000020E61000000B000000B02E02405288D5287C694840
91976	8330	\N	\N	\N	\N	43.00000	0101000020E610000001000000274E02402910E24A996A4840
91979	8330	\N	\N	\N	\N	44.00000	0101000020E610000008000000345F02409F1EC53E2F6B4840
91982	8330	\N	\N	\N	\N	52.00000	0101000020E610000002000000556B0240A9BABC65846B4840
91985	8330	\N	\N	\N	\N	48.00000	0101000020E6100000F8FFFFFF326F0240AE557EE8966B4840
91988	8330	\N	\N	\N	\N	46.00000	0101000020E610000003000000DC6B02407ADD2119DF6B4840
91991	8330	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFF926902400467A8AD856C4840
91994	8330	\N	\N	\N	\N	39.00000	0101000020E6100000040000006A5602405E6FBEEAE56C4840
91997	8330	\N	\N	\N	\N	44.00000	0101000020E61000000A000000624F02409E1C8DE8616D4840
92000	8330	\N	\N	\N	\N	31.00000	0101000020E6100000FFFFFFFFB8520240B1AEC2E1B86D4840
92002	8330	\N	\N	\N	\N	39.00000	0101000020E6100000FFFFFFFF58580240798FC5CBF76D4840
92004	8330	\N	\N	\N	\N	35.00000	0101000020E6100000FDFFFFBF665D02408320235E286E4840
92005	8330	\N	\N	\N	\N	41.00000	0101000020E6100000FCFFFFFFD5710240AC1B6831586D4840
92006	8330	\N	\N	\N	\N	37.00000	0101000020E6100000020000C0BE7D024075E7303D4B6D4840
92007	8330	\N	\N	\N	\N	41.00000	0101000020E6100000090000808E84024096B58239456D4840
92008	8330	\N	\N	\N	\N	44.00000	0101000020E6100000030000C0E583024042C6A1D7E66C4840
92009	8330	\N	\N	\N	\N	43.00000	0101000020E6100000020000C07788024041A82D87686C4840
92010	8330	\N	\N	\N	\N	45.00000	0101000020E610000005000080849D02407DDD93A9FB6C4840
92011	8330	\N	\N	\N	\N	45.00000	0101000020E6100000FAFFFFFF27C502402E486514096D4840
92012	8330	\N	\N	\N	\N	32.00000	0101000020E610000008000000F4DA02406AA961CCB56C4840
92013	8330	\N	\N	\N	\N	43.00000	0101000020E610000004000000EAF30240C2D2A2E53C6D4840
92014	8330	\N	\N	\N	\N	44.00000	0101000020E6100000F8FFFFFFD2FB02408801B1A10E6D4840
92015	8330	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340F6D645A2926C4840
92016	8330	\N	\N	\N	\N	50.00000	0101000020E6100000010000006E5103403919D7F55C6C4840
92017	8330	\N	\N	\N	\N	52.00000	0101000020E6100000FCFFFFFFD55203400731D851ED6C4840
92018	8330	\N	\N	\N	\N	58.00000	0101000020E6100000F8FFFFFF3250034003D595815A6D4840
92019	8330	\N	\N	\N	\N	64.00000	0101000020E6100000F5FFFFFF9664034085D22A528E6D4840
92021	8333	\N	\N	\N	\N	37.00000	0101000020E61000000800000094FF0140455CD3459A714840
92025	8333	\N	\N	\N	\N	37.00000	0101000020E61000000A000000823E0240E9E15B4167704840
92028	8333	\N	\N	\N	\N	50.00000	0101000020E61000000B00000090120240D84204B9786C4840
92031	8333	\N	\N	\N	\N	31.00000	0101000020E6100000F6FFFFFFBD2F02403BE31D01506C4840
92034	8333	\N	\N	\N	\N	36.00000	0101000020E6100000FFFFFFFF315202405D3E66C1296E4840
92037	8333	\N	\N	\N	\N	39.00000	0101000020E6100000F9FFFFFF39590240010713F2F56D4840
92040	8333	\N	\N	\N	\N	44.00000	0101000020E610000003000000BC4F0240DBBE11355E6D4840
92043	8333	\N	\N	\N	\N	39.00000	0101000020E610000006000000785702406BA7F710E46C4840
92046	8333	\N	\N	\N	\N	44.00000	0101000020E6100000FCFFFFFF157D024012A9EF63326C4840
92048	8333	\N	\N	\N	\N	73.00000	0101000020E61000000A000000428D024056A2876F206B4840
92051	8333	\N	\N	\N	\N	70.00000	0101000020E6100000F8FFFFFF0B9602409F1EC53E2F6B4840
92054	8333	\N	\N	\N	\N	62.00000	0101000020E6100000F6FFFFFF3DCD0240A43015C32F6A4840
92057	8333	\N	\N	\N	\N	44.00000	0101000020E6100000FDFFFFFFC30A0340A9BABC65846B4840
91968	8331	\N	\N	\N	\N	37.00000	0101000020E61000000800000094FF0140455CD3459A714840
91970	8331	\N	\N	\N	\N	37.00000	0101000020E61000000A000000823E0240E9E15B4167704840
91974	8331	\N	\N	\N	\N	50.00000	0101000020E61000000B00000090120240D84204B9786C4840
91977	8331	\N	\N	\N	\N	31.00000	0101000020E6100000F6FFFFFFBD2F02403BE31D01506C4840
91980	8331	\N	\N	\N	\N	36.00000	0101000020E6100000FFFFFFFF315202405D3E66C1296E4840
91983	8331	\N	\N	\N	\N	39.00000	0101000020E6100000F9FFFFFF39590240010713F2F56D4840
91986	8331	\N	\N	\N	\N	44.00000	0101000020E610000003000000BC4F0240DBBE11355E6D4840
91989	8331	\N	\N	\N	\N	39.00000	0101000020E610000006000000785702406BA7F710E46C4840
91992	8331	\N	\N	\N	\N	44.00000	0101000020E6100000FCFFFFFF157D024012A9EF63326C4840
91995	8331	\N	\N	\N	\N	73.00000	0101000020E61000000A000000428D024056A2876F206B4840
91998	8331	\N	\N	\N	\N	70.00000	0101000020E6100000F8FFFFFF0B9602409F1EC53E2F6B4840
92001	8331	\N	\N	\N	\N	62.00000	0101000020E6100000F6FFFFFF3DCD0240A43015C32F6A4840
92003	8331	\N	\N	\N	\N	44.00000	0101000020E6100000FDFFFFFFC30A0340A9BABC65846B4840
92023	8334	\N	\N	\N	\N	121.00000	0101000020E610000006000000F813024023310B9E04674840
92026	8334	\N	\N	\N	\N	90.00000	0101000020E6100000F9FFFFFF19100240BE678CB755684840
92029	8334	\N	\N	\N	\N	83.00000	0101000020E610000002000000951C024031FC4134D9684840
92032	8334	\N	\N	\N	\N	66.00000	0101000020E6100000FFFFFFFF71300240857D755016694840
92035	8334	\N	\N	\N	\N	39.00000	0101000020E61000000B000000B02E02405288D5287C694840
92038	8334	\N	\N	\N	\N	43.00000	0101000020E610000001000000274E02402910E24A996A4840
92041	8334	\N	\N	\N	\N	44.00000	0101000020E610000008000000345F02409F1EC53E2F6B4840
92044	8334	\N	\N	\N	\N	52.00000	0101000020E610000002000000556B0240A9BABC65846B4840
92047	8334	\N	\N	\N	\N	48.00000	0101000020E6100000F8FFFFFF326F0240AE557EE8966B4840
92050	8334	\N	\N	\N	\N	46.00000	0101000020E610000003000000DC6B02407ADD2119DF6B4840
92053	8334	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFF926902400467A8AD856C4840
92056	8334	\N	\N	\N	\N	39.00000	0101000020E6100000040000006A5602405E6FBEEAE56C4840
92058	8334	\N	\N	\N	\N	44.00000	0101000020E61000000A000000624F02409E1C8DE8616D4840
92060	8334	\N	\N	\N	\N	31.00000	0101000020E6100000FFFFFFFFB8520240B1AEC2E1B86D4840
92062	8334	\N	\N	\N	\N	39.00000	0101000020E6100000FFFFFFFF58580240798FC5CBF76D4840
92064	8334	\N	\N	\N	\N	35.00000	0101000020E6100000FDFFFFBF665D02408320235E286E4840
92066	8334	\N	\N	\N	\N	41.00000	0101000020E6100000FCFFFFFFD5710240AC1B6831586D4840
92067	8334	\N	\N	\N	\N	37.00000	0101000020E6100000020000C0BE7D024075E7303D4B6D4840
92068	8334	\N	\N	\N	\N	41.00000	0101000020E6100000090000808E84024096B58239456D4840
92069	8334	\N	\N	\N	\N	44.00000	0101000020E6100000030000C0E583024042C6A1D7E66C4840
92070	8334	\N	\N	\N	\N	43.00000	0101000020E6100000020000C07788024041A82D87686C4840
92071	8334	\N	\N	\N	\N	45.00000	0101000020E610000005000080849D02407DDD93A9FB6C4840
92072	8334	\N	\N	\N	\N	45.00000	0101000020E6100000FAFFFFFF27C502402E486514096D4840
92073	8334	\N	\N	\N	\N	32.00000	0101000020E610000008000000F4DA02406AA961CCB56C4840
92074	8334	\N	\N	\N	\N	43.00000	0101000020E610000004000000EAF30240C2D2A2E53C6D4840
92075	8334	\N	\N	\N	\N	44.00000	0101000020E6100000F8FFFFFFD2FB02408801B1A10E6D4840
92076	8334	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340F6D645A2926C4840
92077	8334	\N	\N	\N	\N	50.00000	0101000020E6100000010000006E5103403919D7F55C6C4840
92078	8334	\N	\N	\N	\N	52.00000	0101000020E6100000FCFFFFFFD55203400731D851ED6C4840
92079	8334	\N	\N	\N	\N	58.00000	0101000020E6100000F8FFFFFF3250034003D595815A6D4840
92080	8334	\N	\N	\N	\N	64.00000	0101000020E6100000F5FFFFFF9664034085D22A528E6D4840
92081	8335	\N	\N	\N	\N	57.00000	0101000020E610000004000000835B02401B096EA3D46D4840
92083	8335	\N	\N	\N	\N	31.00000	0101000020E610000007000000E6520240926D080E266E4840
92082	8336	\N	\N	\N	\N	37.00000	0101000020E61000000800000094FF0140455CD3459A714840
92084	8337	\N	\N	\N	\N	121.00000	0101000020E610000006000000F813024023310B9E04674840
92085	8335	\N	\N	\N	\N	50.00000	0101000020E61000000B0000001056024081F69977776E4840
92086	8336	\N	\N	\N	\N	37.00000	0101000020E61000000A000000823E0240E9E15B4167704840
92087	8337	\N	\N	\N	\N	90.00000	0101000020E6100000F9FFFFFF19100240BE678CB755684840
92088	8335	\N	\N	\N	\N	57.00000	0101000020E610000001000000EE5902404E40AAECBB6E4840
92089	8337	\N	\N	\N	\N	83.00000	0101000020E610000002000000951C024031FC4134D9684840
92090	8336	\N	\N	\N	\N	50.00000	0101000020E61000000B00000090120240D84204B9786C4840
92091	8335	\N	\N	\N	\N	69.00000	0101000020E6100000060000009F5D0240F0633F211C6F4840
92092	8337	\N	\N	\N	\N	66.00000	0101000020E6100000FFFFFFFF71300240857D755016694840
92093	8336	\N	\N	\N	\N	31.00000	0101000020E6100000F6FFFFFFBD2F02403BE31D01506C4840
92094	8335	\N	\N	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C0240DAE83039E06F4840
92095	8337	\N	\N	\N	\N	39.00000	0101000020E61000000B000000B02E02405288D5287C694840
92096	8336	\N	\N	\N	\N	36.00000	0101000020E6100000FFFFFFFF315202405D3E66C1296E4840
92097	8335	\N	\N	\N	\N	50.00000	0101000020E6100000010000000E7602402EFFFB7A556F4840
92098	8337	\N	\N	\N	\N	43.00000	0101000020E610000001000000274E02402910E24A996A4840
92099	8335	\N	\N	\N	\N	34.00000	0101000020E61000000B000000508E024067DC7960DB6E4840
92100	8336	\N	\N	\N	\N	39.00000	0101000020E6100000F9FFFFFF39590240010713F2F56D4840
92101	8337	\N	\N	\N	\N	44.00000	0101000020E610000008000000345F02409F1EC53E2F6B4840
92102	8336	\N	\N	\N	\N	44.00000	0101000020E610000003000000BC4F0240DBBE11355E6D4840
92103	8335	\N	\N	\N	\N	30.00000	0101000020E6100000FEFFFFFF8A8F024069BF0C9F9A6E4840
92104	8337	\N	\N	\N	\N	52.00000	0101000020E610000002000000556B0240A9BABC65846B4840
92105	8336	\N	\N	\N	\N	39.00000	0101000020E610000006000000785702406BA7F710E46C4840
92106	8335	\N	\N	\N	\N	37.00000	0101000020E6100000FCFFFFFFBCC6024038A43095BC6D4840
92107	8337	\N	\N	\N	\N	48.00000	0101000020E6100000F8FFFFFF326F0240AE557EE8966B4840
92108	8336	\N	\N	\N	\N	44.00000	0101000020E6100000FCFFFFFF157D024012A9EF63326C4840
92109	8335	\N	\N	\N	\N	49.00000	0101000020E6100000FCFFFFFFFCD10240216E1B3ADD6E4840
92110	8337	\N	\N	\N	\N	46.00000	0101000020E610000003000000DC6B02407ADD2119DF6B4840
92111	8336	\N	\N	\N	\N	73.00000	0101000020E61000000A000000428D024056A2876F206B4840
92112	8335	\N	\N	\N	\N	44.00000	0101000020E610000001000000EEE00240E5C63B6CA96E4840
92113	8337	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFF926902400467A8AD856C4840
92114	8336	\N	\N	\N	\N	70.00000	0101000020E6100000F8FFFFFF0B9602409F1EC53E2F6B4840
92115	8335	\N	\N	\N	\N	41.00000	0101000020E61000000B00000050E80240F4C83C14046F4840
92116	8337	\N	\N	\N	\N	39.00000	0101000020E6100000040000006A5602405E6FBEEAE56C4840
92117	8336	\N	\N	\N	\N	62.00000	0101000020E6100000F6FFFFFF3DCD0240A43015C32F6A4840
92118	8337	\N	\N	\N	\N	44.00000	0101000020E61000000A000000624F02409E1C8DE8616D4840
92119	8335	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFFF2EA0240D695822DEA6E4840
92120	8336	\N	\N	\N	\N	44.00000	0101000020E6100000FDFFFFFFC30A0340A9BABC65846B4840
92121	8337	\N	\N	\N	\N	31.00000	0101000020E6100000FFFFFFFFB8520240B1AEC2E1B86D4840
92122	8335	\N	\N	\N	\N	64.00000	0101000020E6100000000000002018034090A347C4736E4840
92123	8337	\N	\N	\N	\N	39.00000	0101000020E6100000FFFFFFFF58580240798FC5CBF76D4840
92124	8335	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340AE92DC969F6C4840
92125	8337	\N	\N	\N	\N	35.00000	0101000020E6100000FDFFFFBF665D02408320235E286E4840
92126	8335	\N	\N	\N	\N	47.00000	0101000020E6100000F8FFFFFF325003405AA8B910686C4840
92127	8337	\N	\N	\N	\N	41.00000	0101000020E6100000FCFFFFFFD5710240AC1B6831586D4840
92128	8337	\N	\N	\N	\N	37.00000	0101000020E6100000020000C0BE7D024075E7303D4B6D4840
92129	8337	\N	\N	\N	\N	41.00000	0101000020E6100000090000808E84024096B58239456D4840
92130	8337	\N	\N	\N	\N	44.00000	0101000020E6100000030000C0E583024042C6A1D7E66C4840
92131	8337	\N	\N	\N	\N	43.00000	0101000020E6100000020000C07788024041A82D87686C4840
92132	8337	\N	\N	\N	\N	45.00000	0101000020E610000005000080849D02407DDD93A9FB6C4840
92133	8337	\N	\N	\N	\N	45.00000	0101000020E6100000FAFFFFFF27C502402E486514096D4840
92134	8337	\N	\N	\N	\N	32.00000	0101000020E610000008000000F4DA02406AA961CCB56C4840
92135	8337	\N	\N	\N	\N	43.00000	0101000020E610000004000000EAF30240C2D2A2E53C6D4840
92136	8337	\N	\N	\N	\N	44.00000	0101000020E6100000F8FFFFFFD2FB02408801B1A10E6D4840
92137	8337	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340F6D645A2926C4840
92138	8337	\N	\N	\N	\N	50.00000	0101000020E6100000010000006E5103403919D7F55C6C4840
92139	8337	\N	\N	\N	\N	52.00000	0101000020E6100000FCFFFFFFD55203400731D851ED6C4840
92140	8337	\N	\N	\N	\N	58.00000	0101000020E6100000F8FFFFFF3250034003D595815A6D4840
92141	8337	\N	\N	\N	\N	64.00000	0101000020E6100000F5FFFFFF9664034085D22A528E6D4840
92142	8338	\N	\N	\N	\N	57.00000	0101000020E610000004000000835B02401B096EA3D46D4840
92143	8339	\N	\N	\N	\N	121.00000	0101000020E610000006000000F813024023310B9E04674840
92144	8339	\N	\N	\N	\N	90.00000	0101000020E6100000F9FFFFFF19100240BE678CB755684840
92147	8339	\N	\N	\N	\N	83.00000	0101000020E610000002000000951C024031FC4134D9684840
92150	8339	\N	\N	\N	\N	66.00000	0101000020E6100000FFFFFFFF71300240857D755016694840
92153	8339	\N	\N	\N	\N	39.00000	0101000020E61000000B000000B02E02405288D5287C694840
92156	8339	\N	\N	\N	\N	43.00000	0101000020E610000001000000274E02402910E24A996A4840
92159	8339	\N	\N	\N	\N	44.00000	0101000020E610000008000000345F02409F1EC53E2F6B4840
92162	8339	\N	\N	\N	\N	52.00000	0101000020E610000002000000556B0240A9BABC65846B4840
92165	8339	\N	\N	\N	\N	48.00000	0101000020E6100000F8FFFFFF326F0240AE557EE8966B4840
92168	8339	\N	\N	\N	\N	46.00000	0101000020E610000003000000DC6B02407ADD2119DF6B4840
92171	8339	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFF926902400467A8AD856C4840
92174	8339	\N	\N	\N	\N	39.00000	0101000020E6100000040000006A5602405E6FBEEAE56C4840
92177	8339	\N	\N	\N	\N	44.00000	0101000020E61000000A000000624F02409E1C8DE8616D4840
92179	8339	\N	\N	\N	\N	31.00000	0101000020E6100000FFFFFFFFB8520240B1AEC2E1B86D4840
92182	8339	\N	\N	\N	\N	39.00000	0101000020E6100000FFFFFFFF58580240798FC5CBF76D4840
92185	8339	\N	\N	\N	\N	35.00000	0101000020E6100000FDFFFFBF665D02408320235E286E4840
92187	8339	\N	\N	\N	\N	41.00000	0101000020E6100000FCFFFFFFD5710240AC1B6831586D4840
92189	8339	\N	\N	\N	\N	37.00000	0101000020E6100000020000C0BE7D024075E7303D4B6D4840
92190	8339	\N	\N	\N	\N	41.00000	0101000020E6100000090000808E84024096B58239456D4840
92191	8339	\N	\N	\N	\N	44.00000	0101000020E6100000030000C0E583024042C6A1D7E66C4840
92192	8339	\N	\N	\N	\N	43.00000	0101000020E6100000020000C07788024041A82D87686C4840
92193	8339	\N	\N	\N	\N	45.00000	0101000020E610000005000080849D02407DDD93A9FB6C4840
92194	8339	\N	\N	\N	\N	45.00000	0101000020E6100000FAFFFFFF27C502402E486514096D4840
92195	8339	\N	\N	\N	\N	32.00000	0101000020E610000008000000F4DA02406AA961CCB56C4840
92196	8339	\N	\N	\N	\N	43.00000	0101000020E610000004000000EAF30240C2D2A2E53C6D4840
92197	8339	\N	\N	\N	\N	44.00000	0101000020E6100000F8FFFFFFD2FB02408801B1A10E6D4840
92198	8339	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340F6D645A2926C4840
92199	8339	\N	\N	\N	\N	50.00000	0101000020E6100000010000006E5103403919D7F55C6C4840
92200	8339	\N	\N	\N	\N	52.00000	0101000020E6100000FCFFFFFFD55203400731D851ED6C4840
92201	8339	\N	\N	\N	\N	58.00000	0101000020E6100000F8FFFFFF3250034003D595815A6D4840
92202	8339	\N	\N	\N	\N	64.00000	0101000020E6100000F5FFFFFF9664034085D22A528E6D4840
92203	8341	\N	\N	\N	\N	57.00000	0101000020E610000004000000835B02401B096EA3D46D4840
92204	8341	\N	\N	\N	\N	31.00000	0101000020E610000007000000E6520240926D080E266E4840
92205	8341	\N	\N	\N	\N	50.00000	0101000020E61000000B0000001056024081F69977776E4840
92206	8341	\N	\N	\N	\N	57.00000	0101000020E610000001000000EE5902404E40AAECBB6E4840
92208	8341	\N	\N	\N	\N	69.00000	0101000020E6100000060000009F5D0240F0633F211C6F4840
92210	8341	\N	\N	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C0240DAE83039E06F4840
92212	8341	\N	\N	\N	\N	50.00000	0101000020E6100000010000000E7602402EFFFB7A556F4840
92214	8341	\N	\N	\N	\N	34.00000	0101000020E61000000B000000508E024067DC7960DB6E4840
92216	8341	\N	\N	\N	\N	30.00000	0101000020E6100000FEFFFFFF8A8F024069BF0C9F9A6E4840
92218	8341	\N	\N	\N	\N	37.00000	0101000020E6100000FCFFFFFFBCC6024038A43095BC6D4840
92220	8341	\N	\N	\N	\N	49.00000	0101000020E6100000FCFFFFFFFCD10240216E1B3ADD6E4840
92222	8341	\N	\N	\N	\N	44.00000	0101000020E610000001000000EEE00240E5C63B6CA96E4840
92224	8341	\N	\N	\N	\N	41.00000	0101000020E61000000B00000050E80240F4C83C14046F4840
92227	8341	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFFF2EA0240D695822DEA6E4840
92229	8341	\N	\N	\N	\N	64.00000	0101000020E6100000000000002018034090A347C4736E4840
92230	8341	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340AE92DC969F6C4840
92232	8341	\N	\N	\N	\N	47.00000	0101000020E6100000F8FFFFFF325003405AA8B910686C4840
92264	8344	\N	\N	\N	\N	57.00000	0101000020E610000004000000835B02401B096EA3D46D4840
92265	8344	\N	\N	\N	\N	31.00000	0101000020E610000007000000E6520240926D080E266E4840
92267	8344	\N	\N	\N	\N	50.00000	0101000020E61000000B0000001056024081F69977776E4840
92269	8344	\N	\N	\N	\N	57.00000	0101000020E610000001000000EE5902404E40AAECBB6E4840
92271	8344	\N	\N	\N	\N	69.00000	0101000020E6100000060000009F5D0240F0633F211C6F4840
92273	8344	\N	\N	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C0240DAE83039E06F4840
92275	8344	\N	\N	\N	\N	50.00000	0101000020E6100000010000000E7602402EFFFB7A556F4840
92277	8344	\N	\N	\N	\N	34.00000	0101000020E61000000B000000508E024067DC7960DB6E4840
92279	8344	\N	\N	\N	\N	30.00000	0101000020E6100000FEFFFFFF8A8F024069BF0C9F9A6E4840
92281	8344	\N	\N	\N	\N	37.00000	0101000020E6100000FCFFFFFFBCC6024038A43095BC6D4840
92283	8344	\N	\N	\N	\N	49.00000	0101000020E6100000FCFFFFFFFCD10240216E1B3ADD6E4840
92285	8344	\N	\N	\N	\N	44.00000	0101000020E610000001000000EEE00240E5C63B6CA96E4840
92287	8344	\N	\N	\N	\N	41.00000	0101000020E61000000B00000050E80240F4C83C14046F4840
92290	8344	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFFF2EA0240D695822DEA6E4840
92293	8344	\N	\N	\N	\N	64.00000	0101000020E6100000000000002018034090A347C4736E4840
92294	8344	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340AE92DC969F6C4840
92297	8344	\N	\N	\N	\N	47.00000	0101000020E6100000F8FFFFFF325003405AA8B910686C4840
92325	8347	\N	\N	\N	\N	121.00000	0101000020E610000006000000F813024023310B9E04674840
92328	8347	\N	\N	\N	\N	90.00000	0101000020E6100000F9FFFFFF19100240BE678CB755684840
92331	8347	\N	\N	\N	\N	83.00000	0101000020E610000002000000951C024031FC4134D9684840
92334	8347	\N	\N	\N	\N	66.00000	0101000020E6100000FFFFFFFF71300240857D755016694840
92337	8347	\N	\N	\N	\N	39.00000	0101000020E61000000B000000B02E02405288D5287C694840
92340	8347	\N	\N	\N	\N	43.00000	0101000020E610000001000000274E02402910E24A996A4840
92343	8347	\N	\N	\N	\N	44.00000	0101000020E610000008000000345F02409F1EC53E2F6B4840
92346	8347	\N	\N	\N	\N	52.00000	0101000020E610000002000000556B0240A9BABC65846B4840
92349	8347	\N	\N	\N	\N	48.00000	0101000020E6100000F8FFFFFF326F0240AE557EE8966B4840
92352	8347	\N	\N	\N	\N	46.00000	0101000020E610000003000000DC6B02407ADD2119DF6B4840
92355	8347	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFF926902400467A8AD856C4840
92358	8347	\N	\N	\N	\N	39.00000	0101000020E6100000040000006A5602405E6FBEEAE56C4840
92361	8347	\N	\N	\N	\N	44.00000	0101000020E61000000A000000624F02409E1C8DE8616D4840
92364	8347	\N	\N	\N	\N	31.00000	0101000020E6100000FFFFFFFFB8520240B1AEC2E1B86D4840
92366	8347	\N	\N	\N	\N	39.00000	0101000020E6100000FFFFFFFF58580240798FC5CBF76D4840
92368	8347	\N	\N	\N	\N	35.00000	0101000020E6100000FDFFFFBF665D02408320235E286E4840
92369	8347	\N	\N	\N	\N	41.00000	0101000020E6100000FCFFFFFFD5710240AC1B6831586D4840
92371	8347	\N	\N	\N	\N	37.00000	0101000020E6100000020000C0BE7D024075E7303D4B6D4840
92373	8347	\N	\N	\N	\N	41.00000	0101000020E6100000090000808E84024096B58239456D4840
92374	8347	\N	\N	\N	\N	44.00000	0101000020E6100000030000C0E583024042C6A1D7E66C4840
92375	8347	\N	\N	\N	\N	43.00000	0101000020E6100000020000C07788024041A82D87686C4840
92376	8347	\N	\N	\N	\N	45.00000	0101000020E610000005000080849D02407DDD93A9FB6C4840
92377	8347	\N	\N	\N	\N	45.00000	0101000020E6100000FAFFFFFF27C502402E486514096D4840
92378	8347	\N	\N	\N	\N	32.00000	0101000020E610000008000000F4DA02406AA961CCB56C4840
92379	8347	\N	\N	\N	\N	43.00000	0101000020E610000004000000EAF30240C2D2A2E53C6D4840
92380	8347	\N	\N	\N	\N	44.00000	0101000020E6100000F8FFFFFFD2FB02408801B1A10E6D4840
92381	8347	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340F6D645A2926C4840
92382	8347	\N	\N	\N	\N	50.00000	0101000020E6100000010000006E5103403919D7F55C6C4840
92383	8347	\N	\N	\N	\N	52.00000	0101000020E6100000FCFFFFFFD55203400731D851ED6C4840
92384	8347	\N	\N	\N	\N	58.00000	0101000020E6100000F8FFFFFF3250034003D595815A6D4840
92385	8347	\N	\N	\N	\N	64.00000	0101000020E6100000F5FFFFFF9664034085D22A528E6D4840
92386	8350	\N	\N	\N	\N	57.00000	0101000020E610000004000000835B02401B096EA3D46D4840
92387	8350	\N	\N	\N	\N	31.00000	0101000020E610000007000000E6520240926D080E266E4840
92388	8350	\N	\N	\N	\N	50.00000	0101000020E61000000B0000001056024081F69977776E4840
92390	8350	\N	\N	\N	\N	57.00000	0101000020E610000001000000EE5902404E40AAECBB6E4840
92392	8350	\N	\N	\N	\N	69.00000	0101000020E6100000060000009F5D0240F0633F211C6F4840
92394	8350	\N	\N	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C0240DAE83039E06F4840
92396	8350	\N	\N	\N	\N	50.00000	0101000020E6100000010000000E7602402EFFFB7A556F4840
92398	8350	\N	\N	\N	\N	34.00000	0101000020E61000000B000000508E024067DC7960DB6E4840
92400	8350	\N	\N	\N	\N	30.00000	0101000020E6100000FEFFFFFF8A8F024069BF0C9F9A6E4840
92402	8350	\N	\N	\N	\N	37.00000	0101000020E6100000FCFFFFFFBCC6024038A43095BC6D4840
92405	8350	\N	\N	\N	\N	49.00000	0101000020E6100000FCFFFFFFFCD10240216E1B3ADD6E4840
92407	8350	\N	\N	\N	\N	44.00000	0101000020E610000001000000EEE00240E5C63B6CA96E4840
92146	8340	\N	\N	\N	\N	37.00000	0101000020E61000000800000094FF0140455CD3459A714840
92148	8340	\N	\N	\N	\N	37.00000	0101000020E61000000A000000823E0240E9E15B4167704840
92151	8340	\N	\N	\N	\N	50.00000	0101000020E61000000B00000090120240D84204B9786C4840
92154	8340	\N	\N	\N	\N	31.00000	0101000020E6100000F6FFFFFFBD2F02403BE31D01506C4840
92157	8340	\N	\N	\N	\N	36.00000	0101000020E6100000FFFFFFFF315202405D3E66C1296E4840
92160	8340	\N	\N	\N	\N	39.00000	0101000020E6100000F9FFFFFF39590240010713F2F56D4840
92163	8340	\N	\N	\N	\N	44.00000	0101000020E610000003000000BC4F0240DBBE11355E6D4840
92166	8340	\N	\N	\N	\N	39.00000	0101000020E610000006000000785702406BA7F710E46C4840
92169	8340	\N	\N	\N	\N	44.00000	0101000020E6100000FCFFFFFF157D024012A9EF63326C4840
92172	8340	\N	\N	\N	\N	73.00000	0101000020E61000000A000000428D024056A2876F206B4840
92175	8340	\N	\N	\N	\N	70.00000	0101000020E6100000F8FFFFFF0B9602409F1EC53E2F6B4840
92178	8340	\N	\N	\N	\N	62.00000	0101000020E6100000F6FFFFFF3DCD0240A43015C32F6A4840
92181	8340	\N	\N	\N	\N	44.00000	0101000020E6100000FDFFFFFFC30A0340A9BABC65846B4840
92233	8343	\N	\N	\N	\N	121.00000	0101000020E610000006000000F813024023310B9E04674840
92234	8343	\N	\N	\N	\N	90.00000	0101000020E6100000F9FFFFFF19100240BE678CB755684840
92235	8343	\N	\N	\N	\N	83.00000	0101000020E610000002000000951C024031FC4134D9684840
92236	8343	\N	\N	\N	\N	66.00000	0101000020E6100000FFFFFFFF71300240857D755016694840
92237	8343	\N	\N	\N	\N	39.00000	0101000020E61000000B000000B02E02405288D5287C694840
92238	8343	\N	\N	\N	\N	43.00000	0101000020E610000001000000274E02402910E24A996A4840
92239	8343	\N	\N	\N	\N	44.00000	0101000020E610000008000000345F02409F1EC53E2F6B4840
92240	8343	\N	\N	\N	\N	52.00000	0101000020E610000002000000556B0240A9BABC65846B4840
92241	8343	\N	\N	\N	\N	48.00000	0101000020E6100000F8FFFFFF326F0240AE557EE8966B4840
92242	8343	\N	\N	\N	\N	46.00000	0101000020E610000003000000DC6B02407ADD2119DF6B4840
92243	8343	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFF926902400467A8AD856C4840
92244	8343	\N	\N	\N	\N	39.00000	0101000020E6100000040000006A5602405E6FBEEAE56C4840
92245	8343	\N	\N	\N	\N	44.00000	0101000020E61000000A000000624F02409E1C8DE8616D4840
92246	8343	\N	\N	\N	\N	31.00000	0101000020E6100000FFFFFFFFB8520240B1AEC2E1B86D4840
92247	8343	\N	\N	\N	\N	39.00000	0101000020E6100000FFFFFFFF58580240798FC5CBF76D4840
92248	8343	\N	\N	\N	\N	35.00000	0101000020E6100000FDFFFFBF665D02408320235E286E4840
92249	8343	\N	\N	\N	\N	41.00000	0101000020E6100000FCFFFFFFD5710240AC1B6831586D4840
92250	8343	\N	\N	\N	\N	37.00000	0101000020E6100000020000C0BE7D024075E7303D4B6D4840
92251	8343	\N	\N	\N	\N	41.00000	0101000020E6100000090000808E84024096B58239456D4840
92252	8343	\N	\N	\N	\N	44.00000	0101000020E6100000030000C0E583024042C6A1D7E66C4840
92253	8343	\N	\N	\N	\N	43.00000	0101000020E6100000020000C07788024041A82D87686C4840
92254	8343	\N	\N	\N	\N	45.00000	0101000020E610000005000080849D02407DDD93A9FB6C4840
92255	8343	\N	\N	\N	\N	45.00000	0101000020E6100000FAFFFFFF27C502402E486514096D4840
92256	8343	\N	\N	\N	\N	32.00000	0101000020E610000008000000F4DA02406AA961CCB56C4840
92257	8343	\N	\N	\N	\N	43.00000	0101000020E610000004000000EAF30240C2D2A2E53C6D4840
92258	8343	\N	\N	\N	\N	44.00000	0101000020E6100000F8FFFFFFD2FB02408801B1A10E6D4840
92259	8343	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340F6D645A2926C4840
92260	8343	\N	\N	\N	\N	50.00000	0101000020E6100000010000006E5103403919D7F55C6C4840
92261	8343	\N	\N	\N	\N	52.00000	0101000020E6100000FCFFFFFFD55203400731D851ED6C4840
92262	8343	\N	\N	\N	\N	58.00000	0101000020E6100000F8FFFFFF3250034003D595815A6D4840
92263	8343	\N	\N	\N	\N	64.00000	0101000020E6100000F5FFFFFF9664034085D22A528E6D4840
92266	8345	\N	\N	\N	\N	37.00000	0101000020E61000000800000094FF0140455CD3459A714840
92268	8345	\N	\N	\N	\N	37.00000	0101000020E61000000A000000823E0240E9E15B4167704840
92270	8345	\N	\N	\N	\N	50.00000	0101000020E61000000B00000090120240D84204B9786C4840
92272	8345	\N	\N	\N	\N	31.00000	0101000020E6100000F6FFFFFFBD2F02403BE31D01506C4840
92274	8345	\N	\N	\N	\N	36.00000	0101000020E6100000FFFFFFFF315202405D3E66C1296E4840
92276	8345	\N	\N	\N	\N	39.00000	0101000020E6100000F9FFFFFF39590240010713F2F56D4840
92278	8345	\N	\N	\N	\N	44.00000	0101000020E610000003000000BC4F0240DBBE11355E6D4840
92280	8345	\N	\N	\N	\N	39.00000	0101000020E610000006000000785702406BA7F710E46C4840
92282	8345	\N	\N	\N	\N	44.00000	0101000020E6100000FCFFFFFF157D024012A9EF63326C4840
92284	8345	\N	\N	\N	\N	73.00000	0101000020E61000000A000000428D024056A2876F206B4840
92286	8345	\N	\N	\N	\N	70.00000	0101000020E6100000F8FFFFFF0B9602409F1EC53E2F6B4840
92288	8345	\N	\N	\N	\N	62.00000	0101000020E6100000F6FFFFFF3DCD0240A43015C32F6A4840
92291	8345	\N	\N	\N	\N	44.00000	0101000020E6100000FDFFFFFFC30A0340A9BABC65846B4840
92327	8349	\N	\N	\N	\N	57.00000	0101000020E610000004000000835B02401B096EA3D46D4840
92330	8349	\N	\N	\N	\N	31.00000	0101000020E610000007000000E6520240926D080E266E4840
92333	8349	\N	\N	\N	\N	50.00000	0101000020E61000000B0000001056024081F69977776E4840
92336	8349	\N	\N	\N	\N	57.00000	0101000020E610000001000000EE5902404E40AAECBB6E4840
92338	8349	\N	\N	\N	\N	69.00000	0101000020E6100000060000009F5D0240F0633F211C6F4840
92341	8349	\N	\N	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C0240DAE83039E06F4840
92344	8349	\N	\N	\N	\N	50.00000	0101000020E6100000010000000E7602402EFFFB7A556F4840
92347	8349	\N	\N	\N	\N	34.00000	0101000020E61000000B000000508E024067DC7960DB6E4840
92350	8349	\N	\N	\N	\N	30.00000	0101000020E6100000FEFFFFFF8A8F024069BF0C9F9A6E4840
92353	8349	\N	\N	\N	\N	37.00000	0101000020E6100000FCFFFFFFBCC6024038A43095BC6D4840
92356	8349	\N	\N	\N	\N	49.00000	0101000020E6100000FCFFFFFFFCD10240216E1B3ADD6E4840
92359	8349	\N	\N	\N	\N	44.00000	0101000020E610000001000000EEE00240E5C63B6CA96E4840
92362	8349	\N	\N	\N	\N	41.00000	0101000020E61000000B00000050E80240F4C83C14046F4840
92365	8349	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFFF2EA0240D695822DEA6E4840
92367	8349	\N	\N	\N	\N	64.00000	0101000020E6100000000000002018034090A347C4736E4840
92370	8349	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340AE92DC969F6C4840
92372	8349	\N	\N	\N	\N	47.00000	0101000020E6100000F8FFFFFF325003405AA8B910686C4840
92409	8350	\N	\N	\N	\N	41.00000	0101000020E61000000B00000050E80240F4C83C14046F4840
92411	8350	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFFF2EA0240D695822DEA6E4840
92413	8350	\N	\N	\N	\N	64.00000	0101000020E6100000000000002018034090A347C4736E4840
92414	8350	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340AE92DC969F6C4840
92415	8350	\N	\N	\N	\N	47.00000	0101000020E6100000F8FFFFFF325003405AA8B910686C4840
92437	8352	\N	\N	\N	\N	45.00000	0101000020E610000005000080849D02407DDD93A9FB6C4840
92438	8352	\N	\N	\N	\N	45.00000	0101000020E6100000FAFFFFFF27C502402E486514096D4840
92439	8352	\N	\N	\N	\N	32.00000	0101000020E610000008000000F4DA02406AA961CCB56C4840
92440	8352	\N	\N	\N	\N	43.00000	0101000020E610000004000000EAF30240C2D2A2E53C6D4840
92441	8352	\N	\N	\N	\N	44.00000	0101000020E6100000F8FFFFFFD2FB02408801B1A10E6D4840
92442	8352	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340F6D645A2926C4840
92443	8352	\N	\N	\N	\N	50.00000	0101000020E6100000010000006E5103403919D7F55C6C4840
92444	8352	\N	\N	\N	\N	52.00000	0101000020E6100000FCFFFFFFD55203400731D851ED6C4840
92445	8352	\N	\N	\N	\N	58.00000	0101000020E6100000F8FFFFFF3250034003D595815A6D4840
92446	8352	\N	\N	\N	\N	64.00000	0101000020E6100000F5FFFFFF9664034085D22A528E6D4840
92447	8353	\N	\N	\N	\N	57.00000	0101000020E610000004000000835B02401B096EA3D46D4840
92449	8353	\N	\N	\N	\N	31.00000	0101000020E610000007000000E6520240926D080E266E4840
92452	8353	\N	\N	\N	\N	50.00000	0101000020E61000000B0000001056024081F69977776E4840
92454	8353	\N	\N	\N	\N	57.00000	0101000020E610000001000000EE5902404E40AAECBB6E4840
92458	8353	\N	\N	\N	\N	69.00000	0101000020E6100000060000009F5D0240F0633F211C6F4840
92460	8353	\N	\N	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C0240DAE83039E06F4840
92463	8353	\N	\N	\N	\N	50.00000	0101000020E6100000010000000E7602402EFFFB7A556F4840
92466	8353	\N	\N	\N	\N	34.00000	0101000020E61000000B000000508E024067DC7960DB6E4840
92469	8353	\N	\N	\N	\N	30.00000	0101000020E6100000FEFFFFFF8A8F024069BF0C9F9A6E4840
92472	8353	\N	\N	\N	\N	37.00000	0101000020E6100000FCFFFFFFBCC6024038A43095BC6D4840
92475	8353	\N	\N	\N	\N	49.00000	0101000020E6100000FCFFFFFFFCD10240216E1B3ADD6E4840
92478	8353	\N	\N	\N	\N	44.00000	0101000020E610000001000000EEE00240E5C63B6CA96E4840
92481	8353	\N	\N	\N	\N	41.00000	0101000020E61000000B00000050E80240F4C83C14046F4840
92484	8353	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFFF2EA0240D695822DEA6E4840
92486	8353	\N	\N	\N	\N	64.00000	0101000020E6100000000000002018034090A347C4736E4840
92488	8353	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340AE92DC969F6C4840
92490	8353	\N	\N	\N	\N	47.00000	0101000020E6100000F8FFFFFF325003405AA8B910686C4840
92508	8356	\N	\N	\N	\N	57.00000	0101000020E610000004000000835B02401B096EA3D46D4840
92511	8356	\N	\N	\N	\N	31.00000	0101000020E610000007000000E6520240926D080E266E4840
92514	8356	\N	\N	\N	\N	50.00000	0101000020E61000000B0000001056024081F69977776E4840
92517	8356	\N	\N	\N	\N	57.00000	0101000020E610000001000000EE5902404E40AAECBB6E4840
92520	8356	\N	\N	\N	\N	69.00000	0101000020E6100000060000009F5D0240F0633F211C6F4840
92523	8356	\N	\N	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C0240DAE83039E06F4840
92526	8356	\N	\N	\N	\N	50.00000	0101000020E6100000010000000E7602402EFFFB7A556F4840
92529	8356	\N	\N	\N	\N	34.00000	0101000020E61000000B000000508E024067DC7960DB6E4840
92532	8356	\N	\N	\N	\N	30.00000	0101000020E6100000FEFFFFFF8A8F024069BF0C9F9A6E4840
92535	8356	\N	\N	\N	\N	37.00000	0101000020E6100000FCFFFFFFBCC6024038A43095BC6D4840
92538	8356	\N	\N	\N	\N	49.00000	0101000020E6100000FCFFFFFFFCD10240216E1B3ADD6E4840
92541	8356	\N	\N	\N	\N	44.00000	0101000020E610000001000000EEE00240E5C63B6CA96E4840
92544	8356	\N	\N	\N	\N	41.00000	0101000020E61000000B00000050E80240F4C83C14046F4840
92547	8356	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFFF2EA0240D695822DEA6E4840
92549	8356	\N	\N	\N	\N	64.00000	0101000020E6100000000000002018034090A347C4736E4840
92551	8356	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340AE92DC969F6C4840
92553	8356	\N	\N	\N	\N	47.00000	0101000020E6100000F8FFFFFF325003405AA8B910686C4840
92448	8354	\N	\N	\N	\N	37.00000	0101000020E61000000800000094FF0140455CD3459A714840
92450	8354	\N	\N	\N	\N	37.00000	0101000020E61000000A000000823E0240E9E15B4167704840
92453	8354	\N	\N	\N	\N	50.00000	0101000020E61000000B00000090120240D84204B9786C4840
92456	8354	\N	\N	\N	\N	31.00000	0101000020E6100000F6FFFFFFBD2F02403BE31D01506C4840
92457	8354	\N	\N	\N	\N	36.00000	0101000020E6100000FFFFFFFF315202405D3E66C1296E4840
92461	8354	\N	\N	\N	\N	39.00000	0101000020E6100000F9FFFFFF39590240010713F2F56D4840
92464	8354	\N	\N	\N	\N	44.00000	0101000020E610000003000000BC4F0240DBBE11355E6D4840
92467	8354	\N	\N	\N	\N	39.00000	0101000020E610000006000000785702406BA7F710E46C4840
92470	8354	\N	\N	\N	\N	44.00000	0101000020E6100000FCFFFFFF157D024012A9EF63326C4840
92473	8354	\N	\N	\N	\N	73.00000	0101000020E61000000A000000428D024056A2876F206B4840
92476	8354	\N	\N	\N	\N	70.00000	0101000020E6100000F8FFFFFF0B9602409F1EC53E2F6B4840
92479	8354	\N	\N	\N	\N	62.00000	0101000020E6100000F6FFFFFF3DCD0240A43015C32F6A4840
92482	8354	\N	\N	\N	\N	44.00000	0101000020E6100000FDFFFFFFC30A0340A9BABC65846B4840
92510	8358	\N	\N	\N	\N	121.00000	0101000020E610000006000000F813024023310B9E04674840
92512	8358	\N	\N	\N	\N	90.00000	0101000020E6100000F9FFFFFF19100240BE678CB755684840
92515	8358	\N	\N	\N	\N	83.00000	0101000020E610000002000000951C024031FC4134D9684840
92518	8358	\N	\N	\N	\N	66.00000	0101000020E6100000FFFFFFFF71300240857D755016694840
92521	8358	\N	\N	\N	\N	39.00000	0101000020E61000000B000000B02E02405288D5287C694840
92524	8358	\N	\N	\N	\N	43.00000	0101000020E610000001000000274E02402910E24A996A4840
92527	8358	\N	\N	\N	\N	44.00000	0101000020E610000008000000345F02409F1EC53E2F6B4840
92530	8358	\N	\N	\N	\N	52.00000	0101000020E610000002000000556B0240A9BABC65846B4840
92533	8358	\N	\N	\N	\N	48.00000	0101000020E6100000F8FFFFFF326F0240AE557EE8966B4840
92536	8358	\N	\N	\N	\N	46.00000	0101000020E610000003000000DC6B02407ADD2119DF6B4840
92539	8358	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFF926902400467A8AD856C4840
92542	8358	\N	\N	\N	\N	39.00000	0101000020E6100000040000006A5602405E6FBEEAE56C4840
92545	8358	\N	\N	\N	\N	44.00000	0101000020E61000000A000000624F02409E1C8DE8616D4840
92548	8358	\N	\N	\N	\N	31.00000	0101000020E6100000FFFFFFFFB8520240B1AEC2E1B86D4840
92550	8358	\N	\N	\N	\N	39.00000	0101000020E6100000FFFFFFFF58580240798FC5CBF76D4840
92552	8358	\N	\N	\N	\N	35.00000	0101000020E6100000FDFFFFBF665D02408320235E286E4840
92554	8358	\N	\N	\N	\N	41.00000	0101000020E6100000FCFFFFFFD5710240AC1B6831586D4840
92555	8358	\N	\N	\N	\N	37.00000	0101000020E6100000020000C0BE7D024075E7303D4B6D4840
92556	8358	\N	\N	\N	\N	41.00000	0101000020E6100000090000808E84024096B58239456D4840
92557	8358	\N	\N	\N	\N	44.00000	0101000020E6100000030000C0E583024042C6A1D7E66C4840
92558	8358	\N	\N	\N	\N	43.00000	0101000020E6100000020000C07788024041A82D87686C4840
92559	8358	\N	\N	\N	\N	45.00000	0101000020E610000005000080849D02407DDD93A9FB6C4840
92560	8358	\N	\N	\N	\N	45.00000	0101000020E6100000FAFFFFFF27C502402E486514096D4840
92561	8358	\N	\N	\N	\N	32.00000	0101000020E610000008000000F4DA02406AA961CCB56C4840
92562	8358	\N	\N	\N	\N	43.00000	0101000020E610000004000000EAF30240C2D2A2E53C6D4840
92563	8358	\N	\N	\N	\N	44.00000	0101000020E6100000F8FFFFFFD2FB02408801B1A10E6D4840
92564	8358	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340F6D645A2926C4840
92565	8358	\N	\N	\N	\N	50.00000	0101000020E6100000010000006E5103403919D7F55C6C4840
92566	8358	\N	\N	\N	\N	52.00000	0101000020E6100000FCFFFFFFD55203400731D851ED6C4840
92567	8358	\N	\N	\N	\N	58.00000	0101000020E6100000F8FFFFFF3250034003D595815A6D4840
92568	8358	\N	\N	\N	\N	64.00000	0101000020E6100000F5FFFFFF9664034085D22A528E6D4840
92451	8355	\N	\N	\N	\N	121.00000	0101000020E610000006000000F813024023310B9E04674840
92455	8355	\N	\N	\N	\N	90.00000	0101000020E6100000F9FFFFFF19100240BE678CB755684840
92459	8355	\N	\N	\N	\N	83.00000	0101000020E610000002000000951C024031FC4134D9684840
92462	8355	\N	\N	\N	\N	66.00000	0101000020E6100000FFFFFFFF71300240857D755016694840
92465	8355	\N	\N	\N	\N	39.00000	0101000020E61000000B000000B02E02405288D5287C694840
92468	8355	\N	\N	\N	\N	43.00000	0101000020E610000001000000274E02402910E24A996A4840
92471	8355	\N	\N	\N	\N	44.00000	0101000020E610000008000000345F02409F1EC53E2F6B4840
92474	8355	\N	\N	\N	\N	52.00000	0101000020E610000002000000556B0240A9BABC65846B4840
92477	8355	\N	\N	\N	\N	48.00000	0101000020E6100000F8FFFFFF326F0240AE557EE8966B4840
92480	8355	\N	\N	\N	\N	46.00000	0101000020E610000003000000DC6B02407ADD2119DF6B4840
92483	8355	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFF926902400467A8AD856C4840
92485	8355	\N	\N	\N	\N	39.00000	0101000020E6100000040000006A5602405E6FBEEAE56C4840
92487	8355	\N	\N	\N	\N	44.00000	0101000020E61000000A000000624F02409E1C8DE8616D4840
92489	8355	\N	\N	\N	\N	31.00000	0101000020E6100000FFFFFFFFB8520240B1AEC2E1B86D4840
92491	8355	\N	\N	\N	\N	39.00000	0101000020E6100000FFFFFFFF58580240798FC5CBF76D4840
92492	8355	\N	\N	\N	\N	35.00000	0101000020E6100000FDFFFFBF665D02408320235E286E4840
92493	8355	\N	\N	\N	\N	41.00000	0101000020E6100000FCFFFFFFD5710240AC1B6831586D4840
92494	8355	\N	\N	\N	\N	37.00000	0101000020E6100000020000C0BE7D024075E7303D4B6D4840
92495	8355	\N	\N	\N	\N	41.00000	0101000020E6100000090000808E84024096B58239456D4840
92496	8355	\N	\N	\N	\N	44.00000	0101000020E6100000030000C0E583024042C6A1D7E66C4840
92497	8355	\N	\N	\N	\N	43.00000	0101000020E6100000020000C07788024041A82D87686C4840
92498	8355	\N	\N	\N	\N	45.00000	0101000020E610000005000080849D02407DDD93A9FB6C4840
92499	8355	\N	\N	\N	\N	45.00000	0101000020E6100000FAFFFFFF27C502402E486514096D4840
92500	8355	\N	\N	\N	\N	32.00000	0101000020E610000008000000F4DA02406AA961CCB56C4840
92501	8355	\N	\N	\N	\N	43.00000	0101000020E610000004000000EAF30240C2D2A2E53C6D4840
92502	8355	\N	\N	\N	\N	44.00000	0101000020E6100000F8FFFFFFD2FB02408801B1A10E6D4840
92503	8355	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340F6D645A2926C4840
92504	8355	\N	\N	\N	\N	50.00000	0101000020E6100000010000006E5103403919D7F55C6C4840
92505	8355	\N	\N	\N	\N	52.00000	0101000020E6100000FCFFFFFFD55203400731D851ED6C4840
92506	8355	\N	\N	\N	\N	58.00000	0101000020E6100000F8FFFFFF3250034003D595815A6D4840
92507	8355	\N	\N	\N	\N	64.00000	0101000020E6100000F5FFFFFF9664034085D22A528E6D4840
92509	8357	\N	\N	\N	\N	37.00000	0101000020E61000000800000094FF0140455CD3459A714840
92513	8357	\N	\N	\N	\N	37.00000	0101000020E61000000A000000823E0240E9E15B4167704840
92516	8357	\N	\N	\N	\N	50.00000	0101000020E61000000B00000090120240D84204B9786C4840
92519	8357	\N	\N	\N	\N	31.00000	0101000020E6100000F6FFFFFFBD2F02403BE31D01506C4840
92522	8357	\N	\N	\N	\N	36.00000	0101000020E6100000FFFFFFFF315202405D3E66C1296E4840
92525	8357	\N	\N	\N	\N	39.00000	0101000020E6100000F9FFFFFF39590240010713F2F56D4840
92528	8357	\N	\N	\N	\N	44.00000	0101000020E610000003000000BC4F0240DBBE11355E6D4840
92531	8357	\N	\N	\N	\N	39.00000	0101000020E610000006000000785702406BA7F710E46C4840
92534	8357	\N	\N	\N	\N	44.00000	0101000020E6100000FCFFFFFF157D024012A9EF63326C4840
92537	8357	\N	\N	\N	\N	73.00000	0101000020E61000000A000000428D024056A2876F206B4840
92540	8357	\N	\N	\N	\N	70.00000	0101000020E6100000F8FFFFFF0B9602409F1EC53E2F6B4840
92543	8357	\N	\N	\N	\N	62.00000	0101000020E6100000F6FFFFFF3DCD0240A43015C32F6A4840
92546	8357	\N	\N	\N	\N	44.00000	0101000020E6100000FDFFFFFFC30A0340A9BABC65846B4840
92145	8338	\N	\N	\N	\N	31.00000	0101000020E610000007000000E6520240926D080E266E4840
92149	8338	\N	\N	\N	\N	50.00000	0101000020E61000000B0000001056024081F69977776E4840
92152	8338	\N	\N	\N	\N	57.00000	0101000020E610000001000000EE5902404E40AAECBB6E4840
92155	8338	\N	\N	\N	\N	69.00000	0101000020E6100000060000009F5D0240F0633F211C6F4840
92158	8338	\N	\N	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C0240DAE83039E06F4840
92161	8338	\N	\N	\N	\N	50.00000	0101000020E6100000010000000E7602402EFFFB7A556F4840
92164	8338	\N	\N	\N	\N	34.00000	0101000020E61000000B000000508E024067DC7960DB6E4840
92167	8338	\N	\N	\N	\N	30.00000	0101000020E6100000FEFFFFFF8A8F024069BF0C9F9A6E4840
92170	8338	\N	\N	\N	\N	37.00000	0101000020E6100000FCFFFFFFBCC6024038A43095BC6D4840
92173	8338	\N	\N	\N	\N	49.00000	0101000020E6100000FCFFFFFFFCD10240216E1B3ADD6E4840
92176	8338	\N	\N	\N	\N	44.00000	0101000020E610000001000000EEE00240E5C63B6CA96E4840
92180	8338	\N	\N	\N	\N	41.00000	0101000020E61000000B00000050E80240F4C83C14046F4840
92183	8338	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFFF2EA0240D695822DEA6E4840
92184	8338	\N	\N	\N	\N	64.00000	0101000020E6100000000000002018034090A347C4736E4840
92186	8338	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340AE92DC969F6C4840
92188	8338	\N	\N	\N	\N	47.00000	0101000020E6100000F8FFFFFF325003405AA8B910686C4840
92207	8342	\N	\N	\N	\N	37.00000	0101000020E61000000800000094FF0140455CD3459A714840
92209	8342	\N	\N	\N	\N	37.00000	0101000020E61000000A000000823E0240E9E15B4167704840
92211	8342	\N	\N	\N	\N	50.00000	0101000020E61000000B00000090120240D84204B9786C4840
92213	8342	\N	\N	\N	\N	31.00000	0101000020E6100000F6FFFFFFBD2F02403BE31D01506C4840
92215	8342	\N	\N	\N	\N	36.00000	0101000020E6100000FFFFFFFF315202405D3E66C1296E4840
92217	8342	\N	\N	\N	\N	39.00000	0101000020E6100000F9FFFFFF39590240010713F2F56D4840
92219	8342	\N	\N	\N	\N	44.00000	0101000020E610000003000000BC4F0240DBBE11355E6D4840
92221	8342	\N	\N	\N	\N	39.00000	0101000020E610000006000000785702406BA7F710E46C4840
92223	8342	\N	\N	\N	\N	44.00000	0101000020E6100000FCFFFFFF157D024012A9EF63326C4840
92225	8342	\N	\N	\N	\N	73.00000	0101000020E61000000A000000428D024056A2876F206B4840
92226	8342	\N	\N	\N	\N	70.00000	0101000020E6100000F8FFFFFF0B9602409F1EC53E2F6B4840
92228	8342	\N	\N	\N	\N	62.00000	0101000020E6100000F6FFFFFF3DCD0240A43015C32F6A4840
92231	8342	\N	\N	\N	\N	44.00000	0101000020E6100000FDFFFFFFC30A0340A9BABC65846B4840
92289	8346	\N	\N	\N	\N	121.00000	0101000020E610000006000000F813024023310B9E04674840
92292	8346	\N	\N	\N	\N	90.00000	0101000020E6100000F9FFFFFF19100240BE678CB755684840
92295	8346	\N	\N	\N	\N	83.00000	0101000020E610000002000000951C024031FC4134D9684840
92296	8346	\N	\N	\N	\N	66.00000	0101000020E6100000FFFFFFFF71300240857D755016694840
92298	8346	\N	\N	\N	\N	39.00000	0101000020E61000000B000000B02E02405288D5287C694840
92299	8346	\N	\N	\N	\N	43.00000	0101000020E610000001000000274E02402910E24A996A4840
92300	8346	\N	\N	\N	\N	44.00000	0101000020E610000008000000345F02409F1EC53E2F6B4840
92301	8346	\N	\N	\N	\N	52.00000	0101000020E610000002000000556B0240A9BABC65846B4840
92302	8346	\N	\N	\N	\N	48.00000	0101000020E6100000F8FFFFFF326F0240AE557EE8966B4840
92303	8346	\N	\N	\N	\N	46.00000	0101000020E610000003000000DC6B02407ADD2119DF6B4840
92304	8346	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFF926902400467A8AD856C4840
92305	8346	\N	\N	\N	\N	39.00000	0101000020E6100000040000006A5602405E6FBEEAE56C4840
92306	8346	\N	\N	\N	\N	44.00000	0101000020E61000000A000000624F02409E1C8DE8616D4840
92307	8346	\N	\N	\N	\N	31.00000	0101000020E6100000FFFFFFFFB8520240B1AEC2E1B86D4840
92308	8346	\N	\N	\N	\N	39.00000	0101000020E6100000FFFFFFFF58580240798FC5CBF76D4840
92309	8346	\N	\N	\N	\N	35.00000	0101000020E6100000FDFFFFBF665D02408320235E286E4840
92310	8346	\N	\N	\N	\N	41.00000	0101000020E6100000FCFFFFFFD5710240AC1B6831586D4840
92311	8346	\N	\N	\N	\N	37.00000	0101000020E6100000020000C0BE7D024075E7303D4B6D4840
92312	8346	\N	\N	\N	\N	41.00000	0101000020E6100000090000808E84024096B58239456D4840
92313	8346	\N	\N	\N	\N	44.00000	0101000020E6100000030000C0E583024042C6A1D7E66C4840
92314	8346	\N	\N	\N	\N	43.00000	0101000020E6100000020000C07788024041A82D87686C4840
92315	8346	\N	\N	\N	\N	45.00000	0101000020E610000005000080849D02407DDD93A9FB6C4840
92316	8346	\N	\N	\N	\N	45.00000	0101000020E6100000FAFFFFFF27C502402E486514096D4840
92317	8346	\N	\N	\N	\N	32.00000	0101000020E610000008000000F4DA02406AA961CCB56C4840
92318	8346	\N	\N	\N	\N	43.00000	0101000020E610000004000000EAF30240C2D2A2E53C6D4840
92319	8346	\N	\N	\N	\N	44.00000	0101000020E6100000F8FFFFFFD2FB02408801B1A10E6D4840
92320	8346	\N	\N	\N	\N	51.00000	0101000020E61000000A000000C22A0340F6D645A2926C4840
92321	8346	\N	\N	\N	\N	50.00000	0101000020E6100000010000006E5103403919D7F55C6C4840
92322	8346	\N	\N	\N	\N	52.00000	0101000020E6100000FCFFFFFFD55203400731D851ED6C4840
92323	8346	\N	\N	\N	\N	58.00000	0101000020E6100000F8FFFFFF3250034003D595815A6D4840
92324	8346	\N	\N	\N	\N	64.00000	0101000020E6100000F5FFFFFF9664034085D22A528E6D4840
92326	8348	\N	\N	\N	\N	37.00000	0101000020E61000000800000094FF0140455CD3459A714840
92329	8348	\N	\N	\N	\N	37.00000	0101000020E61000000A000000823E0240E9E15B4167704840
92332	8348	\N	\N	\N	\N	50.00000	0101000020E61000000B00000090120240D84204B9786C4840
92335	8348	\N	\N	\N	\N	31.00000	0101000020E6100000F6FFFFFFBD2F02403BE31D01506C4840
92339	8348	\N	\N	\N	\N	36.00000	0101000020E6100000FFFFFFFF315202405D3E66C1296E4840
92342	8348	\N	\N	\N	\N	39.00000	0101000020E6100000F9FFFFFF39590240010713F2F56D4840
92345	8348	\N	\N	\N	\N	44.00000	0101000020E610000003000000BC4F0240DBBE11355E6D4840
92348	8348	\N	\N	\N	\N	39.00000	0101000020E610000006000000785702406BA7F710E46C4840
92351	8348	\N	\N	\N	\N	44.00000	0101000020E6100000FCFFFFFF157D024012A9EF63326C4840
92354	8348	\N	\N	\N	\N	73.00000	0101000020E61000000A000000428D024056A2876F206B4840
92357	8348	\N	\N	\N	\N	70.00000	0101000020E6100000F8FFFFFF0B9602409F1EC53E2F6B4840
92360	8348	\N	\N	\N	\N	62.00000	0101000020E6100000F6FFFFFF3DCD0240A43015C32F6A4840
92363	8348	\N	\N	\N	\N	44.00000	0101000020E6100000FDFFFFFFC30A0340A9BABC65846B4840
92389	8351	\N	\N	\N	\N	37.00000	0101000020E61000000800000094FF0140455CD3459A714840
92391	8351	\N	\N	\N	\N	37.00000	0101000020E61000000A000000823E0240E9E15B4167704840
92393	8351	\N	\N	\N	\N	50.00000	0101000020E61000000B00000090120240D84204B9786C4840
92395	8351	\N	\N	\N	\N	31.00000	0101000020E6100000F6FFFFFFBD2F02403BE31D01506C4840
92397	8351	\N	\N	\N	\N	36.00000	0101000020E6100000FFFFFFFF315202405D3E66C1296E4840
92399	8351	\N	\N	\N	\N	39.00000	0101000020E6100000F9FFFFFF39590240010713F2F56D4840
92401	8351	\N	\N	\N	\N	44.00000	0101000020E610000003000000BC4F0240DBBE11355E6D4840
92403	8351	\N	\N	\N	\N	39.00000	0101000020E610000006000000785702406BA7F710E46C4840
92404	8351	\N	\N	\N	\N	44.00000	0101000020E6100000FCFFFFFF157D024012A9EF63326C4840
92406	8351	\N	\N	\N	\N	73.00000	0101000020E61000000A000000428D024056A2876F206B4840
92408	8351	\N	\N	\N	\N	70.00000	0101000020E6100000F8FFFFFF0B9602409F1EC53E2F6B4840
92410	8351	\N	\N	\N	\N	62.00000	0101000020E6100000F6FFFFFF3DCD0240A43015C32F6A4840
92412	8351	\N	\N	\N	\N	44.00000	0101000020E6100000FDFFFFFFC30A0340A9BABC65846B4840
92416	8352	\N	\N	\N	\N	121.00000	0101000020E610000006000000F813024023310B9E04674840
92417	8352	\N	\N	\N	\N	90.00000	0101000020E6100000F9FFFFFF19100240BE678CB755684840
92418	8352	\N	\N	\N	\N	83.00000	0101000020E610000002000000951C024031FC4134D9684840
92419	8352	\N	\N	\N	\N	66.00000	0101000020E6100000FFFFFFFF71300240857D755016694840
92420	8352	\N	\N	\N	\N	39.00000	0101000020E61000000B000000B02E02405288D5287C694840
92421	8352	\N	\N	\N	\N	43.00000	0101000020E610000001000000274E02402910E24A996A4840
92422	8352	\N	\N	\N	\N	44.00000	0101000020E610000008000000345F02409F1EC53E2F6B4840
92423	8352	\N	\N	\N	\N	52.00000	0101000020E610000002000000556B0240A9BABC65846B4840
92424	8352	\N	\N	\N	\N	48.00000	0101000020E6100000F8FFFFFF326F0240AE557EE8966B4840
92425	8352	\N	\N	\N	\N	46.00000	0101000020E610000003000000DC6B02407ADD2119DF6B4840
92426	8352	\N	\N	\N	\N	40.00000	0101000020E6100000F8FFFFFF926902400467A8AD856C4840
92427	8352	\N	\N	\N	\N	39.00000	0101000020E6100000040000006A5602405E6FBEEAE56C4840
92428	8352	\N	\N	\N	\N	44.00000	0101000020E61000000A000000624F02409E1C8DE8616D4840
92429	8352	\N	\N	\N	\N	31.00000	0101000020E6100000FFFFFFFFB8520240B1AEC2E1B86D4840
92430	8352	\N	\N	\N	\N	39.00000	0101000020E6100000FFFFFFFF58580240798FC5CBF76D4840
92431	8352	\N	\N	\N	\N	35.00000	0101000020E6100000FDFFFFBF665D02408320235E286E4840
92432	8352	\N	\N	\N	\N	41.00000	0101000020E6100000FCFFFFFFD5710240AC1B6831586D4840
92433	8352	\N	\N	\N	\N	37.00000	0101000020E6100000020000C0BE7D024075E7303D4B6D4840
92434	8352	\N	\N	\N	\N	41.00000	0101000020E6100000090000808E84024096B58239456D4840
92435	8352	\N	\N	\N	\N	44.00000	0101000020E6100000030000C0E583024042C6A1D7E66C4840
92436	8352	\N	\N	\N	\N	43.00000	0101000020E6100000020000C07788024041A82D87686C4840
\.


--
-- Data for Name: itinerary_sharing; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.itinerary_sharing (itinerary_id, shared_to_id, active) FROM stdin;
2333	1	t
2333	791	t
2333	456	t
982	29	t
983	29	t
\.


--
-- Data for Name: itinerary_track; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.itinerary_track (id, itinerary_id, name, color, distance, ascent, descent, lowest, highest) FROM stdin;
1015	929	Test track one	Green	\N	\N	\N	\N	\N
1025	983	Test track one	Green	\N	\N	\N	\N	\N
1026	983	Test track name	Yellow	\N	\N	\N	\N	\N
1027	2425	Test track 01	Blue	60.33	1481.9	1688.6	54.1	436.5
1028	2425	Test track 02	Green	60.33	1481.9	1688.6	54.1	436.5
1016	929	Test track name	Yellow	\N	\N	\N	\N	\N
1038	2430	Track 03	Cyan	24.58	86.0	36.0	31.0	86.0
1036	2430	Track 01	\N	9.89	73.0	64.0	32.0	64.0
1039	2430	Track 04	Green	6.73	45.0	11.0	30.0	73.0
1037	2430	Track 02	Red	18.27	107.0	100.0	24.0	73.0
1040	2432	Track 01	\N	9.89	73.0	64.0	32.0	64.0
1042	2432	Track 03	Cyan	24.58	86.0	36.0	31.0	86.0
1041	2432	Track 02	Red	18.27	107.0	100.0	24.0	73.0
1043	2432	Track 04	Green	6.73	45.0	11.0	30.0	73.0
1046	2433	Track 03	Cyan	24.58	86.0	36.0	31.0	86.0
1044	2433	Track 01	\N	9.89	73.0	64.0	32.0	64.0
1045	2433	Track 02	Red	18.27	107.0	100.0	24.0	73.0
1047	2433	Track 04	Green	6.73	45.0	11.0	30.0	73.0
1048	2434	Track 01	\N	9.89	73.0	64.0	32.0	64.0
1050	2434	Track 03	Cyan	24.58	86.0	36.0	31.0	86.0
1049	2434	Track 02	Red	18.27	107.0	100.0	24.0	73.0
1051	2434	Track 04	Green	6.73	45.0	11.0	30.0	73.0
1053	2435	Track 03	Cyan	24.58	86.0	36.0	31.0	86.0
1052	2435	Track 01	\N	9.89	73.0	64.0	32.0	64.0
1055	2435	Track 04	Green	6.73	45.0	11.0	30.0	73.0
1054	2435	Track 02	Red	18.27	107.0	100.0	24.0	73.0
1057	2436	Track 03	Cyan	24.58	86.0	36.0	31.0	86.0
1056	2436	Track 01	\N	9.89	73.0	64.0	32.0	64.0
1059	2436	Track 04	Green	6.73	45.0	11.0	30.0	73.0
1058	2436	Track 02	Red	18.27	107.0	100.0	24.0	73.0
1062	2437	Track 03	Cyan	24.58	86.0	36.0	31.0	86.0
1060	2437	Track 01	\N	9.89	73.0	64.0	32.0	64.0
1063	2437	Track 04	Green	6.73	45.0	11.0	30.0	73.0
1061	2437	Track 02	Red	18.27	107.0	100.0	24.0	73.0
1066	2438	Track 03	Cyan	24.58	86.0	36.0	31.0	86.0
1064	2438	Track 01	\N	9.89	73.0	64.0	32.0	64.0
1065	2438	Track 02	Red	18.27	107.0	100.0	24.0	73.0
1067	2438	Track 04	Green	6.73	45.0	11.0	30.0	73.0
1068	2439	Track 01	\N	9.89	73.0	64.0	32.0	64.0
1069	2439	Track 02	Red	18.27	107.0	100.0	24.0	73.0
1070	2439	Track 03	Cyan	24.58	86.0	36.0	31.0	86.0
1071	2439	Track 04	Green	6.73	45.0	11.0	30.0	73.0
1074	2440	Track 03	Cyan	24.58	86.0	36.0	31.0	86.0
1072	2440	Track 01	\N	9.89	73.0	64.0	32.0	64.0
1075	2440	Track 04	Green	6.73	45.0	11.0	30.0	73.0
1073	2440	Track 02	Red	18.27	107.0	100.0	24.0	73.0
1076	2441	Track 01	\N	9.89	73.0	64.0	32.0	64.0
1077	2441	Track 02	Red	18.27	107.0	100.0	24.0	73.0
1078	2441	Track 03	Cyan	24.58	86.0	36.0	31.0	86.0
1079	2441	Track 04	Green	6.73	45.0	11.0	30.0	73.0
1081	2442	Track 03	Cyan	24.58	86.0	36.0	31.0	86.0
1080	2442	Track 02	Red	18.27	107.0	100.0	24.0	73.0
1083	2442	Track 04	Green	6.73	45.0	11.0	30.0	73.0
1082	2442	Track 01	\N	9.89	73.0	64.0	32.0	64.0
\.


--
-- Data for Name: itinerary_track_point; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.itinerary_track_point (id, itinerary_track_segment_id, "time", hdop, altitude, geog) FROM stdin;
1323736	5756	1970-01-01 00:00:01+00	140.0	100.00000	0101000020E6100000C40802E0EF1C50C08EA5F6BFAF7E3240
1323737	5756	1970-01-01 00:00:02+00	\N	100.00000	0101000020E610000060AAFCDFCF5F5AC0729905A072B44640
1323738	5756	1970-01-01 00:00:03+00	\N	100.00000	0101000020E61000002BB100E0B7B660C0BEDBDD7F3B930AC0
1323739	5756	1970-01-01 00:00:04+00	\N	100.00000	0101000020E610000060AAFCDFCFAE56C03447567E192CE3BF
1323740	5756	1970-01-01 00:00:05+00	\N	100.00000	0101000020E6100000BA5529A0FD2E1BC08E26300001391040
1323741	5756	1970-01-01 00:00:06+00	\N	100.00000	0101000020E61000003510262081D62A4089E2E17F232C22C0
1323742	5757	1970-01-01 00:00:07+00	\N	100.00000	0101000020E6100000F1DCF77F40D0314021E7FD7F1CAC40C0
1323743	5757	1970-01-01 00:00:08+00	\N	100.00000	0101000020E6100000F1DCF77F40133A409E710AC0796641C0
1323744	5757	1970-01-01 00:00:09+00	\N	100.00000	0101000020E610000040AB064060224640C936F43F8EF139C0
1323745	5757	1970-01-01 00:00:10+00	\N	100.00000	0101000020E610000040AB0640E08F4940B78928601A982740
1323746	5757	1970-01-01 00:00:11+00	\N	100.00000	0101000020E61000007E6FD39FFD5017C05A9402A0C40E4240
1323747	5757	1970-01-01 00:00:12+00	\N	100.00000	0101000020E6100000DABFFC5FBFE33BC0F71D058091504340
1323748	5757	1970-01-01 00:00:13+00	\N	100.00000	0101000020E6100000196B03A09F994EC0B78928601A982740
1323749	5758	1970-01-01 00:00:01+00	140.0	100.00000	0101000020E6100000881104C0DF394BC08EA5F6BFAF7E3140
1323750	5758	1970-01-01 00:00:02+00	\N	100.00000	0101000020E610000060AAFCDFCFDF52C0729905A072344540
1323937	5771	1970-01-01 00:00:01+00	140.0	100.00000	0101000020E6100000C40802E0EF1C50C08EA5F6BFAF7E3240
1323938	5771	1970-01-01 00:00:02+00	\N	100.00000	0101000020E610000060AAFCDFCF5F5AC0729905A072B44640
1323939	5771	1970-01-01 00:00:03+00	\N	100.00000	0101000020E61000002BB100E0B7B660C0BEDBDD7F3B930AC0
1323940	5771	1970-01-01 00:00:04+00	\N	100.00000	0101000020E610000060AAFCDFCFAE56C03447567E192CE3BF
1323941	5771	1970-01-01 00:00:05+00	\N	100.00000	0101000020E6100000BA5529A0FD2E1BC08E26300001391040
1323942	5771	1970-01-01 00:00:06+00	\N	100.00000	0101000020E61000003510262081D62A4089E2E17F232C22C0
1323943	5772	1970-01-01 00:00:07+00	\N	100.00000	0101000020E6100000F1DCF77F40D0314021E7FD7F1CAC40C0
1323944	5772	1970-01-01 00:00:08+00	\N	100.00000	0101000020E6100000F1DCF77F40133A409E710AC0796641C0
1323945	5772	1970-01-01 00:00:09+00	\N	100.00000	0101000020E610000040AB064060224640C936F43F8EF139C0
1323946	5772	1970-01-01 00:00:10+00	\N	100.00000	0101000020E610000040AB0640E08F4940B78928601A982740
1323947	5772	1970-01-01 00:00:11+00	\N	100.00000	0101000020E61000007E6FD39FFD5017C05A9402A0C40E4240
1323948	5772	1970-01-01 00:00:12+00	\N	100.00000	0101000020E6100000DABFFC5FBFE33BC0F71D058091504340
1323949	5772	1970-01-01 00:00:13+00	\N	100.00000	0101000020E6100000196B03A09F994EC0B78928601A982740
1323950	5773	1970-01-01 00:00:01+00	140.0	100.00000	0101000020E6100000881104C0DF394BC08EA5F6BFAF7E3140
1323951	5773	1970-01-01 00:00:02+00	\N	100.00000	0101000020E610000060AAFCDFCFDF52C0729905A072344540
1323998	5777	1970-01-01 00:00:01+00	14.8	349.80000	0101000020E6100000984727E0114010C0B2DAFCBF6A474940
1323999	5777	1970-01-01 00:00:02+00	38.3	161.70000	0101000020E61000000585E6DFD34110C04BDB09406D494940
1324000	5777	1970-01-01 00:00:03+00	33.1	296.50000	0101000020E610000013FFE2DF883210C0B19B0060484B4940
1324001	5777	1970-01-01 00:00:04+00	98.9	215.90000	0101000020E6100000DFAD2460111B10C0E389FFBFDA4B4940
1324002	5777	1970-01-01 00:00:05+00	102.7	312.60000	0101000020E610000058C5C0DFD40410C09ABD01A0694C4940
1324003	5777	1970-01-01 00:00:06+00	30.8	61.80000	0101000020E6100000199571DFACD90FC04C410AE05E4C4940
1324004	5777	1970-01-01 00:00:07+00	14.7	274.10000	0101000020E61000004BF4A6E0F8AB0FC0BFEEF81FAE4B4940
1324005	5777	1970-01-01 00:00:08+00	90.2	283.90000	0101000020E6100000984727E011840FC0EF76F7DFCE4A4940
1324006	5777	1970-01-01 00:00:09+00	83.4	80.90000	0101000020E610000062A2DEDFE2490FC04B71FA1F054A4940
1324007	5777	1970-01-01 00:00:10+00	52.0	387.30000	0101000020E6100000BBD594E0E4290FC0411107E0D1484940
1324008	5777	1970-01-01 00:00:11+00	46.4	376.40000	0101000020E61000007314BDDFAAEB0EC0C015FD5FFD4A4940
1324009	5777	1970-01-01 00:00:12+00	56.4	436.50000	0101000020E61000000585E6DFD3D10EC075FBF6BFED4C4940
1324010	5777	1970-01-01 00:00:13+00	67.6	358.20000	0101000020E6100000217B7BDF11D00EC0115EF55FEB4F4940
1324011	5777	1970-01-01 00:00:14+00	57.9	59.60000	0101000020E6100000F0CE90E0FCE40EC0F8DAF99FF8524940
1324012	5777	1970-01-01 00:00:15+00	11.0	55.40000	0101000020E6100000217F61E056E50EC0024E08801E594940
1324013	5777	1970-01-01 00:00:16+00	87.4	279.20000	0101000020E6100000780799E0AB080FC02EFBF9DFDF5B4940
1324014	5777	1970-01-01 00:00:17+00	86.5	353.30000	0101000020E61000007CF82AE03B2D0FC01F42018088604940
1324015	5777	1970-01-01 00:00:18+00	39.2	223.50000	0101000020E6100000D620ABDF756B0FC020FFF59F6F5B4940
1324016	5777	1970-01-01 00:00:19+00	26.2	424.90000	0101000020E6100000EF7C79E0E7800FC0EB6F09C03F554940
1324017	5777	1970-01-01 00:00:20+00	92.1	139.00000	0101000020E6100000EA2F68DFE4B00FC031C7FA1FC3524940
1324018	5777	1970-01-01 00:00:21+00	19.1	54.10000	0101000020E6100000B787B5DF770710C0B8F0F6FFF54F4940
1324019	5777	1970-01-01 00:00:22+00	95.3	216.60000	0101000020E6100000FBA6FADF5B3210C01B1000A033514940
1324020	5777	1970-01-01 00:00:23+00	66.1	143.10000	0101000020E6100000B68BC45FEE2E10C005EFF5FFBB4E4940
1324021	5778	1970-01-01 00:00:01+00	14.8	349.80000	0101000020E6100000984727E0114010C0B2DAFCBF6A474940
1324022	5778	1970-01-01 00:00:02+00	38.3	161.70000	0101000020E61000000585E6DFD34110C04BDB09406D494940
1324023	5778	1970-01-01 00:00:03+00	33.1	296.50000	0101000020E610000013FFE2DF883210C0B19B0060484B4940
1324024	5778	1970-01-01 00:00:04+00	98.9	215.90000	0101000020E6100000DFAD2460111B10C0E389FFBFDA4B4940
1324025	5778	1970-01-01 00:00:05+00	102.7	312.60000	0101000020E610000058C5C0DFD40410C09ABD01A0694C4940
1324026	5778	1970-01-01 00:00:06+00	30.8	61.80000	0101000020E6100000199571DFACD90FC04C410AE05E4C4940
1324027	5778	1970-01-01 00:00:07+00	14.7	274.10000	0101000020E61000004BF4A6E0F8AB0FC0BFEEF81FAE4B4940
1324028	5778	1970-01-01 00:00:08+00	90.2	283.90000	0101000020E6100000984727E011840FC0EF76F7DFCE4A4940
1324029	5778	1970-01-01 00:00:09+00	83.4	80.90000	0101000020E610000062A2DEDFE2490FC04B71FA1F054A4940
1324030	5778	1970-01-01 00:00:10+00	52.0	387.30000	0101000020E6100000BBD594E0E4290FC0411107E0D1484940
1324031	5778	1970-01-01 00:00:11+00	46.4	376.40000	0101000020E61000007314BDDFAAEB0EC0C015FD5FFD4A4940
1324032	5778	1970-01-01 00:00:12+00	56.4	436.50000	0101000020E61000000585E6DFD3D10EC075FBF6BFED4C4940
1324033	5778	1970-01-01 00:00:13+00	67.6	358.20000	0101000020E6100000217B7BDF11D00EC0115EF55FEB4F4940
1324034	5778	1970-01-01 00:00:14+00	57.9	59.60000	0101000020E6100000F0CE90E0FCE40EC0F8DAF99FF8524940
1324035	5778	1970-01-01 00:00:15+00	11.0	55.40000	0101000020E6100000217F61E056E50EC0024E08801E594940
1324036	5778	1970-01-01 00:00:16+00	87.4	279.20000	0101000020E6100000780799E0AB080FC02EFBF9DFDF5B4940
1324037	5778	1970-01-01 00:00:17+00	86.5	353.30000	0101000020E61000007CF82AE03B2D0FC01F42018088604940
1324038	5778	1970-01-01 00:00:18+00	39.2	223.50000	0101000020E6100000D620ABDF756B0FC020FFF59F6F5B4940
1324039	5778	1970-01-01 00:00:19+00	26.2	424.90000	0101000020E6100000EF7C79E0E7800FC0EB6F09C03F554940
1324040	5778	1970-01-01 00:00:20+00	92.1	139.00000	0101000020E6100000EA2F68DFE4B00FC031C7FA1FC3524940
1324041	5778	1970-01-01 00:00:21+00	19.1	54.10000	0101000020E6100000B787B5DF770710C0B8F0F6FFF54F4940
1324042	5778	1970-01-01 00:00:22+00	95.3	216.60000	0101000020E6100000FBA6FADF5B3210C01B1000A033514940
1324043	5778	1970-01-01 00:00:23+00	66.1	143.10000	0101000020E6100000B68BC45FEE2E10C005EFF5FFBB4E4940
1324292	5794	\N	\N	42.00000	0101000020E6100000020000C01E4B0240D6CB02D7A66D4840
1324293	5794	\N	\N	43.00000	0101000020E610000008000000544E0240F1322640D36D4840
1324294	5795	\N	\N	36.00000	0101000020E6100000FAFFFFFF870B0240413D64E36D714840
1324295	5794	\N	\N	33.00000	0101000020E6100000FCFFFF3F2C540240641A81E21E6E4840
1324296	5796	\N	\N	36.00000	0101000020E6100000FBFFFFFF0E0C0240DC1682306A714840
1324297	5794	\N	\N	39.00000	0101000020E61000000C000020A25802407AFB30A0F06D4840
1324298	5795	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C02406F6BF6D2D86F4840
1324299	5794	\N	\N	42.00000	0101000020E6100000FBFFFF9FAD540240431506B3CD6D4840
1324300	5796	\N	\N	48.00000	0101000020E6100000030000007CCB024028E7B8C9D26D4840
1324301	5795	\N	\N	64.00000	0101000020E6100000060000009F5D0240B9E5CABA146F4840
1324302	5794	\N	\N	34.00000	0101000020E610000008000000F4530240CA21B070C16D4840
1324303	5796	\N	\N	38.00000	0101000020E6100000040000004AEE02400D34C1B4536C4840
1324304	5795	\N	\N	60.00000	0101000020E6100000F9FFFFFF395902406399FDE5AF6E4840
1324305	5794	\N	\N	47.00000	0101000020E6100000F8FFFF9FAA570240084BF4E2996D4840
1324306	5796	\N	\N	31.00000	0101000020E610000000000000C01D03406B26952FD3694840
1324307	5795	\N	\N	52.00000	0101000020E6100000FEFFFF7F9E6502404E40AAECBB6E4840
1324308	5794	\N	\N	43.00000	0101000020E6100000F7FFFF5FC65D0240DBBE11355E6D4840
1324309	5796	\N	\N	33.00000	0101000020E6100000FFFFFFFF514F0340F87779179C684840
1324310	5795	\N	\N	24.00000	0101000020E61000000B0000807C6902402118697FA86E4840
1324311	5794	\N	\N	41.00000	0101000020E6100000FAFFFF5F6960024062F9C25F436D4840
1324312	5796	\N	\N	32.00000	0101000020E6100000FDFFFFFF039D034016AE15A56F684840
1324313	5795	\N	\N	44.00000	0101000020E610000008000000CD7A02407679FBBA396F4840
1324314	5794	\N	\N	45.00000	0101000020E6100000FCFFFFBF1F68024075A44507F46C4840
1324315	5796	\N	\N	57.00000	0101000020E61000000B00000070B803406B26952FD3694840
1324316	5795	\N	\N	52.00000	0101000020E610000002000000F5700240FDBF7B746E6F4840
1324317	5794	\N	\N	44.00000	0101000020E610000002000080A8790240443403C0466C4840
1324318	5796	\N	\N	39.00000	0101000020E6100000030000005CEA0340CC8CD246426A4840
1324319	5795	\N	\N	44.00000	0101000020E61000000C000080E37A0240C46E0B9AB66F4840
1324320	5794	\N	\N	44.00000	0101000020E61000000B000000707D0240BD9B1B8A306C4840
1324321	5796	\N	\N	84.00000	0101000020E6100000FDFFFFFF432F0440109C90C7CB694840
1324322	5795	\N	\N	48.00000	0101000020E61000000A000080F5950240F405B827286F4840
1324323	5794	\N	\N	42.00000	0101000020E610000007000000868502402E9DEFDA516C4840
1324324	5796	\N	\N	86.00000	0101000020E6100000FDFFFFFFA35604405D6441A0116B4840
1324325	5795	\N	\N	33.00000	0101000020E6100000FBFFFFFF6E8D0240EE0CCEE3656E4840
1324326	5794	\N	\N	43.00000	0101000020E61000000B000000298802405AA8B910686C4840
1324327	5795	\N	\N	34.00000	0101000020E6100000FDFFFFFF237E02409AC4F410706E4840
1324328	5794	\N	\N	64.00000	0101000020E610000004000000E3AF02408B4138FE7C6B4840
1324329	5794	\N	\N	48.00000	0101000020E6100000FAFFFFFFE0CF0240979BE507196B4840
1324330	5795	\N	\N	36.00000	0101000020E6100000F7FFFF7FF8650240E231A3B65B6E4840
1324331	5797	\N	\N	32.00000	0101000020E610000007000000268B02409AC4F410706E4840
1324332	5794	\N	\N	46.00000	0101000020E6100000060000009FE40240A9BABC65846B4840
1324333	5795	\N	\N	33.00000	0101000020E610000007000080B26002408A11415C476E4840
1324334	5797	\N	\N	30.00000	0101000020E6100000F8FFFFFF6B6302404EC44C03586E4840
1324335	5794	\N	\N	32.00000	0101000020E610000001000000A7EB02403C8374A0166C4840
1324336	5795	\N	\N	30.00000	0101000020E6100000F9FFFF7F265602400DEC661DDB6D4840
1324337	5797	\N	\N	33.00000	0101000020E610000005000000915C02405D3E66C1296E4840
1324338	5794	\N	\N	45.00000	0101000020E610000000000000C0F00240A619E57E3D6C4840
1324339	5795	\N	\N	34.00000	0101000020E610000005000080DD530240900D9E48C06D4840
1324340	5797	\N	\N	43.00000	0101000020E610000009000000BB5F024043242B8D136E4840
1324341	5794	\N	\N	40.00000	0101000020E6100000FCFFFFFF35F3024012A9EF63326C4840
1324342	5795	\N	\N	45.00000	0101000020E6100000FBFFFF7F9B680240E2499E2BEF6C4840
1324343	5797	\N	\N	42.00000	0101000020E61000000B000000F06602403B01E362CB6D4840
1324344	5794	\N	\N	51.00000	0101000020E6100000F8FFFFFFD2280340F6D645A2926C4840
1324345	5795	\N	\N	44.00000	0101000020E6100000FBFFFF7F027A0240CA31B8583F6C4840
1324346	5797	\N	\N	41.00000	0101000020E6100000FCFFFFFFD571024071DB535B5C6D4840
1324347	5795	\N	\N	44.00000	0101000020E610000007000080597D024012A9EF63326C4840
1324348	5797	\N	\N	43.00000	0101000020E6100000F6FFFFFF5D620240EC7C3765AE6C4840
1324349	5795	\N	\N	73.00000	0101000020E610000004000080968B02401542EA772C6B4840
1324350	5797	\N	\N	44.00000	0101000020E61000000B000000E97C0240A04BF548276C4840
1324351	5795	\N	\N	73.00000	0101000020E610000009000000BB8C0240B0E9DD642D6B4840
1324353	5795	\N	\N	69.00000	0101000020E610000001000080BA9402401B9460A6366B4840
1324355	5795	\N	\N	55.00000	0101000020E6100000FEFFFFFFCAC70240A43015C32F6A4840
1324357	5795	\N	\N	43.00000	0101000020E610000001000000AE020340EB7810605F6B4840
1324352	5797	\N	\N	73.00000	0101000020E610000000000000808B0240B5160FB1296B4840
1324354	5797	\N	\N	69.00000	0101000020E6100000F6FFFFFFFD9402408930AC18316B4840
1324356	5797	\N	\N	66.00000	0101000020E6100000F9FFFFFFF9A702401F89A22BC06A4840
1324358	5798	\N	\N	42.00000	0101000020E6100000020000C01E4B0240D6CB02D7A66D4840
1324359	5798	\N	\N	43.00000	0101000020E610000008000000544E0240F1322640D36D4840
1324360	5798	\N	\N	33.00000	0101000020E6100000FCFFFF3F2C540240641A81E21E6E4840
1324361	5798	\N	\N	39.00000	0101000020E61000000C000020A25802407AFB30A0F06D4840
1324362	5799	\N	\N	36.00000	0101000020E6100000FAFFFFFF870B0240413D64E36D714840
1324363	5798	\N	\N	42.00000	0101000020E6100000FBFFFF9FAD540240431506B3CD6D4840
1324364	5799	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C02406F6BF6D2D86F4840
1324365	5798	\N	\N	34.00000	0101000020E610000008000000F4530240CA21B070C16D4840
1324366	5799	\N	\N	64.00000	0101000020E6100000060000009F5D0240B9E5CABA146F4840
1324367	5798	\N	\N	47.00000	0101000020E6100000F8FFFF9FAA570240084BF4E2996D4840
1324368	5799	\N	\N	60.00000	0101000020E6100000F9FFFFFF395902406399FDE5AF6E4840
1324369	5798	\N	\N	43.00000	0101000020E6100000F7FFFF5FC65D0240DBBE11355E6D4840
1324370	5799	\N	\N	52.00000	0101000020E6100000FEFFFF7F9E6502404E40AAECBB6E4840
1324371	5798	\N	\N	41.00000	0101000020E6100000FAFFFF5F6960024062F9C25F436D4840
1324372	5799	\N	\N	24.00000	0101000020E61000000B0000807C6902402118697FA86E4840
1324373	5798	\N	\N	45.00000	0101000020E6100000FCFFFFBF1F68024075A44507F46C4840
1324374	5799	\N	\N	44.00000	0101000020E610000008000000CD7A02407679FBBA396F4840
1324375	5798	\N	\N	44.00000	0101000020E610000002000080A8790240443403C0466C4840
1324376	5799	\N	\N	52.00000	0101000020E610000002000000F5700240FDBF7B746E6F4840
1324377	5798	\N	\N	44.00000	0101000020E61000000B000000707D0240BD9B1B8A306C4840
1324378	5799	\N	\N	44.00000	0101000020E61000000C000080E37A0240C46E0B9AB66F4840
1324379	5798	\N	\N	42.00000	0101000020E610000007000000868502402E9DEFDA516C4840
1324380	5799	\N	\N	48.00000	0101000020E61000000A000080F5950240F405B827286F4840
1324381	5798	\N	\N	43.00000	0101000020E61000000B000000298802405AA8B910686C4840
1324382	5799	\N	\N	33.00000	0101000020E6100000FBFFFFFF6E8D0240EE0CCEE3656E4840
1324383	5798	\N	\N	64.00000	0101000020E610000004000000E3AF02408B4138FE7C6B4840
1324384	5799	\N	\N	34.00000	0101000020E6100000FDFFFFFF237E02409AC4F410706E4840
1324385	5798	\N	\N	48.00000	0101000020E6100000FAFFFFFFE0CF0240979BE507196B4840
1324387	5799	\N	\N	36.00000	0101000020E6100000F7FFFF7FF8650240E231A3B65B6E4840
1324386	5800	\N	\N	36.00000	0101000020E6100000FBFFFFFF0E0C0240DC1682306A714840
1324388	5798	\N	\N	46.00000	0101000020E6100000060000009FE40240A9BABC65846B4840
1324389	5799	\N	\N	33.00000	0101000020E610000007000080B26002408A11415C476E4840
1324390	5798	\N	\N	32.00000	0101000020E610000001000000A7EB02403C8374A0166C4840
1324391	5800	\N	\N	48.00000	0101000020E6100000030000007CCB024028E7B8C9D26D4840
1324392	5799	\N	\N	30.00000	0101000020E6100000F9FFFF7F265602400DEC661DDB6D4840
1324393	5798	\N	\N	45.00000	0101000020E610000000000000C0F00240A619E57E3D6C4840
1324394	5800	\N	\N	38.00000	0101000020E6100000040000004AEE02400D34C1B4536C4840
1324395	5799	\N	\N	34.00000	0101000020E610000005000080DD530240900D9E48C06D4840
1324397	5798	\N	\N	40.00000	0101000020E6100000FCFFFFFF35F3024012A9EF63326C4840
1324396	5800	\N	\N	31.00000	0101000020E610000000000000C01D03406B26952FD3694840
1324398	5799	\N	\N	45.00000	0101000020E6100000FBFFFF7F9B680240E2499E2BEF6C4840
1324399	5798	\N	\N	51.00000	0101000020E6100000F8FFFFFFD2280340F6D645A2926C4840
1324400	5800	\N	\N	33.00000	0101000020E6100000FFFFFFFF514F0340F87779179C684840
1324401	5799	\N	\N	44.00000	0101000020E6100000FBFFFF7F027A0240CA31B8583F6C4840
1324402	5800	\N	\N	32.00000	0101000020E6100000FDFFFFFF039D034016AE15A56F684840
1324403	5799	\N	\N	44.00000	0101000020E610000007000080597D024012A9EF63326C4840
1324404	5800	\N	\N	57.00000	0101000020E61000000B00000070B803406B26952FD3694840
1324405	5799	\N	\N	73.00000	0101000020E610000004000080968B02401542EA772C6B4840
1324406	5801	\N	\N	32.00000	0101000020E610000007000000268B02409AC4F410706E4840
1324407	5800	\N	\N	39.00000	0101000020E6100000030000005CEA0340CC8CD246426A4840
1324408	5799	\N	\N	73.00000	0101000020E610000009000000BB8C0240B0E9DD642D6B4840
1324409	5800	\N	\N	84.00000	0101000020E6100000FDFFFFFF432F0440109C90C7CB694840
1324410	5801	\N	\N	30.00000	0101000020E6100000F8FFFFFF6B6302404EC44C03586E4840
1324411	5799	\N	\N	69.00000	0101000020E610000001000080BA9402401B9460A6366B4840
1324412	5800	\N	\N	86.00000	0101000020E6100000FDFFFFFFA35604405D6441A0116B4840
1324413	5801	\N	\N	33.00000	0101000020E610000005000000915C02405D3E66C1296E4840
1324414	5799	\N	\N	55.00000	0101000020E6100000FEFFFFFFCAC70240A43015C32F6A4840
1324415	5801	\N	\N	43.00000	0101000020E610000009000000BB5F024043242B8D136E4840
1324416	5799	\N	\N	43.00000	0101000020E610000001000000AE020340EB7810605F6B4840
1324417	5801	\N	\N	42.00000	0101000020E61000000B000000F06602403B01E362CB6D4840
1324418	5801	\N	\N	41.00000	0101000020E6100000FCFFFFFFD571024071DB535B5C6D4840
1324419	5801	\N	\N	43.00000	0101000020E6100000F6FFFFFF5D620240EC7C3765AE6C4840
1324420	5801	\N	\N	44.00000	0101000020E61000000B000000E97C0240A04BF548276C4840
1324421	5801	\N	\N	73.00000	0101000020E610000000000000808B0240B5160FB1296B4840
1324422	5801	\N	\N	69.00000	0101000020E6100000F6FFFFFFFD9402408930AC18316B4840
1324423	5801	\N	\N	66.00000	0101000020E6100000F9FFFFFFF9A702401F89A22BC06A4840
1324425	5803	\N	\N	36.00000	0101000020E6100000FAFFFFFF870B0240413D64E36D714840
1324429	5803	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C02406F6BF6D2D86F4840
1324432	5803	\N	\N	64.00000	0101000020E6100000060000009F5D0240B9E5CABA146F4840
1324435	5803	\N	\N	60.00000	0101000020E6100000F9FFFFFF395902406399FDE5AF6E4840
1324438	5803	\N	\N	52.00000	0101000020E6100000FEFFFF7F9E6502404E40AAECBB6E4840
1324441	5803	\N	\N	24.00000	0101000020E61000000B0000807C6902402118697FA86E4840
1324444	5803	\N	\N	44.00000	0101000020E610000008000000CD7A02407679FBBA396F4840
1324447	5803	\N	\N	52.00000	0101000020E610000002000000F5700240FDBF7B746E6F4840
1324450	5803	\N	\N	44.00000	0101000020E61000000C000080E37A0240C46E0B9AB66F4840
1324453	5803	\N	\N	48.00000	0101000020E61000000A000080F5950240F405B827286F4840
1324456	5803	\N	\N	33.00000	0101000020E6100000FBFFFFFF6E8D0240EE0CCEE3656E4840
1324458	5803	\N	\N	34.00000	0101000020E6100000FDFFFFFF237E02409AC4F410706E4840
1324460	5803	\N	\N	36.00000	0101000020E6100000F7FFFF7FF8650240E231A3B65B6E4840
1324463	5803	\N	\N	33.00000	0101000020E610000007000080B26002408A11415C476E4840
1324466	5803	\N	\N	30.00000	0101000020E6100000F9FFFF7F265602400DEC661DDB6D4840
1324468	5803	\N	\N	34.00000	0101000020E610000005000080DD530240900D9E48C06D4840
1324472	5803	\N	\N	45.00000	0101000020E6100000FBFFFF7F9B680240E2499E2BEF6C4840
1324474	5803	\N	\N	44.00000	0101000020E6100000FBFFFF7F027A0240CA31B8583F6C4840
1324477	5803	\N	\N	44.00000	0101000020E610000007000080597D024012A9EF63326C4840
1324479	5803	\N	\N	73.00000	0101000020E610000004000080968B02401542EA772C6B4840
1324482	5803	\N	\N	73.00000	0101000020E610000009000000BB8C0240B0E9DD642D6B4840
1324484	5803	\N	\N	69.00000	0101000020E610000001000080BA9402401B9460A6366B4840
1324486	5803	\N	\N	55.00000	0101000020E6100000FEFFFFFFCAC70240A43015C32F6A4840
1324488	5803	\N	\N	43.00000	0101000020E610000001000000AE020340EB7810605F6B4840
1324490	5806	\N	\N	42.00000	0101000020E6100000020000C01E4B0240D6CB02D7A66D4840
1324491	5806	\N	\N	43.00000	0101000020E610000008000000544E0240F1322640D36D4840
1324493	5806	\N	\N	33.00000	0101000020E6100000FCFFFF3F2C540240641A81E21E6E4840
1324495	5806	\N	\N	39.00000	0101000020E61000000C000020A25802407AFB30A0F06D4840
1324497	5806	\N	\N	42.00000	0101000020E6100000FBFFFF9FAD540240431506B3CD6D4840
1324499	5806	\N	\N	34.00000	0101000020E610000008000000F4530240CA21B070C16D4840
1324502	5806	\N	\N	47.00000	0101000020E6100000F8FFFF9FAA570240084BF4E2996D4840
1324503	5806	\N	\N	43.00000	0101000020E6100000F7FFFF5FC65D0240DBBE11355E6D4840
1324505	5806	\N	\N	41.00000	0101000020E6100000FAFFFF5F6960024062F9C25F436D4840
1324507	5806	\N	\N	45.00000	0101000020E6100000FCFFFFBF1F68024075A44507F46C4840
1324509	5806	\N	\N	44.00000	0101000020E610000002000080A8790240443403C0466C4840
1324511	5806	\N	\N	44.00000	0101000020E61000000B000000707D0240BD9B1B8A306C4840
1324513	5806	\N	\N	42.00000	0101000020E610000007000000868502402E9DEFDA516C4840
1324515	5806	\N	\N	43.00000	0101000020E61000000B000000298802405AA8B910686C4840
1324517	5806	\N	\N	64.00000	0101000020E610000004000000E3AF02408B4138FE7C6B4840
1324519	5806	\N	\N	48.00000	0101000020E6100000FAFFFFFFE0CF0240979BE507196B4840
1324522	5806	\N	\N	46.00000	0101000020E6100000060000009FE40240A9BABC65846B4840
1324525	5806	\N	\N	32.00000	0101000020E610000001000000A7EB02403C8374A0166C4840
1324528	5806	\N	\N	45.00000	0101000020E610000000000000C0F00240A619E57E3D6C4840
1324531	5806	\N	\N	40.00000	0101000020E6100000FCFFFFFF35F3024012A9EF63326C4840
1324534	5806	\N	\N	51.00000	0101000020E6100000F8FFFFFFD2280340F6D645A2926C4840
1324542	5809	\N	\N	32.00000	0101000020E610000007000000268B02409AC4F410706E4840
1324545	5809	\N	\N	30.00000	0101000020E6100000F8FFFFFF6B6302404EC44C03586E4840
1324547	5809	\N	\N	33.00000	0101000020E610000005000000915C02405D3E66C1296E4840
1324548	5809	\N	\N	43.00000	0101000020E610000009000000BB5F024043242B8D136E4840
1324549	5809	\N	\N	42.00000	0101000020E61000000B000000F06602403B01E362CB6D4840
1324550	5809	\N	\N	41.00000	0101000020E6100000FCFFFFFFD571024071DB535B5C6D4840
1324551	5809	\N	\N	43.00000	0101000020E6100000F6FFFFFF5D620240EC7C3765AE6C4840
1324552	5809	\N	\N	44.00000	0101000020E61000000B000000E97C0240A04BF548276C4840
1324553	5809	\N	\N	73.00000	0101000020E610000000000000808B0240B5160FB1296B4840
1324554	5809	\N	\N	69.00000	0101000020E6100000F6FFFFFFFD9402408930AC18316B4840
1324555	5809	\N	\N	66.00000	0101000020E6100000F9FFFFFFF9A702401F89A22BC06A4840
1324424	5802	\N	\N	42.00000	0101000020E6100000020000C01E4B0240D6CB02D7A66D4840
1324426	5802	\N	\N	43.00000	0101000020E610000008000000544E0240F1322640D36D4840
1324428	5802	\N	\N	33.00000	0101000020E6100000FCFFFF3F2C540240641A81E21E6E4840
1324431	5802	\N	\N	39.00000	0101000020E61000000C000020A25802407AFB30A0F06D4840
1324434	5802	\N	\N	42.00000	0101000020E6100000FBFFFF9FAD540240431506B3CD6D4840
1324437	5802	\N	\N	34.00000	0101000020E610000008000000F4530240CA21B070C16D4840
1324440	5802	\N	\N	47.00000	0101000020E6100000F8FFFF9FAA570240084BF4E2996D4840
1324442	5802	\N	\N	43.00000	0101000020E6100000F7FFFF5FC65D0240DBBE11355E6D4840
1324445	5802	\N	\N	41.00000	0101000020E6100000FAFFFF5F6960024062F9C25F436D4840
1324448	5802	\N	\N	45.00000	0101000020E6100000FCFFFFBF1F68024075A44507F46C4840
1324451	5802	\N	\N	44.00000	0101000020E610000002000080A8790240443403C0466C4840
1324454	5802	\N	\N	44.00000	0101000020E61000000B000000707D0240BD9B1B8A306C4840
1324457	5802	\N	\N	42.00000	0101000020E610000007000000868502402E9DEFDA516C4840
1324459	5802	\N	\N	43.00000	0101000020E61000000B000000298802405AA8B910686C4840
1324461	5802	\N	\N	64.00000	0101000020E610000004000000E3AF02408B4138FE7C6B4840
1324464	5802	\N	\N	48.00000	0101000020E6100000FAFFFFFFE0CF0240979BE507196B4840
1324467	5802	\N	\N	46.00000	0101000020E6100000060000009FE40240A9BABC65846B4840
1324470	5802	\N	\N	32.00000	0101000020E610000001000000A7EB02403C8374A0166C4840
1324475	5802	\N	\N	45.00000	0101000020E610000000000000C0F00240A619E57E3D6C4840
1324478	5802	\N	\N	40.00000	0101000020E6100000FCFFFFFF35F3024012A9EF63326C4840
1324481	5802	\N	\N	51.00000	0101000020E6100000F8FFFFFFD2280340F6D645A2926C4840
1324492	5807	\N	\N	36.00000	0101000020E6100000FAFFFFFF870B0240413D64E36D714840
1324494	5807	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C02406F6BF6D2D86F4840
1324496	5807	\N	\N	64.00000	0101000020E6100000060000009F5D0240B9E5CABA146F4840
1324498	5807	\N	\N	60.00000	0101000020E6100000F9FFFFFF395902406399FDE5AF6E4840
1324500	5807	\N	\N	52.00000	0101000020E6100000FEFFFF7F9E6502404E40AAECBB6E4840
1324501	5807	\N	\N	24.00000	0101000020E61000000B0000807C6902402118697FA86E4840
1324504	5807	\N	\N	44.00000	0101000020E610000008000000CD7A02407679FBBA396F4840
1324506	5807	\N	\N	52.00000	0101000020E610000002000000F5700240FDBF7B746E6F4840
1324508	5807	\N	\N	44.00000	0101000020E61000000C000080E37A0240C46E0B9AB66F4840
1324510	5807	\N	\N	48.00000	0101000020E61000000A000080F5950240F405B827286F4840
1324512	5807	\N	\N	33.00000	0101000020E6100000FBFFFFFF6E8D0240EE0CCEE3656E4840
1324514	5807	\N	\N	34.00000	0101000020E6100000FDFFFFFF237E02409AC4F410706E4840
1324516	5807	\N	\N	36.00000	0101000020E6100000F7FFFF7FF8650240E231A3B65B6E4840
1324518	5807	\N	\N	33.00000	0101000020E610000007000080B26002408A11415C476E4840
1324521	5807	\N	\N	30.00000	0101000020E6100000F9FFFF7F265602400DEC661DDB6D4840
1324524	5807	\N	\N	34.00000	0101000020E610000005000080DD530240900D9E48C06D4840
1324527	5807	\N	\N	45.00000	0101000020E6100000FBFFFF7F9B680240E2499E2BEF6C4840
1324530	5807	\N	\N	44.00000	0101000020E6100000FBFFFF7F027A0240CA31B8583F6C4840
1324533	5807	\N	\N	44.00000	0101000020E610000007000080597D024012A9EF63326C4840
1324536	5807	\N	\N	73.00000	0101000020E610000004000080968B02401542EA772C6B4840
1324538	5807	\N	\N	73.00000	0101000020E610000009000000BB8C0240B0E9DD642D6B4840
1324539	5807	\N	\N	69.00000	0101000020E610000001000080BA9402401B9460A6366B4840
1324541	5807	\N	\N	55.00000	0101000020E6100000FEFFFFFFCAC70240A43015C32F6A4840
1324544	5807	\N	\N	43.00000	0101000020E610000001000000AE020340EB7810605F6B4840
1324427	5804	\N	\N	36.00000	0101000020E6100000FBFFFFFF0E0C0240DC1682306A714840
1324430	5804	\N	\N	48.00000	0101000020E6100000030000007CCB024028E7B8C9D26D4840
1324433	5804	\N	\N	38.00000	0101000020E6100000040000004AEE02400D34C1B4536C4840
1324436	5804	\N	\N	31.00000	0101000020E610000000000000C01D03406B26952FD3694840
1324439	5804	\N	\N	33.00000	0101000020E6100000FFFFFFFF514F0340F87779179C684840
1324443	5804	\N	\N	32.00000	0101000020E6100000FDFFFFFF039D034016AE15A56F684840
1324446	5804	\N	\N	57.00000	0101000020E61000000B00000070B803406B26952FD3694840
1324449	5804	\N	\N	39.00000	0101000020E6100000030000005CEA0340CC8CD246426A4840
1324452	5804	\N	\N	84.00000	0101000020E6100000FDFFFFFF432F0440109C90C7CB694840
1324455	5804	\N	\N	86.00000	0101000020E6100000FDFFFFFFA35604405D6441A0116B4840
1324462	5805	\N	\N	32.00000	0101000020E610000007000000268B02409AC4F410706E4840
1324465	5805	\N	\N	30.00000	0101000020E6100000F8FFFFFF6B6302404EC44C03586E4840
1324469	5805	\N	\N	33.00000	0101000020E610000005000000915C02405D3E66C1296E4840
1324471	5805	\N	\N	43.00000	0101000020E610000009000000BB5F024043242B8D136E4840
1324473	5805	\N	\N	42.00000	0101000020E61000000B000000F06602403B01E362CB6D4840
1324476	5805	\N	\N	41.00000	0101000020E6100000FCFFFFFFD571024071DB535B5C6D4840
1324480	5805	\N	\N	43.00000	0101000020E6100000F6FFFFFF5D620240EC7C3765AE6C4840
1324483	5805	\N	\N	44.00000	0101000020E61000000B000000E97C0240A04BF548276C4840
1324485	5805	\N	\N	73.00000	0101000020E610000000000000808B0240B5160FB1296B4840
1324487	5805	\N	\N	69.00000	0101000020E6100000F6FFFFFFFD9402408930AC18316B4840
1324489	5805	\N	\N	66.00000	0101000020E6100000F9FFFFFFF9A702401F89A22BC06A4840
1324520	5808	\N	\N	36.00000	0101000020E6100000FBFFFFFF0E0C0240DC1682306A714840
1324523	5808	\N	\N	48.00000	0101000020E6100000030000007CCB024028E7B8C9D26D4840
1324526	5808	\N	\N	38.00000	0101000020E6100000040000004AEE02400D34C1B4536C4840
1324529	5808	\N	\N	31.00000	0101000020E610000000000000C01D03406B26952FD3694840
1324532	5808	\N	\N	33.00000	0101000020E6100000FFFFFFFF514F0340F87779179C684840
1324535	5808	\N	\N	32.00000	0101000020E6100000FDFFFFFF039D034016AE15A56F684840
1324537	5808	\N	\N	57.00000	0101000020E61000000B00000070B803406B26952FD3694840
1324540	5808	\N	\N	39.00000	0101000020E6100000030000005CEA0340CC8CD246426A4840
1324543	5808	\N	\N	84.00000	0101000020E6100000FDFFFFFF432F0440109C90C7CB694840
1324546	5808	\N	\N	86.00000	0101000020E6100000FDFFFFFFA35604405D6441A0116B4840
1324556	5810	\N	\N	42.00000	0101000020E6100000020000C01E4B0240D6CB02D7A66D4840
1324557	5811	\N	\N	36.00000	0101000020E6100000FBFFFFFF0E0C0240DC1682306A714840
1324558	5810	\N	\N	43.00000	0101000020E610000008000000544E0240F1322640D36D4840
1324559	5811	\N	\N	48.00000	0101000020E6100000030000007CCB024028E7B8C9D26D4840
1324560	5810	\N	\N	33.00000	0101000020E6100000FCFFFF3F2C540240641A81E21E6E4840
1324561	5811	\N	\N	38.00000	0101000020E6100000040000004AEE02400D34C1B4536C4840
1324562	5810	\N	\N	39.00000	0101000020E61000000C000020A25802407AFB30A0F06D4840
1324563	5811	\N	\N	31.00000	0101000020E610000000000000C01D03406B26952FD3694840
1324564	5811	\N	\N	33.00000	0101000020E6100000FFFFFFFF514F0340F87779179C684840
1324565	5810	\N	\N	42.00000	0101000020E6100000FBFFFF9FAD540240431506B3CD6D4840
1324566	5811	\N	\N	32.00000	0101000020E6100000FDFFFFFF039D034016AE15A56F684840
1324567	5810	\N	\N	34.00000	0101000020E610000008000000F4530240CA21B070C16D4840
1324568	5811	\N	\N	57.00000	0101000020E61000000B00000070B803406B26952FD3694840
1324569	5810	\N	\N	47.00000	0101000020E6100000F8FFFF9FAA570240084BF4E2996D4840
1324570	5811	\N	\N	39.00000	0101000020E6100000030000005CEA0340CC8CD246426A4840
1324571	5810	\N	\N	43.00000	0101000020E6100000F7FFFF5FC65D0240DBBE11355E6D4840
1324572	5811	\N	\N	84.00000	0101000020E6100000FDFFFFFF432F0440109C90C7CB694840
1324573	5810	\N	\N	41.00000	0101000020E6100000FAFFFF5F6960024062F9C25F436D4840
1324574	5811	\N	\N	86.00000	0101000020E6100000FDFFFFFFA35604405D6441A0116B4840
1324575	5810	\N	\N	45.00000	0101000020E6100000FCFFFFBF1F68024075A44507F46C4840
1324576	5810	\N	\N	44.00000	0101000020E610000002000080A8790240443403C0466C4840
1324577	5810	\N	\N	44.00000	0101000020E61000000B000000707D0240BD9B1B8A306C4840
1324578	5812	\N	\N	36.00000	0101000020E6100000FAFFFFFF870B0240413D64E36D714840
1324579	5810	\N	\N	42.00000	0101000020E610000007000000868502402E9DEFDA516C4840
1324580	5812	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C02406F6BF6D2D86F4840
1324581	5810	\N	\N	43.00000	0101000020E61000000B000000298802405AA8B910686C4840
1324582	5812	\N	\N	64.00000	0101000020E6100000060000009F5D0240B9E5CABA146F4840
1324583	5810	\N	\N	64.00000	0101000020E610000004000000E3AF02408B4138FE7C6B4840
1324584	5812	\N	\N	60.00000	0101000020E6100000F9FFFFFF395902406399FDE5AF6E4840
1324585	5813	\N	\N	32.00000	0101000020E610000007000000268B02409AC4F410706E4840
1324586	5810	\N	\N	48.00000	0101000020E6100000FAFFFFFFE0CF0240979BE507196B4840
1324587	5812	\N	\N	52.00000	0101000020E6100000FEFFFF7F9E6502404E40AAECBB6E4840
1324588	5813	\N	\N	30.00000	0101000020E6100000F8FFFFFF6B6302404EC44C03586E4840
1324589	5810	\N	\N	46.00000	0101000020E6100000060000009FE40240A9BABC65846B4840
1324590	5812	\N	\N	24.00000	0101000020E61000000B0000807C6902402118697FA86E4840
1324591	5810	\N	\N	32.00000	0101000020E610000001000000A7EB02403C8374A0166C4840
1324592	5813	\N	\N	33.00000	0101000020E610000005000000915C02405D3E66C1296E4840
1324593	5812	\N	\N	44.00000	0101000020E610000008000000CD7A02407679FBBA396F4840
1324594	5810	\N	\N	45.00000	0101000020E610000000000000C0F00240A619E57E3D6C4840
1324595	5813	\N	\N	43.00000	0101000020E610000009000000BB5F024043242B8D136E4840
1324596	5812	\N	\N	52.00000	0101000020E610000002000000F5700240FDBF7B746E6F4840
1324597	5810	\N	\N	40.00000	0101000020E6100000FCFFFFFF35F3024012A9EF63326C4840
1324598	5813	\N	\N	42.00000	0101000020E61000000B000000F06602403B01E362CB6D4840
1324599	5812	\N	\N	44.00000	0101000020E61000000C000080E37A0240C46E0B9AB66F4840
1324600	5810	\N	\N	51.00000	0101000020E6100000F8FFFFFFD2280340F6D645A2926C4840
1324601	5813	\N	\N	41.00000	0101000020E6100000FCFFFFFFD571024071DB535B5C6D4840
1324602	5812	\N	\N	48.00000	0101000020E61000000A000080F5950240F405B827286F4840
1324603	5813	\N	\N	43.00000	0101000020E6100000F6FFFFFF5D620240EC7C3765AE6C4840
1324604	5812	\N	\N	33.00000	0101000020E6100000FBFFFFFF6E8D0240EE0CCEE3656E4840
1324605	5813	\N	\N	44.00000	0101000020E61000000B000000E97C0240A04BF548276C4840
1324606	5812	\N	\N	34.00000	0101000020E6100000FDFFFFFF237E02409AC4F410706E4840
1324607	5813	\N	\N	73.00000	0101000020E610000000000000808B0240B5160FB1296B4840
1324608	5812	\N	\N	36.00000	0101000020E6100000F7FFFF7FF8650240E231A3B65B6E4840
1324609	5813	\N	\N	69.00000	0101000020E6100000F6FFFFFFFD9402408930AC18316B4840
1324610	5812	\N	\N	33.00000	0101000020E610000007000080B26002408A11415C476E4840
1324611	5813	\N	\N	66.00000	0101000020E6100000F9FFFFFFF9A702401F89A22BC06A4840
1324612	5812	\N	\N	30.00000	0101000020E6100000F9FFFF7F265602400DEC661DDB6D4840
1324613	5812	\N	\N	34.00000	0101000020E610000005000080DD530240900D9E48C06D4840
1324614	5812	\N	\N	45.00000	0101000020E6100000FBFFFF7F9B680240E2499E2BEF6C4840
1324615	5812	\N	\N	44.00000	0101000020E6100000FBFFFF7F027A0240CA31B8583F6C4840
1324616	5812	\N	\N	44.00000	0101000020E610000007000080597D024012A9EF63326C4840
1324617	5812	\N	\N	73.00000	0101000020E610000004000080968B02401542EA772C6B4840
1324618	5812	\N	\N	73.00000	0101000020E610000009000000BB8C0240B0E9DD642D6B4840
1324619	5812	\N	\N	69.00000	0101000020E610000001000080BA9402401B9460A6366B4840
1324620	5812	\N	\N	55.00000	0101000020E6100000FEFFFFFFCAC70240A43015C32F6A4840
1324621	5812	\N	\N	43.00000	0101000020E610000001000000AE020340EB7810605F6B4840
1324622	5814	\N	\N	42.00000	0101000020E6100000020000C01E4B0240D6CB02D7A66D4840
1324623	5815	\N	\N	36.00000	0101000020E6100000FBFFFFFF0E0C0240DC1682306A714840
1324624	5814	\N	\N	43.00000	0101000020E610000008000000544E0240F1322640D36D4840
1324625	5815	\N	\N	48.00000	0101000020E6100000030000007CCB024028E7B8C9D26D4840
1324626	5814	\N	\N	33.00000	0101000020E6100000FCFFFF3F2C540240641A81E21E6E4840
1324627	5815	\N	\N	38.00000	0101000020E6100000040000004AEE02400D34C1B4536C4840
1324628	5814	\N	\N	39.00000	0101000020E61000000C000020A25802407AFB30A0F06D4840
1324629	5815	\N	\N	31.00000	0101000020E610000000000000C01D03406B26952FD3694840
1324630	5814	\N	\N	42.00000	0101000020E6100000FBFFFF9FAD540240431506B3CD6D4840
1324631	5815	\N	\N	33.00000	0101000020E6100000FFFFFFFF514F0340F87779179C684840
1324632	5814	\N	\N	34.00000	0101000020E610000008000000F4530240CA21B070C16D4840
1324634	5814	\N	\N	47.00000	0101000020E6100000F8FFFF9FAA570240084BF4E2996D4840
1324636	5814	\N	\N	43.00000	0101000020E6100000F7FFFF5FC65D0240DBBE11355E6D4840
1324638	5814	\N	\N	41.00000	0101000020E6100000FAFFFF5F6960024062F9C25F436D4840
1324640	5814	\N	\N	45.00000	0101000020E6100000FCFFFFBF1F68024075A44507F46C4840
1324642	5814	\N	\N	44.00000	0101000020E610000002000080A8790240443403C0466C4840
1324643	5814	\N	\N	44.00000	0101000020E61000000B000000707D0240BD9B1B8A306C4840
1324644	5814	\N	\N	42.00000	0101000020E610000007000000868502402E9DEFDA516C4840
1324646	5814	\N	\N	43.00000	0101000020E61000000B000000298802405AA8B910686C4840
1324649	5814	\N	\N	64.00000	0101000020E610000004000000E3AF02408B4138FE7C6B4840
1324652	5814	\N	\N	48.00000	0101000020E6100000FAFFFFFFE0CF0240979BE507196B4840
1324655	5814	\N	\N	46.00000	0101000020E6100000060000009FE40240A9BABC65846B4840
1324658	5814	\N	\N	32.00000	0101000020E610000001000000A7EB02403C8374A0166C4840
1324661	5814	\N	\N	45.00000	0101000020E610000000000000C0F00240A619E57E3D6C4840
1324664	5814	\N	\N	40.00000	0101000020E6100000FCFFFFFF35F3024012A9EF63326C4840
1324667	5814	\N	\N	51.00000	0101000020E6100000F8FFFFFFD2280340F6D645A2926C4840
1324690	5819	\N	\N	36.00000	0101000020E6100000FAFFFFFF870B0240413D64E36D714840
1324693	5819	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C02406F6BF6D2D86F4840
1324696	5819	\N	\N	64.00000	0101000020E6100000060000009F5D0240B9E5CABA146F4840
1324699	5819	\N	\N	60.00000	0101000020E6100000F9FFFFFF395902406399FDE5AF6E4840
1324702	5819	\N	\N	52.00000	0101000020E6100000FEFFFF7F9E6502404E40AAECBB6E4840
1324705	5819	\N	\N	24.00000	0101000020E61000000B0000807C6902402118697FA86E4840
1324708	5819	\N	\N	44.00000	0101000020E610000008000000CD7A02407679FBBA396F4840
1324711	5819	\N	\N	52.00000	0101000020E610000002000000F5700240FDBF7B746E6F4840
1324714	5819	\N	\N	44.00000	0101000020E61000000C000080E37A0240C46E0B9AB66F4840
1324717	5819	\N	\N	48.00000	0101000020E61000000A000080F5950240F405B827286F4840
1324720	5819	\N	\N	33.00000	0101000020E6100000FBFFFFFF6E8D0240EE0CCEE3656E4840
1324721	5819	\N	\N	34.00000	0101000020E6100000FDFFFFFF237E02409AC4F410706E4840
1324723	5819	\N	\N	36.00000	0101000020E6100000F7FFFF7FF8650240E231A3B65B6E4840
1324726	5819	\N	\N	33.00000	0101000020E610000007000080B26002408A11415C476E4840
1324729	5819	\N	\N	30.00000	0101000020E6100000F9FFFF7F265602400DEC661DDB6D4840
1324733	5819	\N	\N	34.00000	0101000020E610000005000080DD530240900D9E48C06D4840
1324736	5819	\N	\N	45.00000	0101000020E6100000FBFFFF7F9B680240E2499E2BEF6C4840
1324739	5819	\N	\N	44.00000	0101000020E6100000FBFFFF7F027A0240CA31B8583F6C4840
1324742	5819	\N	\N	44.00000	0101000020E610000007000080597D024012A9EF63326C4840
1324745	5819	\N	\N	73.00000	0101000020E610000004000080968B02401542EA772C6B4840
1324747	5819	\N	\N	73.00000	0101000020E610000009000000BB8C0240B0E9DD642D6B4840
1324749	5819	\N	\N	69.00000	0101000020E610000001000080BA9402401B9460A6366B4840
1324751	5819	\N	\N	55.00000	0101000020E6100000FEFFFFFFCAC70240A43015C32F6A4840
1324753	5819	\N	\N	43.00000	0101000020E610000001000000AE020340EB7810605F6B4840
1324755	5823	\N	\N	36.00000	0101000020E6100000FBFFFFFF0E0C0240DC1682306A714840
1324758	5823	\N	\N	48.00000	0101000020E6100000030000007CCB024028E7B8C9D26D4840
1324761	5823	\N	\N	38.00000	0101000020E6100000040000004AEE02400D34C1B4536C4840
1324764	5823	\N	\N	31.00000	0101000020E610000000000000C01D03406B26952FD3694840
1324767	5823	\N	\N	33.00000	0101000020E6100000FFFFFFFF514F0340F87779179C684840
1324770	5823	\N	\N	32.00000	0101000020E6100000FDFFFFFF039D034016AE15A56F684840
1324773	5823	\N	\N	57.00000	0101000020E61000000B00000070B803406B26952FD3694840
1324776	5823	\N	\N	39.00000	0101000020E6100000030000005CEA0340CC8CD246426A4840
1324779	5823	\N	\N	84.00000	0101000020E6100000FDFFFFFF432F0440109C90C7CB694840
1324782	5823	\N	\N	86.00000	0101000020E6100000FDFFFFFFA35604405D6441A0116B4840
1324791	5825	\N	\N	32.00000	0101000020E610000007000000268B02409AC4F410706E4840
1324793	5825	\N	\N	30.00000	0101000020E6100000F8FFFFFF6B6302404EC44C03586E4840
1324796	5825	\N	\N	33.00000	0101000020E610000005000000915C02405D3E66C1296E4840
1324800	5825	\N	\N	43.00000	0101000020E610000009000000BB5F024043242B8D136E4840
1324804	5825	\N	\N	42.00000	0101000020E61000000B000000F06602403B01E362CB6D4840
1324807	5825	\N	\N	41.00000	0101000020E6100000FCFFFFFFD571024071DB535B5C6D4840
1324810	5825	\N	\N	43.00000	0101000020E6100000F6FFFFFF5D620240EC7C3765AE6C4840
1324813	5825	\N	\N	44.00000	0101000020E61000000B000000E97C0240A04BF548276C4840
1324815	5825	\N	\N	73.00000	0101000020E610000000000000808B0240B5160FB1296B4840
1324817	5825	\N	\N	69.00000	0101000020E6100000F6FFFFFFFD9402408930AC18316B4840
1324819	5825	\N	\N	66.00000	0101000020E6100000F9FFFFFFF9A702401F89A22BC06A4840
1324820	5826	\N	\N	42.00000	0101000020E6100000020000C01E4B0240D6CB02D7A66D4840
1324821	5826	\N	\N	43.00000	0101000020E610000008000000544E0240F1322640D36D4840
1324823	5826	\N	\N	33.00000	0101000020E6100000FCFFFF3F2C540240641A81E21E6E4840
1324825	5826	\N	\N	39.00000	0101000020E61000000C000020A25802407AFB30A0F06D4840
1324827	5826	\N	\N	42.00000	0101000020E6100000FBFFFF9FAD540240431506B3CD6D4840
1324829	5826	\N	\N	34.00000	0101000020E610000008000000F4530240CA21B070C16D4840
1324831	5826	\N	\N	47.00000	0101000020E6100000F8FFFF9FAA570240084BF4E2996D4840
1324833	5826	\N	\N	43.00000	0101000020E6100000F7FFFF5FC65D0240DBBE11355E6D4840
1324835	5826	\N	\N	41.00000	0101000020E6100000FAFFFF5F6960024062F9C25F436D4840
1324837	5826	\N	\N	45.00000	0101000020E6100000FCFFFFBF1F68024075A44507F46C4840
1324839	5826	\N	\N	44.00000	0101000020E610000002000080A8790240443403C0466C4840
1324841	5826	\N	\N	44.00000	0101000020E61000000B000000707D0240BD9B1B8A306C4840
1324843	5826	\N	\N	42.00000	0101000020E610000007000000868502402E9DEFDA516C4840
1324845	5826	\N	\N	43.00000	0101000020E61000000B000000298802405AA8B910686C4840
1324848	5826	\N	\N	64.00000	0101000020E610000004000000E3AF02408B4138FE7C6B4840
1324851	5826	\N	\N	48.00000	0101000020E6100000FAFFFFFFE0CF0240979BE507196B4840
1324856	5826	\N	\N	46.00000	0101000020E6100000060000009FE40240A9BABC65846B4840
1324859	5826	\N	\N	32.00000	0101000020E610000001000000A7EB02403C8374A0166C4840
1324862	5826	\N	\N	45.00000	0101000020E610000000000000C0F00240A619E57E3D6C4840
1324865	5826	\N	\N	40.00000	0101000020E6100000FCFFFFFF35F3024012A9EF63326C4840
1324868	5826	\N	\N	51.00000	0101000020E6100000F8FFFFFFD2280340F6D645A2926C4840
1324874	5829	\N	\N	32.00000	0101000020E610000007000000268B02409AC4F410706E4840
1324876	5829	\N	\N	30.00000	0101000020E6100000F8FFFFFF6B6302404EC44C03586E4840
1324877	5829	\N	\N	33.00000	0101000020E610000005000000915C02405D3E66C1296E4840
1324878	5829	\N	\N	43.00000	0101000020E610000009000000BB5F024043242B8D136E4840
1324879	5829	\N	\N	42.00000	0101000020E61000000B000000F06602403B01E362CB6D4840
1324880	5829	\N	\N	41.00000	0101000020E6100000FCFFFFFFD571024071DB535B5C6D4840
1324881	5829	\N	\N	43.00000	0101000020E6100000F6FFFFFF5D620240EC7C3765AE6C4840
1324882	5829	\N	\N	44.00000	0101000020E61000000B000000E97C0240A04BF548276C4840
1324883	5829	\N	\N	73.00000	0101000020E610000000000000808B0240B5160FB1296B4840
1324884	5829	\N	\N	69.00000	0101000020E6100000F6FFFFFFFD9402408930AC18316B4840
1324885	5829	\N	\N	66.00000	0101000020E6100000F9FFFFFFF9A702401F89A22BC06A4840
1324887	5831	\N	\N	36.00000	0101000020E6100000FAFFFFFF870B0240413D64E36D714840
1324890	5831	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C02406F6BF6D2D86F4840
1324893	5831	\N	\N	64.00000	0101000020E6100000060000009F5D0240B9E5CABA146F4840
1324896	5831	\N	\N	60.00000	0101000020E6100000F9FFFFFF395902406399FDE5AF6E4840
1324899	5831	\N	\N	52.00000	0101000020E6100000FEFFFF7F9E6502404E40AAECBB6E4840
1324902	5831	\N	\N	24.00000	0101000020E61000000B0000807C6902402118697FA86E4840
1324905	5831	\N	\N	44.00000	0101000020E610000008000000CD7A02407679FBBA396F4840
1324908	5831	\N	\N	52.00000	0101000020E610000002000000F5700240FDBF7B746E6F4840
1324911	5831	\N	\N	44.00000	0101000020E61000000C000080E37A0240C46E0B9AB66F4840
1324914	5831	\N	\N	48.00000	0101000020E61000000A000080F5950240F405B827286F4840
1324917	5831	\N	\N	33.00000	0101000020E6100000FBFFFFFF6E8D0240EE0CCEE3656E4840
1324919	5831	\N	\N	34.00000	0101000020E6100000FDFFFFFF237E02409AC4F410706E4840
1324921	5831	\N	\N	36.00000	0101000020E6100000F7FFFF7FF8650240E231A3B65B6E4840
1324924	5831	\N	\N	33.00000	0101000020E610000007000080B26002408A11415C476E4840
1324633	5815	\N	\N	32.00000	0101000020E6100000FDFFFFFF039D034016AE15A56F684840
1324635	5815	\N	\N	57.00000	0101000020E61000000B00000070B803406B26952FD3694840
1324637	5815	\N	\N	39.00000	0101000020E6100000030000005CEA0340CC8CD246426A4840
1324639	5815	\N	\N	84.00000	0101000020E6100000FDFFFFFF432F0440109C90C7CB694840
1324641	5815	\N	\N	86.00000	0101000020E6100000FDFFFFFFA35604405D6441A0116B4840
1324647	5817	\N	\N	32.00000	0101000020E610000007000000268B02409AC4F410706E4840
1324650	5817	\N	\N	30.00000	0101000020E6100000F8FFFFFF6B6302404EC44C03586E4840
1324653	5817	\N	\N	33.00000	0101000020E610000005000000915C02405D3E66C1296E4840
1324656	5817	\N	\N	43.00000	0101000020E610000009000000BB5F024043242B8D136E4840
1324659	5817	\N	\N	42.00000	0101000020E61000000B000000F06602403B01E362CB6D4840
1324662	5817	\N	\N	41.00000	0101000020E6100000FCFFFFFFD571024071DB535B5C6D4840
1324665	5817	\N	\N	43.00000	0101000020E6100000F6FFFFFF5D620240EC7C3765AE6C4840
1324668	5817	\N	\N	44.00000	0101000020E61000000B000000E97C0240A04BF548276C4840
1324670	5817	\N	\N	73.00000	0101000020E610000000000000808B0240B5160FB1296B4840
1324672	5817	\N	\N	69.00000	0101000020E6100000F6FFFFFFFD9402408930AC18316B4840
1324674	5817	\N	\N	66.00000	0101000020E6100000F9FFFFFFF9A702401F89A22BC06A4840
1324691	5820	\N	\N	36.00000	0101000020E6100000FBFFFFFF0E0C0240DC1682306A714840
1324694	5820	\N	\N	48.00000	0101000020E6100000030000007CCB024028E7B8C9D26D4840
1324697	5820	\N	\N	38.00000	0101000020E6100000040000004AEE02400D34C1B4536C4840
1324700	5820	\N	\N	31.00000	0101000020E610000000000000C01D03406B26952FD3694840
1324703	5820	\N	\N	33.00000	0101000020E6100000FFFFFFFF514F0340F87779179C684840
1324706	5820	\N	\N	32.00000	0101000020E6100000FDFFFFFF039D034016AE15A56F684840
1324709	5820	\N	\N	57.00000	0101000020E61000000B00000070B803406B26952FD3694840
1324712	5820	\N	\N	39.00000	0101000020E6100000030000005CEA0340CC8CD246426A4840
1324715	5820	\N	\N	84.00000	0101000020E6100000FDFFFFFF432F0440109C90C7CB694840
1324718	5820	\N	\N	86.00000	0101000020E6100000FDFFFFFFA35604405D6441A0116B4840
1324725	5821	\N	\N	32.00000	0101000020E610000007000000268B02409AC4F410706E4840
1324728	5821	\N	\N	30.00000	0101000020E6100000F8FFFFFF6B6302404EC44C03586E4840
1324731	5821	\N	\N	33.00000	0101000020E610000005000000915C02405D3E66C1296E4840
1324734	5821	\N	\N	43.00000	0101000020E610000009000000BB5F024043242B8D136E4840
1324737	5821	\N	\N	42.00000	0101000020E61000000B000000F06602403B01E362CB6D4840
1324740	5821	\N	\N	41.00000	0101000020E6100000FCFFFFFFD571024071DB535B5C6D4840
1324743	5821	\N	\N	43.00000	0101000020E6100000F6FFFFFF5D620240EC7C3765AE6C4840
1324746	5821	\N	\N	44.00000	0101000020E61000000B000000E97C0240A04BF548276C4840
1324748	5821	\N	\N	73.00000	0101000020E610000000000000808B0240B5160FB1296B4840
1324750	5821	\N	\N	69.00000	0101000020E6100000F6FFFFFFFD9402408930AC18316B4840
1324752	5821	\N	\N	66.00000	0101000020E6100000F9FFFFFFF9A702401F89A22BC06A4840
1324757	5824	\N	\N	36.00000	0101000020E6100000FAFFFFFF870B0240413D64E36D714840
1324759	5824	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C02406F6BF6D2D86F4840
1324762	5824	\N	\N	64.00000	0101000020E6100000060000009F5D0240B9E5CABA146F4840
1324765	5824	\N	\N	60.00000	0101000020E6100000F9FFFFFF395902406399FDE5AF6E4840
1324768	5824	\N	\N	52.00000	0101000020E6100000FEFFFF7F9E6502404E40AAECBB6E4840
1324771	5824	\N	\N	24.00000	0101000020E61000000B0000807C6902402118697FA86E4840
1324774	5824	\N	\N	44.00000	0101000020E610000008000000CD7A02407679FBBA396F4840
1324777	5824	\N	\N	52.00000	0101000020E610000002000000F5700240FDBF7B746E6F4840
1324780	5824	\N	\N	44.00000	0101000020E61000000C000080E37A0240C46E0B9AB66F4840
1324783	5824	\N	\N	48.00000	0101000020E61000000A000080F5950240F405B827286F4840
1324785	5824	\N	\N	33.00000	0101000020E6100000FBFFFFFF6E8D0240EE0CCEE3656E4840
1324787	5824	\N	\N	34.00000	0101000020E6100000FDFFFFFF237E02409AC4F410706E4840
1324789	5824	\N	\N	36.00000	0101000020E6100000F7FFFF7FF8650240E231A3B65B6E4840
1324792	5824	\N	\N	33.00000	0101000020E610000007000080B26002408A11415C476E4840
1324795	5824	\N	\N	30.00000	0101000020E6100000F9FFFF7F265602400DEC661DDB6D4840
1324798	5824	\N	\N	34.00000	0101000020E610000005000080DD530240900D9E48C06D4840
1324801	5824	\N	\N	45.00000	0101000020E6100000FBFFFF7F9B680240E2499E2BEF6C4840
1324803	5824	\N	\N	44.00000	0101000020E6100000FBFFFF7F027A0240CA31B8583F6C4840
1324806	5824	\N	\N	44.00000	0101000020E610000007000080597D024012A9EF63326C4840
1324809	5824	\N	\N	73.00000	0101000020E610000004000080968B02401542EA772C6B4840
1324812	5824	\N	\N	73.00000	0101000020E610000009000000BB8C0240B0E9DD642D6B4840
1324814	5824	\N	\N	69.00000	0101000020E610000001000080BA9402401B9460A6366B4840
1324816	5824	\N	\N	55.00000	0101000020E6100000FEFFFFFFCAC70240A43015C32F6A4840
1324818	5824	\N	\N	43.00000	0101000020E610000001000000AE020340EB7810605F6B4840
1324822	5827	\N	\N	36.00000	0101000020E6100000FAFFFFFF870B0240413D64E36D714840
1324824	5827	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C02406F6BF6D2D86F4840
1324826	5827	\N	\N	64.00000	0101000020E6100000060000009F5D0240B9E5CABA146F4840
1324828	5827	\N	\N	60.00000	0101000020E6100000F9FFFFFF395902406399FDE5AF6E4840
1324830	5827	\N	\N	52.00000	0101000020E6100000FEFFFF7F9E6502404E40AAECBB6E4840
1324832	5827	\N	\N	24.00000	0101000020E61000000B0000807C6902402118697FA86E4840
1324834	5827	\N	\N	44.00000	0101000020E610000008000000CD7A02407679FBBA396F4840
1324836	5827	\N	\N	52.00000	0101000020E610000002000000F5700240FDBF7B746E6F4840
1324838	5827	\N	\N	44.00000	0101000020E61000000C000080E37A0240C46E0B9AB66F4840
1324840	5827	\N	\N	48.00000	0101000020E61000000A000080F5950240F405B827286F4840
1324842	5827	\N	\N	33.00000	0101000020E6100000FBFFFFFF6E8D0240EE0CCEE3656E4840
1324844	5827	\N	\N	34.00000	0101000020E6100000FDFFFFFF237E02409AC4F410706E4840
1324846	5827	\N	\N	36.00000	0101000020E6100000F7FFFF7FF8650240E231A3B65B6E4840
1324849	5827	\N	\N	33.00000	0101000020E610000007000080B26002408A11415C476E4840
1324853	5827	\N	\N	30.00000	0101000020E6100000F9FFFF7F265602400DEC661DDB6D4840
1324854	5827	\N	\N	34.00000	0101000020E610000005000080DD530240900D9E48C06D4840
1324857	5827	\N	\N	45.00000	0101000020E6100000FBFFFF7F9B680240E2499E2BEF6C4840
1324860	5827	\N	\N	44.00000	0101000020E6100000FBFFFF7F027A0240CA31B8583F6C4840
1324863	5827	\N	\N	44.00000	0101000020E610000007000080597D024012A9EF63326C4840
1324866	5827	\N	\N	73.00000	0101000020E610000004000080968B02401542EA772C6B4840
1324869	5827	\N	\N	73.00000	0101000020E610000009000000BB8C0240B0E9DD642D6B4840
1324871	5827	\N	\N	69.00000	0101000020E610000001000080BA9402401B9460A6366B4840
1324873	5827	\N	\N	55.00000	0101000020E6100000FEFFFFFFCAC70240A43015C32F6A4840
1324875	5827	\N	\N	43.00000	0101000020E610000001000000AE020340EB7810605F6B4840
1324889	5832	\N	\N	36.00000	0101000020E6100000FBFFFFFF0E0C0240DC1682306A714840
1324891	5832	\N	\N	48.00000	0101000020E6100000030000007CCB024028E7B8C9D26D4840
1324895	5832	\N	\N	38.00000	0101000020E6100000040000004AEE02400D34C1B4536C4840
1324898	5832	\N	\N	31.00000	0101000020E610000000000000C01D03406B26952FD3694840
1324901	5832	\N	\N	33.00000	0101000020E6100000FFFFFFFF514F0340F87779179C684840
1324904	5832	\N	\N	32.00000	0101000020E6100000FDFFFFFF039D034016AE15A56F684840
1324907	5832	\N	\N	57.00000	0101000020E61000000B00000070B803406B26952FD3694840
1324910	5832	\N	\N	39.00000	0101000020E6100000030000005CEA0340CC8CD246426A4840
1324913	5832	\N	\N	84.00000	0101000020E6100000FDFFFFFF432F0440109C90C7CB694840
1324916	5832	\N	\N	86.00000	0101000020E6100000FDFFFFFFA35604405D6441A0116B4840
1324923	5833	\N	\N	32.00000	0101000020E610000007000000268B02409AC4F410706E4840
1324926	5833	\N	\N	30.00000	0101000020E6100000F8FFFFFF6B6302404EC44C03586E4840
1324928	5833	\N	\N	33.00000	0101000020E610000005000000915C02405D3E66C1296E4840
1324931	5833	\N	\N	43.00000	0101000020E610000009000000BB5F024043242B8D136E4840
1324934	5833	\N	\N	42.00000	0101000020E61000000B000000F06602403B01E362CB6D4840
1324937	5833	\N	\N	41.00000	0101000020E6100000FCFFFFFFD571024071DB535B5C6D4840
1324940	5833	\N	\N	43.00000	0101000020E6100000F6FFFFFF5D620240EC7C3765AE6C4840
1324943	5833	\N	\N	44.00000	0101000020E61000000B000000E97C0240A04BF548276C4840
1324946	5833	\N	\N	73.00000	0101000020E610000000000000808B0240B5160FB1296B4840
1324948	5833	\N	\N	69.00000	0101000020E6100000F6FFFFFFFD9402408930AC18316B4840
1324950	5833	\N	\N	66.00000	0101000020E6100000F9FFFFFFF9A702401F89A22BC06A4840
1324645	5816	\N	\N	36.00000	0101000020E6100000FAFFFFFF870B0240413D64E36D714840
1324648	5816	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C02406F6BF6D2D86F4840
1324651	5816	\N	\N	64.00000	0101000020E6100000060000009F5D0240B9E5CABA146F4840
1324654	5816	\N	\N	60.00000	0101000020E6100000F9FFFFFF395902406399FDE5AF6E4840
1324657	5816	\N	\N	52.00000	0101000020E6100000FEFFFF7F9E6502404E40AAECBB6E4840
1324660	5816	\N	\N	24.00000	0101000020E61000000B0000807C6902402118697FA86E4840
1324663	5816	\N	\N	44.00000	0101000020E610000008000000CD7A02407679FBBA396F4840
1324666	5816	\N	\N	52.00000	0101000020E610000002000000F5700240FDBF7B746E6F4840
1324669	5816	\N	\N	44.00000	0101000020E61000000C000080E37A0240C46E0B9AB66F4840
1324671	5816	\N	\N	48.00000	0101000020E61000000A000080F5950240F405B827286F4840
1324673	5816	\N	\N	33.00000	0101000020E6100000FBFFFFFF6E8D0240EE0CCEE3656E4840
1324675	5816	\N	\N	34.00000	0101000020E6100000FDFFFFFF237E02409AC4F410706E4840
1324676	5816	\N	\N	36.00000	0101000020E6100000F7FFFF7FF8650240E231A3B65B6E4840
1324677	5816	\N	\N	33.00000	0101000020E610000007000080B26002408A11415C476E4840
1324678	5816	\N	\N	30.00000	0101000020E6100000F9FFFF7F265602400DEC661DDB6D4840
1324679	5816	\N	\N	34.00000	0101000020E610000005000080DD530240900D9E48C06D4840
1324680	5816	\N	\N	45.00000	0101000020E6100000FBFFFF7F9B680240E2499E2BEF6C4840
1324681	5816	\N	\N	44.00000	0101000020E6100000FBFFFF7F027A0240CA31B8583F6C4840
1324682	5816	\N	\N	44.00000	0101000020E610000007000080597D024012A9EF63326C4840
1324683	5816	\N	\N	73.00000	0101000020E610000004000080968B02401542EA772C6B4840
1324684	5816	\N	\N	73.00000	0101000020E610000009000000BB8C0240B0E9DD642D6B4840
1324685	5816	\N	\N	69.00000	0101000020E610000001000080BA9402401B9460A6366B4840
1324686	5816	\N	\N	55.00000	0101000020E6100000FEFFFFFFCAC70240A43015C32F6A4840
1324687	5816	\N	\N	43.00000	0101000020E610000001000000AE020340EB7810605F6B4840
1324688	5818	\N	\N	42.00000	0101000020E6100000020000C01E4B0240D6CB02D7A66D4840
1324689	5818	\N	\N	43.00000	0101000020E610000008000000544E0240F1322640D36D4840
1324692	5818	\N	\N	33.00000	0101000020E6100000FCFFFF3F2C540240641A81E21E6E4840
1324695	5818	\N	\N	39.00000	0101000020E61000000C000020A25802407AFB30A0F06D4840
1324698	5818	\N	\N	42.00000	0101000020E6100000FBFFFF9FAD540240431506B3CD6D4840
1324701	5818	\N	\N	34.00000	0101000020E610000008000000F4530240CA21B070C16D4840
1324704	5818	\N	\N	47.00000	0101000020E6100000F8FFFF9FAA570240084BF4E2996D4840
1324707	5818	\N	\N	43.00000	0101000020E6100000F7FFFF5FC65D0240DBBE11355E6D4840
1324710	5818	\N	\N	41.00000	0101000020E6100000FAFFFF5F6960024062F9C25F436D4840
1324713	5818	\N	\N	45.00000	0101000020E6100000FCFFFFBF1F68024075A44507F46C4840
1324716	5818	\N	\N	44.00000	0101000020E610000002000080A8790240443403C0466C4840
1324719	5818	\N	\N	44.00000	0101000020E61000000B000000707D0240BD9B1B8A306C4840
1324722	5818	\N	\N	42.00000	0101000020E610000007000000868502402E9DEFDA516C4840
1324724	5818	\N	\N	43.00000	0101000020E61000000B000000298802405AA8B910686C4840
1324727	5818	\N	\N	64.00000	0101000020E610000004000000E3AF02408B4138FE7C6B4840
1324730	5818	\N	\N	48.00000	0101000020E6100000FAFFFFFFE0CF0240979BE507196B4840
1324732	5818	\N	\N	46.00000	0101000020E6100000060000009FE40240A9BABC65846B4840
1324735	5818	\N	\N	32.00000	0101000020E610000001000000A7EB02403C8374A0166C4840
1324738	5818	\N	\N	45.00000	0101000020E610000000000000C0F00240A619E57E3D6C4840
1324741	5818	\N	\N	40.00000	0101000020E6100000FCFFFFFF35F3024012A9EF63326C4840
1324744	5818	\N	\N	51.00000	0101000020E6100000F8FFFFFFD2280340F6D645A2926C4840
1324754	5822	\N	\N	42.00000	0101000020E6100000020000C01E4B0240D6CB02D7A66D4840
1324756	5822	\N	\N	43.00000	0101000020E610000008000000544E0240F1322640D36D4840
1324760	5822	\N	\N	33.00000	0101000020E6100000FCFFFF3F2C540240641A81E21E6E4840
1324763	5822	\N	\N	39.00000	0101000020E61000000C000020A25802407AFB30A0F06D4840
1324766	5822	\N	\N	42.00000	0101000020E6100000FBFFFF9FAD540240431506B3CD6D4840
1324769	5822	\N	\N	34.00000	0101000020E610000008000000F4530240CA21B070C16D4840
1324772	5822	\N	\N	47.00000	0101000020E6100000F8FFFF9FAA570240084BF4E2996D4840
1324775	5822	\N	\N	43.00000	0101000020E6100000F7FFFF5FC65D0240DBBE11355E6D4840
1324778	5822	\N	\N	41.00000	0101000020E6100000FAFFFF5F6960024062F9C25F436D4840
1324781	5822	\N	\N	45.00000	0101000020E6100000FCFFFFBF1F68024075A44507F46C4840
1324784	5822	\N	\N	44.00000	0101000020E610000002000080A8790240443403C0466C4840
1324786	5822	\N	\N	44.00000	0101000020E61000000B000000707D0240BD9B1B8A306C4840
1324788	5822	\N	\N	42.00000	0101000020E610000007000000868502402E9DEFDA516C4840
1324790	5822	\N	\N	43.00000	0101000020E61000000B000000298802405AA8B910686C4840
1324794	5822	\N	\N	64.00000	0101000020E610000004000000E3AF02408B4138FE7C6B4840
1324797	5822	\N	\N	48.00000	0101000020E6100000FAFFFFFFE0CF0240979BE507196B4840
1324799	5822	\N	\N	46.00000	0101000020E6100000060000009FE40240A9BABC65846B4840
1324802	5822	\N	\N	32.00000	0101000020E610000001000000A7EB02403C8374A0166C4840
1324805	5822	\N	\N	45.00000	0101000020E610000000000000C0F00240A619E57E3D6C4840
1324808	5822	\N	\N	40.00000	0101000020E6100000FCFFFFFF35F3024012A9EF63326C4840
1324811	5822	\N	\N	51.00000	0101000020E6100000F8FFFFFFD2280340F6D645A2926C4840
1324847	5828	\N	\N	36.00000	0101000020E6100000FBFFFFFF0E0C0240DC1682306A714840
1324850	5828	\N	\N	48.00000	0101000020E6100000030000007CCB024028E7B8C9D26D4840
1324852	5828	\N	\N	38.00000	0101000020E6100000040000004AEE02400D34C1B4536C4840
1324855	5828	\N	\N	31.00000	0101000020E610000000000000C01D03406B26952FD3694840
1324858	5828	\N	\N	33.00000	0101000020E6100000FFFFFFFF514F0340F87779179C684840
1324861	5828	\N	\N	32.00000	0101000020E6100000FDFFFFFF039D034016AE15A56F684840
1324864	5828	\N	\N	57.00000	0101000020E61000000B00000070B803406B26952FD3694840
1324867	5828	\N	\N	39.00000	0101000020E6100000030000005CEA0340CC8CD246426A4840
1324870	5828	\N	\N	84.00000	0101000020E6100000FDFFFFFF432F0440109C90C7CB694840
1324872	5828	\N	\N	86.00000	0101000020E6100000FDFFFFFFA35604405D6441A0116B4840
1324886	5830	\N	\N	42.00000	0101000020E6100000020000C01E4B0240D6CB02D7A66D4840
1324888	5830	\N	\N	43.00000	0101000020E610000008000000544E0240F1322640D36D4840
1324892	5830	\N	\N	33.00000	0101000020E6100000FCFFFF3F2C540240641A81E21E6E4840
1324894	5830	\N	\N	39.00000	0101000020E61000000C000020A25802407AFB30A0F06D4840
1324897	5830	\N	\N	42.00000	0101000020E6100000FBFFFF9FAD540240431506B3CD6D4840
1324900	5830	\N	\N	34.00000	0101000020E610000008000000F4530240CA21B070C16D4840
1324903	5830	\N	\N	47.00000	0101000020E6100000F8FFFF9FAA570240084BF4E2996D4840
1324906	5830	\N	\N	43.00000	0101000020E6100000F7FFFF5FC65D0240DBBE11355E6D4840
1324909	5830	\N	\N	41.00000	0101000020E6100000FAFFFF5F6960024062F9C25F436D4840
1324912	5830	\N	\N	45.00000	0101000020E6100000FCFFFFBF1F68024075A44507F46C4840
1324915	5830	\N	\N	44.00000	0101000020E610000002000080A8790240443403C0466C4840
1324918	5830	\N	\N	44.00000	0101000020E61000000B000000707D0240BD9B1B8A306C4840
1324920	5830	\N	\N	42.00000	0101000020E610000007000000868502402E9DEFDA516C4840
1324922	5830	\N	\N	43.00000	0101000020E61000000B000000298802405AA8B910686C4840
1324925	5830	\N	\N	64.00000	0101000020E610000004000000E3AF02408B4138FE7C6B4840
1324929	5830	\N	\N	48.00000	0101000020E6100000FAFFFFFFE0CF0240979BE507196B4840
1324932	5830	\N	\N	46.00000	0101000020E6100000060000009FE40240A9BABC65846B4840
1324935	5830	\N	\N	32.00000	0101000020E610000001000000A7EB02403C8374A0166C4840
1324938	5830	\N	\N	45.00000	0101000020E610000000000000C0F00240A619E57E3D6C4840
1324941	5830	\N	\N	40.00000	0101000020E6100000FCFFFFFF35F3024012A9EF63326C4840
1324944	5830	\N	\N	51.00000	0101000020E6100000F8FFFFFFD2280340F6D645A2926C4840
1324927	5831	\N	\N	30.00000	0101000020E6100000F9FFFF7F265602400DEC661DDB6D4840
1324930	5831	\N	\N	34.00000	0101000020E610000005000080DD530240900D9E48C06D4840
1324933	5831	\N	\N	45.00000	0101000020E6100000FBFFFF7F9B680240E2499E2BEF6C4840
1324936	5831	\N	\N	44.00000	0101000020E6100000FBFFFF7F027A0240CA31B8583F6C4840
1324939	5831	\N	\N	44.00000	0101000020E610000007000080597D024012A9EF63326C4840
1324942	5831	\N	\N	73.00000	0101000020E610000004000080968B02401542EA772C6B4840
1324945	5831	\N	\N	73.00000	0101000020E610000009000000BB8C0240B0E9DD642D6B4840
1324947	5831	\N	\N	69.00000	0101000020E610000001000080BA9402401B9460A6366B4840
1324949	5831	\N	\N	55.00000	0101000020E6100000FEFFFFFFCAC70240A43015C32F6A4840
1324951	5831	\N	\N	43.00000	0101000020E610000001000000AE020340EB7810605F6B4840
1324952	5834	\N	\N	42.00000	0101000020E6100000020000C01E4B0240D6CB02D7A66D4840
1324953	5834	\N	\N	43.00000	0101000020E610000008000000544E0240F1322640D36D4840
1324954	5834	\N	\N	33.00000	0101000020E6100000FCFFFF3F2C540240641A81E21E6E4840
1324955	5835	\N	\N	36.00000	0101000020E6100000FAFFFFFF870B0240413D64E36D714840
1324956	5834	\N	\N	39.00000	0101000020E61000000C000020A25802407AFB30A0F06D4840
1324957	5835	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C02406F6BF6D2D86F4840
1324958	5834	\N	\N	42.00000	0101000020E6100000FBFFFF9FAD540240431506B3CD6D4840
1324959	5835	\N	\N	64.00000	0101000020E6100000060000009F5D0240B9E5CABA146F4840
1324960	5834	\N	\N	34.00000	0101000020E610000008000000F4530240CA21B070C16D4840
1324961	5835	\N	\N	60.00000	0101000020E6100000F9FFFFFF395902406399FDE5AF6E4840
1324962	5834	\N	\N	47.00000	0101000020E6100000F8FFFF9FAA570240084BF4E2996D4840
1324963	5835	\N	\N	52.00000	0101000020E6100000FEFFFF7F9E6502404E40AAECBB6E4840
1324964	5834	\N	\N	43.00000	0101000020E6100000F7FFFF5FC65D0240DBBE11355E6D4840
1324965	5835	\N	\N	24.00000	0101000020E61000000B0000807C6902402118697FA86E4840
1324966	5834	\N	\N	41.00000	0101000020E6100000FAFFFF5F6960024062F9C25F436D4840
1324967	5835	\N	\N	44.00000	0101000020E610000008000000CD7A02407679FBBA396F4840
1324968	5834	\N	\N	45.00000	0101000020E6100000FCFFFFBF1F68024075A44507F46C4840
1324969	5835	\N	\N	52.00000	0101000020E610000002000000F5700240FDBF7B746E6F4840
1324970	5834	\N	\N	44.00000	0101000020E610000002000080A8790240443403C0466C4840
1324971	5835	\N	\N	44.00000	0101000020E61000000C000080E37A0240C46E0B9AB66F4840
1324972	5834	\N	\N	44.00000	0101000020E61000000B000000707D0240BD9B1B8A306C4840
1324973	5835	\N	\N	48.00000	0101000020E61000000A000080F5950240F405B827286F4840
1324974	5834	\N	\N	42.00000	0101000020E610000007000000868502402E9DEFDA516C4840
1324975	5835	\N	\N	33.00000	0101000020E6100000FBFFFFFF6E8D0240EE0CCEE3656E4840
1324976	5834	\N	\N	43.00000	0101000020E61000000B000000298802405AA8B910686C4840
1324977	5835	\N	\N	34.00000	0101000020E6100000FDFFFFFF237E02409AC4F410706E4840
1324978	5834	\N	\N	64.00000	0101000020E610000004000000E3AF02408B4138FE7C6B4840
1324979	5835	\N	\N	36.00000	0101000020E6100000F7FFFF7FF8650240E231A3B65B6E4840
1324980	5834	\N	\N	48.00000	0101000020E6100000FAFFFFFFE0CF0240979BE507196B4840
1324981	5835	\N	\N	33.00000	0101000020E610000007000080B26002408A11415C476E4840
1324982	5834	\N	\N	46.00000	0101000020E6100000060000009FE40240A9BABC65846B4840
1324983	5835	\N	\N	30.00000	0101000020E6100000F9FFFF7F265602400DEC661DDB6D4840
1324984	5834	\N	\N	32.00000	0101000020E610000001000000A7EB02403C8374A0166C4840
1324985	5835	\N	\N	34.00000	0101000020E610000005000080DD530240900D9E48C06D4840
1324986	5834	\N	\N	45.00000	0101000020E610000000000000C0F00240A619E57E3D6C4840
1324987	5835	\N	\N	45.00000	0101000020E6100000FBFFFF7F9B680240E2499E2BEF6C4840
1324988	5834	\N	\N	40.00000	0101000020E6100000FCFFFFFF35F3024012A9EF63326C4840
1324989	5835	\N	\N	44.00000	0101000020E6100000FBFFFF7F027A0240CA31B8583F6C4840
1324990	5836	\N	\N	36.00000	0101000020E6100000FBFFFFFF0E0C0240DC1682306A714840
1324991	5834	\N	\N	51.00000	0101000020E6100000F8FFFFFFD2280340F6D645A2926C4840
1324992	5835	\N	\N	44.00000	0101000020E610000007000080597D024012A9EF63326C4840
1324993	5836	\N	\N	48.00000	0101000020E6100000030000007CCB024028E7B8C9D26D4840
1324994	5835	\N	\N	73.00000	0101000020E610000004000080968B02401542EA772C6B4840
1324995	5836	\N	\N	38.00000	0101000020E6100000040000004AEE02400D34C1B4536C4840
1324996	5835	\N	\N	73.00000	0101000020E610000009000000BB8C0240B0E9DD642D6B4840
1324997	5836	\N	\N	31.00000	0101000020E610000000000000C01D03406B26952FD3694840
1324998	5837	\N	\N	32.00000	0101000020E610000007000000268B02409AC4F410706E4840
1324999	5835	\N	\N	69.00000	0101000020E610000001000080BA9402401B9460A6366B4840
1325000	5836	\N	\N	33.00000	0101000020E6100000FFFFFFFF514F0340F87779179C684840
1325001	5837	\N	\N	30.00000	0101000020E6100000F8FFFFFF6B6302404EC44C03586E4840
1325002	5835	\N	\N	55.00000	0101000020E6100000FEFFFFFFCAC70240A43015C32F6A4840
1325003	5836	\N	\N	32.00000	0101000020E6100000FDFFFFFF039D034016AE15A56F684840
1325004	5837	\N	\N	33.00000	0101000020E610000005000000915C02405D3E66C1296E4840
1325005	5835	\N	\N	43.00000	0101000020E610000001000000AE020340EB7810605F6B4840
1325006	5836	\N	\N	57.00000	0101000020E61000000B00000070B803406B26952FD3694840
1325007	5837	\N	\N	43.00000	0101000020E610000009000000BB5F024043242B8D136E4840
1325008	5836	\N	\N	39.00000	0101000020E6100000030000005CEA0340CC8CD246426A4840
1325009	5837	\N	\N	42.00000	0101000020E61000000B000000F06602403B01E362CB6D4840
1325010	5836	\N	\N	84.00000	0101000020E6100000FDFFFFFF432F0440109C90C7CB694840
1325011	5837	\N	\N	41.00000	0101000020E6100000FCFFFFFFD571024071DB535B5C6D4840
1325012	5836	\N	\N	86.00000	0101000020E6100000FDFFFFFFA35604405D6441A0116B4840
1325013	5837	\N	\N	43.00000	0101000020E6100000F6FFFFFF5D620240EC7C3765AE6C4840
1325014	5837	\N	\N	44.00000	0101000020E61000000B000000E97C0240A04BF548276C4840
1325015	5837	\N	\N	73.00000	0101000020E610000000000000808B0240B5160FB1296B4840
1325016	5837	\N	\N	69.00000	0101000020E6100000F6FFFFFFFD9402408930AC18316B4840
1325017	5837	\N	\N	66.00000	0101000020E6100000F9FFFFFFF9A702401F89A22BC06A4840
1325018	5838	\N	\N	36.00000	0101000020E6100000FAFFFFFF870B0240413D64E36D714840
1325019	5838	\N	\N	63.00000	0101000020E6100000FDFFFFFF635C02406F6BF6D2D86F4840
1325020	5838	\N	\N	64.00000	0101000020E6100000060000009F5D0240B9E5CABA146F4840
1325021	5838	\N	\N	60.00000	0101000020E6100000F9FFFFFF395902406399FDE5AF6E4840
1325022	5839	\N	\N	36.00000	0101000020E6100000FBFFFFFF0E0C0240DC1682306A714840
1325023	5838	\N	\N	52.00000	0101000020E6100000FEFFFF7F9E6502404E40AAECBB6E4840
1325024	5839	\N	\N	48.00000	0101000020E6100000030000007CCB024028E7B8C9D26D4840
1325025	5838	\N	\N	24.00000	0101000020E61000000B0000807C6902402118697FA86E4840
1325026	5839	\N	\N	38.00000	0101000020E6100000040000004AEE02400D34C1B4536C4840
1325027	5838	\N	\N	44.00000	0101000020E610000008000000CD7A02407679FBBA396F4840
1325028	5839	\N	\N	31.00000	0101000020E610000000000000C01D03406B26952FD3694840
1325029	5838	\N	\N	52.00000	0101000020E610000002000000F5700240FDBF7B746E6F4840
1325030	5839	\N	\N	33.00000	0101000020E6100000FFFFFFFF514F0340F87779179C684840
1325031	5838	\N	\N	44.00000	0101000020E61000000C000080E37A0240C46E0B9AB66F4840
1325032	5839	\N	\N	32.00000	0101000020E6100000FDFFFFFF039D034016AE15A56F684840
1325033	5838	\N	\N	48.00000	0101000020E61000000A000080F5950240F405B827286F4840
1325034	5839	\N	\N	57.00000	0101000020E61000000B00000070B803406B26952FD3694840
1325035	5838	\N	\N	33.00000	0101000020E6100000FBFFFFFF6E8D0240EE0CCEE3656E4840
1325036	5839	\N	\N	39.00000	0101000020E6100000030000005CEA0340CC8CD246426A4840
1325037	5838	\N	\N	34.00000	0101000020E6100000FDFFFFFF237E02409AC4F410706E4840
1325038	5839	\N	\N	84.00000	0101000020E6100000FDFFFFFF432F0440109C90C7CB694840
1325039	5838	\N	\N	36.00000	0101000020E6100000F7FFFF7FF8650240E231A3B65B6E4840
1325040	5838	\N	\N	33.00000	0101000020E610000007000080B26002408A11415C476E4840
1325041	5839	\N	\N	86.00000	0101000020E6100000FDFFFFFFA35604405D6441A0116B4840
1325042	5838	\N	\N	30.00000	0101000020E6100000F9FFFF7F265602400DEC661DDB6D4840
1325043	5838	\N	\N	34.00000	0101000020E610000005000080DD530240900D9E48C06D4840
1325044	5838	\N	\N	45.00000	0101000020E6100000FBFFFF7F9B680240E2499E2BEF6C4840
1325045	5840	\N	\N	42.00000	0101000020E6100000020000C01E4B0240D6CB02D7A66D4840
1325046	5838	\N	\N	44.00000	0101000020E6100000FBFFFF7F027A0240CA31B8583F6C4840
1325047	5840	\N	\N	43.00000	0101000020E610000008000000544E0240F1322640D36D4840
1325048	5838	\N	\N	44.00000	0101000020E610000007000080597D024012A9EF63326C4840
1325049	5840	\N	\N	33.00000	0101000020E6100000FCFFFF3F2C540240641A81E21E6E4840
1325051	5840	\N	\N	39.00000	0101000020E61000000C000020A25802407AFB30A0F06D4840
1325053	5840	\N	\N	42.00000	0101000020E6100000FBFFFF9FAD540240431506B3CD6D4840
1325055	5840	\N	\N	34.00000	0101000020E610000008000000F4530240CA21B070C16D4840
1325058	5840	\N	\N	47.00000	0101000020E6100000F8FFFF9FAA570240084BF4E2996D4840
1325061	5840	\N	\N	43.00000	0101000020E6100000F7FFFF5FC65D0240DBBE11355E6D4840
1325063	5840	\N	\N	41.00000	0101000020E6100000FAFFFF5F6960024062F9C25F436D4840
1325065	5840	\N	\N	45.00000	0101000020E6100000FCFFFFBF1F68024075A44507F46C4840
1325067	5840	\N	\N	44.00000	0101000020E610000002000080A8790240443403C0466C4840
1325069	5840	\N	\N	44.00000	0101000020E61000000B000000707D0240BD9B1B8A306C4840
1325071	5840	\N	\N	42.00000	0101000020E610000007000000868502402E9DEFDA516C4840
1325073	5840	\N	\N	43.00000	0101000020E61000000B000000298802405AA8B910686C4840
1325075	5840	\N	\N	64.00000	0101000020E610000004000000E3AF02408B4138FE7C6B4840
1325076	5840	\N	\N	48.00000	0101000020E6100000FAFFFFFFE0CF0240979BE507196B4840
1325078	5840	\N	\N	46.00000	0101000020E6100000060000009FE40240A9BABC65846B4840
1325080	5840	\N	\N	32.00000	0101000020E610000001000000A7EB02403C8374A0166C4840
1325081	5840	\N	\N	45.00000	0101000020E610000000000000C0F00240A619E57E3D6C4840
1325082	5840	\N	\N	40.00000	0101000020E6100000FCFFFFFF35F3024012A9EF63326C4840
1325083	5840	\N	\N	51.00000	0101000020E6100000F8FFFFFFD2280340F6D645A2926C4840
1325050	5838	\N	\N	73.00000	0101000020E610000004000080968B02401542EA772C6B4840
1325052	5838	\N	\N	73.00000	0101000020E610000009000000BB8C0240B0E9DD642D6B4840
1325054	5838	\N	\N	69.00000	0101000020E610000001000080BA9402401B9460A6366B4840
1325057	5838	\N	\N	55.00000	0101000020E6100000FEFFFFFFCAC70240A43015C32F6A4840
1325060	5838	\N	\N	43.00000	0101000020E610000001000000AE020340EB7810605F6B4840
1325056	5841	\N	\N	32.00000	0101000020E610000007000000268B02409AC4F410706E4840
1325059	5841	\N	\N	30.00000	0101000020E6100000F8FFFFFF6B6302404EC44C03586E4840
1325062	5841	\N	\N	33.00000	0101000020E610000005000000915C02405D3E66C1296E4840
1325064	5841	\N	\N	43.00000	0101000020E610000009000000BB5F024043242B8D136E4840
1325066	5841	\N	\N	42.00000	0101000020E61000000B000000F06602403B01E362CB6D4840
1325068	5841	\N	\N	41.00000	0101000020E6100000FCFFFFFFD571024071DB535B5C6D4840
1325070	5841	\N	\N	43.00000	0101000020E6100000F6FFFFFF5D620240EC7C3765AE6C4840
1325072	5841	\N	\N	44.00000	0101000020E61000000B000000E97C0240A04BF548276C4840
1325074	5841	\N	\N	73.00000	0101000020E610000000000000808B0240B5160FB1296B4840
1325077	5841	\N	\N	69.00000	0101000020E6100000F6FFFFFFFD9402408930AC18316B4840
1325079	5841	\N	\N	66.00000	0101000020E6100000F9FFFFFFF9A702401F89A22BC06A4840
\.


--
-- Data for Name: itinerary_track_segment; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.itinerary_track_segment (id, itinerary_track_id, distance, ascent, descent, lowest, highest) FROM stdin;
5756	1015	\N	\N	\N	\N	\N
5757	1015	\N	\N	\N	\N	\N
5758	1016	\N	\N	\N	\N	\N
5771	1025	\N	\N	\N	\N	\N
5772	1025	\N	\N	\N	\N	\N
5773	1026	\N	\N	\N	\N	\N
5777	1027	\N	\N	\N	\N	\N
5778	1028	\N	\N	\N	\N	\N
5796	1038	24.58	86.0	36.0	31.0	86.0
5794	1036	9.89	73.0	64.0	32.0	64.0
5797	1039	6.73	45.0	11.0	30.0	73.0
5795	1037	18.27	107.0	100.0	24.0	73.0
5800	1042	24.58	86.0	36.0	31.0	86.0
5798	1040	9.89	73.0	64.0	32.0	64.0
5799	1041	18.27	107.0	100.0	24.0	73.0
5801	1043	6.73	45.0	11.0	30.0	73.0
5804	1046	24.58	86.0	36.0	31.0	86.0
5802	1044	9.89	73.0	64.0	32.0	64.0
5803	1045	18.27	107.0	100.0	24.0	73.0
5805	1047	6.73	45.0	11.0	30.0	73.0
5808	1050	24.58	86.0	36.0	31.0	86.0
5806	1048	9.89	73.0	64.0	32.0	64.0
5807	1049	18.27	107.0	100.0	24.0	73.0
5809	1051	6.73	45.0	11.0	30.0	73.0
5811	1053	24.58	86.0	36.0	31.0	86.0
5810	1052	9.89	73.0	64.0	32.0	64.0
5813	1055	6.73	45.0	11.0	30.0	73.0
5812	1054	18.27	107.0	100.0	24.0	73.0
5815	1057	24.58	86.0	36.0	31.0	86.0
5814	1056	9.89	73.0	64.0	32.0	64.0
5817	1059	6.73	45.0	11.0	30.0	73.0
5816	1058	18.27	107.0	100.0	24.0	73.0
5820	1062	24.58	86.0	36.0	31.0	86.0
5818	1060	9.89	73.0	64.0	32.0	64.0
5821	1063	6.73	45.0	11.0	30.0	73.0
5819	1061	18.27	107.0	100.0	24.0	73.0
5823	1066	24.58	86.0	36.0	31.0	86.0
5822	1064	9.89	73.0	64.0	32.0	64.0
5824	1065	18.27	107.0	100.0	24.0	73.0
5825	1067	6.73	45.0	11.0	30.0	73.0
5827	1069	18.27	107.0	100.0	24.0	73.0
5826	1068	9.89	73.0	64.0	32.0	64.0
5828	1070	24.58	86.0	36.0	31.0	86.0
5829	1071	6.73	45.0	11.0	30.0	73.0
5832	1074	24.58	86.0	36.0	31.0	86.0
5830	1072	9.89	73.0	64.0	32.0	64.0
5833	1075	6.73	45.0	11.0	30.0	73.0
5831	1073	18.27	107.0	100.0	24.0	73.0
5835	1077	18.27	107.0	100.0	24.0	73.0
5834	1076	9.89	73.0	64.0	32.0	64.0
5836	1078	24.58	86.0	36.0	31.0	86.0
5837	1079	6.73	45.0	11.0	30.0	73.0
5839	1081	24.58	86.0	36.0	31.0	86.0
5838	1080	18.27	107.0	100.0	24.0	73.0
5841	1083	6.73	45.0	11.0	30.0	73.0
5840	1082	9.89	73.0	64.0	32.0	64.0
\.


--
-- Data for Name: itinerary_waypoint; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.itinerary_waypoint (id, itinerary_id, name, "time", comment, symbol, altitude, description, type, avg_samples, geog, extended_attributes) FROM stdin;
10862	983	Montpellier	2016-11-02 19:29:08+00	Test Comment 2	City (Large)	\N	Test description 2	\N	2	0101000020E610000051CBA4C0E1E90E4005590520A4CE4540	\N
10872	2419	Eiffel Tower	1889-03-15 23:59:59+00	\N	Tall Tower	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840	\N
10588	929	Montpellier	2016-11-02 19:29:08+00	Test Comment 2	City (Large)	55.00000	Test description 2	\N	2	0101000020E61000002DCDAD1056030F4085EE92382BCE4540	\N
10879	2430	Arc de Triomphe	2020-02-24 16:29:41.113+00	\N	landmark	63.00000	\N	\N	\N	0101000020E61000005C8FC2F5285C0240569FABADD86F4840	\N
10878	2430	Champs-Élysées	2020-02-24 16:27:00.373+00	\N	Scenic Area	50.00000	\N	\N	\N	0101000020E61000002EFF21FDF6750240C8073D9B556F4840	\N
10877	2430	Eiffel Tower	1889-03-15 23:59:59+00	\N	Tall Tower	73.00000	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840	\N
10880	2432	Arc de Triomphe	2020-02-24 16:29:41.113+00	\N	landmark	63.00000	\N	\N	\N	0101000020E61000005C8FC2F5285C0240569FABADD86F4840	\N
10881	2432	Champs-Élysées	2020-02-24 16:27:00.373+00	\N	Scenic Area	50.00000	\N	\N	\N	0101000020E61000002EFF21FDF6750240C8073D9B556F4840	\N
10882	2432	Eiffel Tower	1889-03-15 23:59:59+00	\N	Tall Tower	73.00000	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840	\N
10883	2433	Arc de Triomphe	2020-02-24 16:29:41.113+00	\N	landmark	63.00000	\N	\N	\N	0101000020E61000005C8FC2F5285C0240569FABADD86F4840	\N
10884	2433	Champs-Élysées	2020-02-24 16:27:00.373+00	\N	Scenic Area	50.00000	\N	\N	\N	0101000020E61000002EFF21FDF6750240C8073D9B556F4840	\N
10885	2433	Eiffel Tower	1889-03-15 23:59:59+00	\N	Tall Tower	73.00000	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840	\N
10886	2434	Champs-Élysées	2020-02-24 16:27:00.373+00	\N	Scenic Area	50.00000	\N	\N	\N	0101000020E61000002EFF21FDF6750240C8073D9B556F4840	\N
10887	2434	Arc de Triomphe	2020-02-24 16:29:41.113+00	\N	landmark	63.00000	\N	\N	\N	0101000020E61000005C8FC2F5285C0240569FABADD86F4840	\N
10888	2434	Eiffel Tower	1889-03-15 23:59:59+00	\N	Tall Tower	73.00000	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840	\N
10889	2435	Arc de Triomphe	2020-02-24 16:29:41.113+00	\N	landmark	63.00000	\N	\N	\N	0101000020E61000005C8FC2F5285C0240569FABADD86F4840	\N
10890	2435	Champs-Élysées	2020-02-24 16:27:00.373+00	\N	Scenic Area	50.00000	\N	\N	\N	0101000020E61000002EFF21FDF6750240C8073D9B556F4840	\N
10891	2435	Eiffel Tower	1889-03-15 23:59:59+00	\N	Tall Tower	73.00000	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840	\N
10892	2436	Arc de Triomphe	2020-02-24 16:29:41.113+00	\N	landmark	63.00000	\N	\N	\N	0101000020E61000005C8FC2F5285C0240569FABADD86F4840	\N
10893	2436	Champs-Élysées	2020-02-24 16:27:00.373+00	\N	Scenic Area	50.00000	\N	\N	\N	0101000020E61000002EFF21FDF6750240C8073D9B556F4840	\N
10894	2436	Eiffel Tower	1889-03-15 23:59:59+00	\N	Tall Tower	73.00000	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840	\N
10895	2437	Eiffel Tower	1889-03-15 23:59:59+00	\N	Tall Tower	73.00000	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840	\N
10896	2437	Arc de Triomphe	2020-02-24 16:29:41.113+00	\N	landmark	63.00000	\N	\N	\N	0101000020E61000005C8FC2F5285C0240569FABADD86F4840	\N
10897	2437	Champs-Élysées	2020-02-24 16:27:00.373+00	\N	Scenic Area	50.00000	\N	\N	\N	0101000020E61000002EFF21FDF6750240C8073D9B556F4840	\N
10898	2438	Champs-Élysées	2020-02-24 16:27:00.373+00	\N	Scenic Area	50.00000	\N	\N	\N	0101000020E61000002EFF21FDF6750240C8073D9B556F4840	\N
10899	2438	Arc de Triomphe	2020-02-24 16:29:41.113+00	\N	landmark	63.00000	\N	\N	\N	0101000020E61000005C8FC2F5285C0240569FABADD86F4840	\N
10900	2438	Eiffel Tower	1889-03-15 23:59:59+00	\N	Tall Tower	73.00000	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840	\N
10901	2439	Arc de Triomphe	2020-02-24 16:29:41.113+00	\N	landmark	63.00000	\N	\N	\N	0101000020E61000005C8FC2F5285C0240569FABADD86F4840	\N
10902	2439	Champs-Élysées	2020-02-24 16:27:00.373+00	\N	Scenic Area	50.00000	\N	\N	\N	0101000020E61000002EFF21FDF6750240C8073D9B556F4840	\N
10903	2439	Eiffel Tower	1889-03-15 23:59:59+00	\N	Tall Tower	73.00000	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840	\N
10904	2440	Arc de Triomphe	2020-02-24 16:29:41.113+00	\N	landmark	63.00000	\N	\N	\N	0101000020E61000005C8FC2F5285C0240569FABADD86F4840	\N
10905	2440	Champs-Élysées	2020-02-24 16:27:00.373+00	\N	Scenic Area	50.00000	\N	\N	\N	0101000020E61000002EFF21FDF6750240C8073D9B556F4840	\N
10906	2440	Eiffel Tower	1889-03-15 23:59:59+00	\N	Tall Tower	73.00000	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840	\N
10907	2441	Arc de Triomphe	2020-02-24 16:29:41.113+00	\N	landmark	63.00000	\N	\N	\N	0101000020E61000005C8FC2F5285C0240569FABADD86F4840	\N
10908	2441	Champs-Élysées	2020-02-24 16:27:00.373+00	\N	Scenic Area	50.00000	\N	\N	\N	0101000020E61000002EFF21FDF6750240C8073D9B556F4840	\N
10909	2441	Eiffel Tower	1889-03-15 23:59:59+00	\N	Tall Tower	73.00000	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840	\N
10910	2442	Arc de Triomphe	2020-02-24 16:29:41.113+00	\N	landmark	63.00000	\N	\N	\N	0101000020E61000005C8FC2F5285C0240569FABADD86F4840	\N
10911	2442	Champs-Élysées	2020-02-24 16:27:00.373+00	\N	Scenic Area	50.00000	\N	\N	\N	0101000020E61000002EFF21FDF6750240C8073D9B556F4840	\N
10912	2442	Eiffel Tower	1889-03-15 23:59:59+00	\N	Tall Tower	73.00000	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840	\N
10861	983	London	2016-11-02 19:28:50+00	Test Comment 1	City (Capitol)	100.00000	Test description 1	My Type	1	0101000020E6100000FBEFDA083842C1BFFF8107403BC24940	{"osmand:color":"#b400842b"}
10863	983	Paris	2016-11-02 19:28:15+00	Test Comment 3	City (Capitol)	\N	Test description 3	\N	\N	0101000020E610000086D7E4DF1DA702400B87F77F026E4840	{"osmand:color":"#b400842b"}
10864	983	Test waypoint modification	2015-12-12 10:48:00+00	Test comment	Flag, Blue	450.00000	Test description	Restaurant	99	0101000020E610000000000000000008C00000000000004940	{"osmand:color":"#ff0000"}
10865	983	Test waypoint modification	2015-12-12 10:48:00+00	test mutli-line\n\ncomment\n\nover many lines\n\nthat goes and and on and on.  A very verbose comment that is boring to read and even more boring to write.	Restaurant	450.00000	Test description	Restaurant	99	0101000020E610000000000000000008C00000000000004940	{"osmand:color":"#ff0000"}
10795	929	Test waypoint modification	2015-12-12 10:48:00+00	test mutli-line\n\ncomment\n\nover many lines\n\nthat goes and and on and on.  A very verbose comment that is boring to read and even more boring to write.	Restaurant	450.00000	Test description	Restaurant	99	0101000020E610000000000000000008C00000000000004940	{"osmand:color":"#ff0000"}
9356	929	Test waypoint modification	2015-12-12 10:48:00+00	Test comment	Flag, Blue	450.00000	Test description	Restaurant	99	0101000020E610000000000000000008C00000000000004940	{"osmand:color":"#ff0000"}
10587	929	London	2016-11-02 19:28:50+00	Test Comment 1	City (Capitol)	100.00000	Test description 1	My Type	1	0101000020E6100000787C7BD7A02FB9BFCD9541B5C1C14940	{"osmand:color":"#b400842b"}
10589	929	Paris	2016-11-02 19:28:15+00	Test Comment 3	City (Capitol)	73.00000	Test description 3	\N	\N	0101000020E61000004260E5D0225B0240965AEF37DA6D4840	{"osmand:color":"#b400842b"}
\.


--
-- Data for Name: location; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.location (id, user_id, "time", hdop, altitude, speed, bearing, sat, provider, battery, note, geog) FROM stdin;
1	29	2015-12-10 17:48:45.678+00	28.0	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
2	29	2015-12-10 17:49:02.811+00	48.0	-47.59584	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
3	29	2015-12-10 17:49:18.267+00	8.0	36.43140	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
4	29	2015-12-10 17:49:34.235+00	8.0	48.38307	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
5	29	2015-12-10 17:49:49.287+00	8.0	48.23096	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
6	29	2015-12-10 17:50:04.3+00	8.0	48.09041	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
7	29	2015-12-10 17:50:20.241+00	8.0	47.97643	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
8	29	2015-12-10 17:50:36.241+00	8.0	47.91262	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
9	29	2015-12-10 17:50:52.496+00	12.0	47.40576	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
10	29	2015-12-10 17:51:08.283+00	16.0	47.04527	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
11	29	2015-12-10 17:51:24.38+00	12.0	46.86332	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
12	29	2015-12-10 17:51:40.268+00	12.0	46.74418	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
13	29	2015-12-10 17:51:55.457+00	24.0	46.61090	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
14	29	2015-12-10 17:52:11.23+00	8.0	46.90281	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15	29	2015-12-10 17:52:27.18+00	6.0	47.25555	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
16	29	2015-12-10 17:52:43.156+00	12.0	47.60045	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
17	29	2015-12-10 17:52:58.178+00	6.0	47.48304	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
18	29	2015-12-10 17:53:13.196+00	8.0	47.22823	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
19	29	2015-12-10 17:53:28.202+00	6.0	47.14187	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
20	29	2015-12-10 17:53:43.216+00	8.0	47.09595	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
21	29	2015-12-10 17:53:58.256+00	12.0	47.04038	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
22	29	2015-12-10 17:54:13.368+00	6.0	47.34203	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
23	29	2015-12-10 17:54:29.262+00	6.0	48.48309	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
24	29	2015-12-10 17:54:44.317+00	6.0	49.00377	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
25	29	2015-12-10 17:55:00.306+00	6.0	49.12439	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
26	29	2015-12-10 17:55:16.247+00	6.0	49.16155	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
27	29	2015-12-10 17:55:32.371+00	6.0	49.29865	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
28	29	2015-12-10 17:55:48.41+00	6.0	49.48713	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
29	29	2015-12-10 17:56:04.22+00	6.0	49.71073	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
30	29	2015-12-10 17:56:19.346+00	6.0	49.81036	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
31	29	2015-12-10 17:56:35.333+00	6.0	49.77771	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
32	29	2015-12-10 17:56:51.321+00	6.0	49.74463	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
33	29	2015-12-10 17:57:06.42+00	6.0	49.83752	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
34	29	2015-12-10 17:57:22.342+00	12.0	49.75256	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
35	29	2015-12-10 18:11:24.198+00	48.0	64.03132	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
36	29	2015-12-10 18:11:40.134+00	16.0	48.20074	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
37	29	2015-12-10 18:21:10.717+00	32.0	26.53609	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
38	29	2015-12-10 18:21:26.419+00	24.0	48.63949	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
39	29	2015-12-11 09:51:11.595+00	20.0	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
40	29	2015-12-11 09:51:41.792+00	32.0	42.87444	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
41	29	2015-12-11 09:52:57.174+00	16.0	61.71730	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
42	29	2015-12-11 09:53:55.825+00	16.0	48.61009	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
43	29	2015-12-11 09:54:57.976+00	32.0	69.69874	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
44	29	2015-12-11 09:55:56.379+00	16.0	55.45817	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
45	29	2015-12-11 09:58:55.388+00	48.0	46.83736	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
46	29	2015-12-11 09:59:57.047+00	32.0	77.21889	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
47	29	2015-12-11 10:00:54.788+00	32.0	54.66311	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
48	29	2015-12-11 10:01:55.336+00	48.0	48.63861	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
49	29	2015-12-11 10:02:38.97+00	26.3	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
50	29	2015-12-11 10:03:13.296+00	6.0	47.02446	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
51	29	2015-12-11 10:04:28.743+00	48.0	53.04834	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
52	29	2015-12-11 10:06:26.433+00	32.0	54.68237	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
53	29	2015-12-11 10:08:27.273+00	48.0	67.54256	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
54	29	2015-12-11 10:11:28.04+00	32.0	69.71392	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
55	29	2015-12-11 10:13:26.586+00	48.0	45.86022	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
56	29	2015-12-11 10:14:25.223+00	48.0	51.78368	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
57	29	2015-12-11 10:15:27.167+00	32.0	57.36875	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
58	29	2015-12-11 10:16:27.177+00	32.0	69.13952	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
59	29	2015-12-11 10:17:05.568+00	28.8	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
60	29	2015-12-11 10:17:36.165+00	12.0	57.10656	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
61	29	2015-12-11 10:18:07.14+00	6.0	53.18243	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
62	29	2015-12-11 10:18:37.181+00	6.0	53.54308	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
63	29	2015-12-11 10:19:22.122+00	48.0	53.49065	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
64	29	2015-12-11 10:19:52.176+00	8.0	53.11393	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
65	29	2015-12-11 10:20:23.165+00	6.0	53.32507	0.3	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
66	29	2015-12-11 10:20:53.416+00	8.0	52.95678	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
67	29	2015-12-11 10:21:24.169+00	6.0	53.30026	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
68	29	2015-12-11 10:21:55.146+00	12.0	53.39958	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
69	29	2015-12-11 10:22:40.27+00	32.0	48.52645	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
70	29	2015-12-11 10:23:39.323+00	32.0	29.15632	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
71	29	2015-12-11 10:24:40.276+00	48.0	54.28622	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
72	29	2015-12-11 10:25:40.472+00	32.0	44.67345	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
73	29	2015-12-11 10:26:39.01+00	48.0	47.83597	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
74	29	2015-12-11 10:28:39.702+00	32.0	37.33819	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
75	29	2015-12-11 10:30:39.569+00	24.0	28.04690	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
76	29	2015-12-11 10:33:38.489+00	32.0	53.25307	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
77	29	2015-12-11 10:34:38.435+00	32.0	54.81836	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
78	29	2015-12-11 10:35:41.144+00	32.0	44.48648	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
79	29	2015-12-11 10:36:38.343+00	32.0	64.17602	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
80	29	2015-12-11 10:38:39.151+00	32.0	52.19923	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
81	29	2015-12-11 10:39:38.143+00	32.0	76.90907	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
82	29	2015-12-11 10:41:38.086+00	48.0	71.12769	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
83	29	2015-12-11 10:42:38.523+00	32.0	54.51712	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
84	29	2015-12-11 10:43:38.107+00	32.0	56.49540	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
85	29	2015-12-11 10:44:40.545+00	32.0	65.15405	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
86	29	2015-12-11 10:45:38.09+00	48.0	35.53558	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
87	29	2015-12-11 10:47:15.536+00	26.0	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
88	29	2015-12-11 10:49:21.791+00	32.0	55.06961	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
89	29	2015-12-11 10:52:22.032+00	32.0	78.93964	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
90	29	2015-12-11 10:54:20.142+00	32.0	76.58849	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
91	29	2015-12-11 10:56:23.336+00	32.0	51.82863	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
92	29	2015-12-11 11:01:21.88+00	32.0	-6.24129	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
93	29	2015-12-11 11:03:23.315+00	32.0	62.37791	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
94	29	2015-12-11 11:06:22.442+00	48.0	88.36466	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
95	29	2015-12-11 11:08:22.271+00	48.0	97.85030	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
96	29	2015-12-11 11:10:23.354+00	32.0	19.09373	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
97	29	2015-12-11 11:12:23.476+00	32.0	53.69154	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
98	29	2015-12-11 11:13:53.621+00	12.0	44.22003	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
99	29	2015-12-11 11:16:22.627+00	32.0	75.08372	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
100	29	2015-12-11 11:19:21.258+00	48.0	63.11445	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
101	29	2015-12-11 11:21:20.559+00	32.0	81.66652	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
102	29	2015-12-11 11:26:22.218+00	32.0	69.92747	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
103	29	2015-12-11 11:28:21.251+00	48.0	62.59260	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
104	29	2015-12-11 11:30:23.284+00	48.0	29.78206	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
105	29	2015-12-11 11:32:21.238+00	48.0	57.56276	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
106	29	2015-12-11 11:35:22.413+00	32.0	78.62145	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
107	29	2015-12-11 11:37:21.181+00	48.0	45.62373	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
108	29	2015-12-11 11:39:22.146+00	32.0	36.07670	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
109	29	2015-12-11 11:40:52.676+00	23.0	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
110	29	2015-12-11 11:43:06.212+00	37.5	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
111	29	2015-12-11 11:44:18.846+00	48.0	55.46568	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
112	29	2015-12-11 11:50:23.553+00	64.0	38.99793	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
113	29	2015-12-11 11:55:24.638+00	32.0	19.80232	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
114	29	2015-12-11 11:57:22.142+00	32.0	40.39003	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
115	29	2015-12-11 11:59:11.162+00	24.0	43.51300	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
116	29	2015-12-11 12:01:11.424+00	32.0	52.49714	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
117	29	2015-12-11 12:03:23.128+00	24.0	43.89343	9.3	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
118	29	2015-12-11 12:05:13.405+00	24.0	48.60447	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
119	29	2015-12-11 12:07:13.484+00	32.0	55.04909	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
120	29	2015-12-11 12:09:14.075+00	32.0	93.48613	17.1	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
121	29	2015-12-11 12:11:13.263+00	32.0	42.27463	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
122	29	2015-12-11 12:12:14.467+00	32.0	52.00989	8.8	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
123	29	2015-12-11 12:14:12.986+00	32.0	42.48766	11.6	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
124	29	2015-12-11 12:15:13.114+00	32.0	39.03815	9.3	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
125	29	2015-12-11 12:17:12.311+00	48.0	38.30399	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
126	29	2015-12-11 12:18:14.04+00	32.0	46.82231	10.6	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
127	29	2015-12-11 12:20:15.166+00	32.0	76.10866	17.2	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
128	29	2015-12-11 12:22:12.982+00	32.0	131.98329	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
129	29	2015-12-11 12:23:13.202+00	32.0	108.75279	21.7	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
130	29	2015-12-11 12:25:14.066+00	32.0	95.78659	22.7	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
131	29	2015-12-11 12:27:13.579+00	32.0	107.45828	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
132	29	2015-12-11 12:29:13.005+00	32.0	119.42396	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
133	29	2015-12-11 12:30:14.033+00	32.0	115.29700	8.4	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
134	29	2015-12-11 12:35:48.148+00	32.0	209.02303	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
135	29	2015-12-11 12:37:09.576+00	48.0	148.07036	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
136	29	2015-12-11 12:39:11.765+00	32.0	201.50960	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
137	29	2015-12-11 12:41:08.009+00	32.0	180.67780	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
138	29	2015-12-11 12:42:21.773+00	32.0	175.38809	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
139	29	2015-12-11 12:44:08.325+00	32.0	185.96610	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
140	29	2015-12-11 12:47:11.595+00	32.0	156.26035	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
141	29	2015-12-11 12:52:15.464+00	48.0	242.36570	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
142	29	2015-12-11 12:54:09.705+00	48.0	201.01941	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
143	29	2015-12-11 12:56:10.206+00	48.0	192.19493	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
144	29	2015-12-11 12:57:11.89+00	32.0	202.57794	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
145	29	2015-12-11 12:59:11.084+00	32.0	208.88437	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
146	29	2015-12-11 13:03:13.669+00	32.0	192.08371	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
147	29	2015-12-11 13:09:13.509+00	32.0	191.41160	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
148	29	2015-12-11 13:11:15.562+00	32.0	170.93626	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
149	29	2015-12-11 13:13:12.472+00	32.0	223.34088	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
150	29	2015-12-11 13:17:13.172+00	32.0	217.57617	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
151	29	2015-12-11 13:18:14.573+00	32.0	289.06497	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
152	29	2015-12-11 13:20:12.616+00	48.0	209.21999	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
153	29	2015-12-11 13:21:14.654+00	32.0	241.64606	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
154	29	2015-12-11 13:30:15.711+00	32.0	103.28391	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
155	29	2015-12-11 13:33:11.239+00	48.0	90.76464	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
156	29	2015-12-11 13:35:11.324+00	48.0	98.27842	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
157	29	2015-12-11 13:36:14.343+00	48.0	98.20610	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
158	29	2015-12-11 13:38:12.354+00	48.0	85.77583	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
159	29	2015-12-11 13:40:12.734+00	32.0	143.53433	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
160	29	2015-12-11 13:42:12.557+00	32.0	120.57677	2.1	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
161	29	2015-12-11 13:48:22.773+00	48.0	118.34061	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
162	29	2015-12-11 14:04:21.545+00	32.0	202.96760	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
163	29	2015-12-11 14:06:16.791+00	48.0	127.53669	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
164	29	2015-12-11 14:10:23.03+00	32.0	185.30704	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
165	29	2015-12-11 14:13:22.091+00	32.0	182.84906	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
166	29	2015-12-11 14:15:25.016+00	24.0	249.56033	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
167	29	2015-12-11 14:26:20.995+00	24.0	182.24167	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
168	29	2015-12-11 14:51:19.721+00	32.0	98.35738	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
169	29	2015-12-11 14:54:22.236+00	32.0	137.81354	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
170	29	2015-12-11 14:59:21.587+00	48.0	147.85168	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
171	29	2015-12-11 15:01:18.499+00	24.0	137.89601	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
172	29	2015-12-11 15:03:18.27+00	24.0	130.12164	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
173	29	2015-12-11 15:04:18.704+00	24.0	145.95910	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
174	29	2015-12-11 15:08:18.852+00	24.0	125.10513	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
175	29	2015-12-11 15:09:18.954+00	32.0	113.08754	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
176	29	2015-12-11 15:11:19.943+00	48.0	157.09558	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
177	29	2015-12-11 15:14:19.485+00	48.0	131.28253	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
178	29	2015-12-11 15:17:18.415+00	32.0	136.99191	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
179	29	2015-12-11 15:18:21.181+00	16.0	196.47145	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
180	29	2015-12-11 15:21:18.526+00	32.0	198.02995	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
181	29	2015-12-11 15:23:18.444+00	32.0	153.72289	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
182	29	2015-12-11 15:25:55.093+00	24.0	193.42218	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
183	29	2015-12-11 15:27:20.832+00	48.0	170.05359	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
184	29	2015-12-11 15:32:21.582+00	32.0	195.08154	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
185	29	2015-12-11 15:34:21.948+00	24.0	213.91872	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
186	29	2015-12-11 15:35:22.19+00	24.0	192.09543	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
187	29	2015-12-11 15:36:22.695+00	48.0	326.36200	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
188	29	2015-12-11 15:38:22.303+00	24.0	162.89967	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
189	29	2015-12-11 15:43:23.192+00	16.0	230.22588	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
190	29	2015-12-11 15:45:22.371+00	32.0	203.55461	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
191	29	2015-12-11 15:48:21.848+00	24.0	186.35120	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
192	29	2015-12-11 15:50:20.269+00	16.0	195.03079	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
193	29	2015-12-11 15:51:22.565+00	16.0	203.91286	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
194	29	2015-12-11 15:53:21.99+00	32.0	209.50278	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
195	29	2015-12-11 15:55:19.497+00	24.0	171.56012	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
196	29	2015-12-11 15:58:21.18+00	16.0	159.48364	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
197	29	2015-12-11 15:59:21.254+00	32.0	167.97330	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
198	29	2015-12-11 16:00:23.36+00	24.0	190.18776	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
199	29	2015-12-11 16:02:21.09+00	48.0	176.73099	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
200	29	2015-12-11 16:05:20.923+00	48.0	153.72902	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
201	29	2015-12-11 16:09:27.029+00	48.0	221.57588	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
202	29	2015-12-11 16:14:24.915+00	48.0	184.65305	8.5	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
203	29	2015-12-11 16:15:28.46+00	32.0	242.18759	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
204	29	2015-12-11 16:18:19.116+00	48.0	135.89049	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
205	29	2015-12-11 16:23:26.578+00	8.0	96.48116	11.9	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
206	29	2015-12-11 16:24:33.93+00	32.0	76.14261	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
207	29	2015-12-11 16:26:26.488+00	16.0	95.28863	21.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
208	29	2015-12-11 16:27:26.508+00	32.0	79.98546	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
209	29	2015-12-11 16:29:27.471+00	48.0	68.60552	19.9	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
210	29	2015-12-11 16:31:28.834+00	48.0	73.17284	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
211	29	2015-12-11 16:33:25.615+00	32.0	46.13934	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
212	29	2015-12-11 16:34:26.293+00	32.0	30.34253	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
213	29	2015-12-11 16:36:25.469+00	32.0	34.62601	12.3	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
214	29	2015-12-11 16:37:28.278+00	12.0	19.91737	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
215	29	2015-12-11 16:39:26.278+00	16.0	31.68205	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
216	29	2015-12-11 16:41:26.378+00	8.0	24.93663	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
217	29	2015-12-11 16:43:26.301+00	32.0	42.32409	8.1	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
218	29	2015-12-11 16:45:26.655+00	16.0	55.57928	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
219	29	2015-12-11 16:47:26.737+00	12.0	41.92464	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
220	29	2015-12-11 16:49:26.603+00	24.0	57.10860	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
221	29	2015-12-11 16:51:26.387+00	48.0	39.60604	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
222	29	2015-12-11 16:52:27.437+00	32.0	16.62996	9.9	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
223	29	2015-12-11 16:54:31.387+00	48.0	49.68448	11.5	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
224	29	2015-12-11 16:56:26.489+00	48.0	31.34053	9.9	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
225	29	2015-12-11 16:58:25.516+00	48.0	42.46823	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
226	29	2015-12-11 16:59:28.799+00	32.0	83.27123	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
227	29	2015-12-11 17:01:12.285+00	32.0	30.93250	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
228	29	2015-12-11 17:02:40.517+00	48.0	31.10194	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
229	29	2015-12-11 17:04:30.759+00	32.0	65.42360	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
230	29	2015-12-12 08:58:13.979+00	32.0	38.21114	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
231	29	2015-12-12 09:03:15.029+00	16.0	55.83433	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
232	29	2015-12-12 09:10:08.456+00	32.0	16.26899	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
233	29	2015-12-12 09:15:08.651+00	48.0	71.54320	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
234	29	2015-12-12 09:25:05.52+00	48.0	21.43515	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
235	29	2015-12-12 09:30:07.946+00	48.0	94.27336	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
236	29	2015-12-12 09:35:08.445+00	32.0	72.15678	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
237	29	2015-12-12 09:45:04.506+00	32.0	91.65360	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
238	29	2015-12-12 09:55:03.268+00	32.0	60.51390	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
239	29	2015-12-12 10:00:03.465+00	32.0	57.81730	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
240	29	2015-12-12 10:10:02.464+00	48.0	37.76046	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
241	29	2015-12-12 10:15:04.363+00	32.0	51.91887	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
242	29	2015-12-12 10:25:04.322+00	32.0	64.11037	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
243	29	2015-12-12 10:35:10.454+00	32.0	90.66716	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
244	29	2015-12-12 10:38:22.557+00	25.0	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
245	29	2015-12-12 10:43:55.028+00	32.0	57.93975	7.4	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
246	29	2015-12-12 10:48:37.809+00	32.0	64.25047	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
247	29	2015-12-12 10:53:37.685+00	48.0	45.11510	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
248	29	2015-12-12 10:58:37.134+00	48.0	66.80489	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
249	29	2015-12-12 11:03:38.22+00	12.0	50.84784	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
250	29	2015-12-12 11:08:35.176+00	48.0	57.56392	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
251	29	2015-12-12 11:13:35.257+00	48.0	52.44290	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
252	29	2015-12-12 11:18:37.243+00	24.0	50.46099	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
253	29	2015-12-12 11:23:34.826+00	24.0	41.50254	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
254	29	2015-12-12 11:28:35.221+00	32.0	52.18317	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
255	29	2015-12-12 11:30:35.895+00	8.0	50.30246	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
256	29	2015-12-12 11:31:34.108+00	8.0	47.15113	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
257	29	2015-12-12 11:36:51.599+00	24.0	56.17534	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
258	29	2015-12-12 11:41:50.285+00	32.0	38.34210	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
259	29	2015-12-12 11:51:49.554+00	32.0	73.41370	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
260	29	2015-12-12 12:01:51.204+00	24.0	45.75670	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
261	29	2015-12-12 12:06:51.131+00	32.0	45.60718	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
262	29	2015-12-12 12:11:52.109+00	16.0	39.68103	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
263	29	2015-12-12 12:16:52.35+00	16.0	48.50514	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
264	29	2015-12-12 12:26:49.564+00	32.0	24.73082	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
265	29	2015-12-12 12:31:49.503+00	32.0	36.81975	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
266	29	2015-12-12 12:36:51.075+00	32.0	48.90233	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
267	29	2015-12-12 12:51:54.043+00	32.0	60.62560	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
268	29	2015-12-12 12:57:01.321+00	64.0	148.10701	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
269	29	2015-12-12 13:01:58.197+00	32.0	66.95023	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
270	29	2015-12-12 13:06:53.331+00	32.0	79.76540	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
271	29	2015-12-13 09:35:04.642+00	27.0	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
272	29	2015-12-13 09:40:24.443+00	48.0	58.69737	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
273	29	2015-12-13 09:50:24.808+00	32.0	55.22186	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
274	29	2015-12-13 10:00:23.402+00	32.0	37.63217	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
275	29	2015-12-13 10:10:22.097+00	32.0	64.08286	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
276	29	2015-12-13 10:15:22.555+00	48.0	44.59169	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
277	29	2015-12-13 10:20:23.435+00	32.0	35.66340	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
278	29	2015-12-13 10:30:24.214+00	32.0	55.06210	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
279	29	2015-12-13 10:40:26.275+00	32.0	68.36991	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
280	29	2015-12-13 10:50:23.307+00	32.0	7.66711	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
281	29	2015-12-13 11:00:25.369+00	32.0	63.20491	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
282	29	2015-12-13 11:05:27.327+00	32.0	69.61248	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
283	29	2015-12-13 11:15:22.868+00	32.0	45.95520	12.7	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
284	29	2015-12-13 11:20:24.457+00	32.0	89.76048	12.5	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
285	29	2015-12-13 11:30:20.724+00	32.0	64.89808	11.4	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
286	29	2015-12-13 11:50:19.595+00	32.0	39.25189	7.9	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
287	29	2015-12-13 11:55:20.162+00	32.0	39.90793	17.8	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
288	29	2015-12-13 12:00:22.521+00	32.0	20.81333	15.2	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
289	29	2015-12-13 12:05:23.789+00	32.0	42.26985	21.7	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
290	29	2015-12-13 12:15:21.412+00	32.0	12.07505	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
291	29	2015-12-13 12:20:22.065+00	24.0	10.09207	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
292	29	2015-12-13 13:10:35.532+00	32.0	-22.49849	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
293	29	2015-12-13 13:20:31.842+00	48.0	27.18262	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
294	29	2015-12-13 13:30:34.363+00	48.0	25.73611	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
295	29	2015-12-13 13:40:34.503+00	32.0	9.32047	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
296	29	2015-12-13 13:55:32.659+00	32.0	-29.52485	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
297	29	2015-12-13 14:05:34.664+00	24.0	15.63666	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
298	29	2015-12-13 14:15:40.57+00	64.0	9.87296	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
299	29	2015-12-13 14:25:35.384+00	48.0	-7.78778	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
300	29	2015-12-13 14:30:35.537+00	64.0	21.98872	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
301	29	2015-12-13 14:45:35.307+00	64.0	34.55123	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
302	29	2015-12-13 14:50:36.154+00	64.0	43.26713	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
303	29	2015-12-13 15:20:34.33+00	48.0	-25.04693	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
304	29	2015-12-13 15:30:37.432+00	32.0	-11.98732	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
305	29	2015-12-13 15:40:21.795+00	12.0	2.85720	15.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
306	29	2015-12-13 15:45:31.094+00	48.0	31.17911	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
307	29	2015-12-13 15:55:30.413+00	24.0	104.62197	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
308	29	2015-12-13 16:00:35.681+00	24.0	259.90982	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
309	29	2015-12-13 16:25:34.511+00	24.0	106.15839	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
310	29	2015-12-13 16:35:37.486+00	24.0	70.08753	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
311	29	2015-12-13 16:50:41.133+00	64.0	72.65694	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
312	29	2015-12-14 10:04:58.36+00	16.0	51.09192	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
313	29	2015-12-14 10:10:06.514+00	32.0	125.56415	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
314	29	2015-12-14 10:15:10.64+00	48.0	49.37104	11.9	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
315	29	2015-12-14 10:25:08.381+00	48.0	109.73980	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
316	29	2015-12-14 10:30:09.154+00	48.0	83.58111	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
317	29	2015-12-14 10:40:11.156+00	24.0	66.52248	8.5	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
318	29	2015-12-14 10:50:06.515+00	48.0	48.34206	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
319	29	2015-12-14 11:00:03.189+00	48.0	111.46332	30.3	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
320	29	2015-12-14 11:10:03.251+00	24.0	206.32573	30.9	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
321	29	2015-12-14 11:20:00.955+00	32.0	97.54374	22.7	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
322	29	2015-12-14 11:25:04.288+00	24.0	87.00727	30.9	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
323	29	2015-12-14 11:35:01.882+00	24.0	94.24696	30.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
324	29	2015-12-14 11:40:10.616+00	32.0	170.12395	26.9	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
325	29	2015-12-14 11:50:01.38+00	48.0	17.60809	16.3	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
326	29	2015-12-14 11:55:03.442+00	16.0	16.94053	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
327	29	2015-12-14 12:05:03.349+00	32.0	11.81109	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
328	29	2015-12-14 12:10:06.537+00	32.0	19.34044	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
329	29	2015-12-14 12:20:07.55+00	16.0	32.07724	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
330	29	2015-12-14 14:10:09.334+00	24.0	23.29288	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
331	29	2015-12-14 14:20:28.425+00	64.0	17.89340	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
332	29	2015-12-14 14:43:27.46+00	64.0	20.78518	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
333	29	2015-12-14 14:48:27.82+00	32.0	24.14507	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
334	29	2015-12-14 14:53:28.792+00	24.0	21.19114	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
335	29	2015-12-14 14:58:29.3+00	12.0	21.12493	1.5	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
336	29	2015-12-14 15:03:29.92+00	12.0	14.91000	1.5	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
337	29	2015-12-14 15:08:30.416+00	16.0	14.16052	3.4	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
338	29	2015-12-14 15:13:30.629+00	16.0	31.10615	31.4	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
339	29	2015-12-14 15:18:31.649+00	16.0	46.47290	26.4	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
340	29	2015-12-14 15:23:32.52+00	24.0	178.95087	26.1	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
341	29	2015-12-14 15:28:32.988+00	24.0	123.36554	25.1	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
342	29	2015-12-14 15:33:33.173+00	16.0	72.06099	25.7	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
343	29	2015-12-14 15:38:33.696+00	24.0	50.52177	26.4	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
344	29	2015-12-14 15:43:34+00	24.0	114.15440	27.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
345	29	2015-12-14 15:48:34.876+00	32.0	91.05626	25.8	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
346	29	2015-12-14 15:53:35.945+00	24.0	172.98328	27.4	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
347	29	2015-12-14 15:58:36.853+00	24.0	224.66151	27.5	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
348	29	2015-12-14 16:08:37.654+00	24.0	117.04468	27.4	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
349	29	2015-12-14 16:18:37.77+00	32.0	91.70271	27.1	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
350	29	2015-12-14 16:23:38.264+00	48.0	37.52547	19.6	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
351	29	2015-12-14 16:28:39.234+00	12.0	41.92637	6.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
352	29	2015-12-14 16:33:50.132+00	48.0	78.80940	24.4	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
353	29	2015-12-14 16:38:50.798+00	16.0	75.52290	22.5	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
354	29	2015-12-14 16:43:51.704+00	24.0	68.09069	10.9	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
355	29	2015-12-14 16:53:52.854+00	16.0	58.24796	5.3	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
356	29	2015-12-14 16:59:58.571+00	48.0	51.63332	5.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
357	29	2015-12-14 17:04:58.702+00	24.0	40.75135	10.2	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
358	29	2015-12-14 17:09:59.035+00	8.0	36.48204	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
359	29	2015-12-14 17:14:59.739+00	8.0	38.30668	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
360	29	2015-12-14 21:19:07.139+00	23.0	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
361	29	2015-12-14 21:20:07.444+00	28.0	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
362	29	2015-12-14 21:20:27.395+00	21.0	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
363	29	2015-12-14 21:20:32.541+00	16.0	35.29953	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
364	29	2015-12-14 21:21:41.363+00	20.0	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
365	29	2015-12-14 21:21:52.355+00	32.0	68.84431	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
366	29	2015-12-14 21:21:57.812+00	24.0	67.74007	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
367	29	2015-12-14 21:22:03.822+00	16.0	70.75603	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
368	29	2015-12-14 21:22:12.777+00	48.0	76.91284	2.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
369	29	2015-12-15 22:24:30.075+00	23.0	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
370	29	2015-12-15 22:24:45.28+00	12.0	60.92278	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
371	29	2015-12-15 22:25:01.244+00	12.0	51.82348	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
372	29	2015-12-15 22:25:16.248+00	12.0	52.28553	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
373	29	2015-12-15 22:25:32.216+00	12.0	51.92226	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
374	29	2015-12-16 17:07:38.382+00	42.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
375	29	2015-12-16 17:07:53.56+00	12.0	35.75677	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
376	29	2015-12-16 17:24:51.349+00	30.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
377	29	2015-12-16 20:14:59.351+00	12.0	43.61799	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
378	29	2015-12-17 19:39:15.655+00	27.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
379	29	2015-12-17 19:41:04.928+00	12.0	42.89621	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
380	29	2015-12-17 19:41:38.748+00	24.0	52.74421	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
381	29	2015-12-17 19:42:40.035+00	25.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
382	29	2015-12-18 21:37:39.17+00	36.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
383	29	2015-12-18 21:38:09.404+00	8.0	59.28322	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
384	29	2015-12-18 21:38:40.383+00	6.0	58.76510	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
385	29	2015-12-19 08:28:21.031+00	32.0	1.46047	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
386	29	2015-12-19 21:07:38.239+00	42.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
387	29	2015-12-19 22:17:13.534+00	12.0	45.46613	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
388	29	2015-12-19 22:22:14.463+00	6.0	44.86626	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
389	29	2015-12-19 22:27:14.474+00	6.0	46.84125	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
390	29	2015-12-20 09:58:58.122+00	48.0	35.73564	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
391	29	2015-12-20 10:02:31.883+00	22.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
392	29	2015-12-20 10:02:47.15+00	12.0	64.94439	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
393	29	2015-12-20 10:03:03.144+00	8.0	56.78054	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
394	29	2015-12-20 10:03:19.131+00	8.0	54.96450	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
395	29	2015-12-20 10:05:39.996+00	26.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
396	29	2015-12-20 10:05:55.359+00	24.0	23.36083	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
397	29	2015-12-22 16:31:00.269+00	12.0	59.52934	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
398	29	2015-12-22 16:31:15.855+00	8.0	67.82288	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
399	29	2015-12-22 16:31:30.859+00	12.0	75.93587	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
400	29	2015-12-22 16:31:46.845+00	12.0	75.96442	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
401	29	2015-12-22 16:32:02.844+00	12.0	76.00072	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
402	29	2015-12-22 16:32:18.845+00	8.0	75.93427	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
403	29	2015-12-22 16:32:33.85+00	8.0	75.76672	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
404	29	2015-12-22 16:32:48.858+00	8.0	75.50338	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
405	29	2015-12-22 16:33:04.83+00	12.0	75.03023	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
406	29	2015-12-22 16:33:19.857+00	6.0	74.45409	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
407	29	2015-12-22 16:33:35.85+00	8.0	73.76765	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
408	29	2015-12-22 16:33:50.862+00	8.0	73.16711	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
409	29	2015-12-22 16:34:05.867+00	8.0	72.67265	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
410	29	2015-12-22 16:34:21.843+00	12.0	72.32136	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
411	29	2015-12-22 16:34:36.848+00	8.0	72.00974	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
412	29	2015-12-22 16:34:52.859+00	8.0	71.58588	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
413	29	2015-12-22 18:16:23.32+00	32.0	56.18089	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
414	29	2015-12-22 18:21:40.283+00	32.0	92.94215	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
415	29	2015-12-22 18:26:41.484+00	32.0	20.95719	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
416	29	2015-12-22 18:36:41.518+00	24.0	-21.08389	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
417	29	2015-12-22 18:46:42.527+00	32.0	91.37353	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
418	29	2015-12-22 18:56:40.473+00	32.0	60.97258	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
419	29	2015-12-22 19:11:40.209+00	48.0	59.03462	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
420	29	2015-12-22 19:16:40.523+00	48.0	58.00333	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
421	29	2015-12-22 19:26:40.005+00	24.0	48.13316	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
422	29	2015-12-22 19:31:42.828+00	16.0	66.78339	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
423	29	2015-12-22 19:36:43.093+00	32.0	1.15085	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
424	29	2015-12-22 19:41:44.97+00	24.0	-18.28673	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
425	29	2015-12-22 19:51:48.991+00	48.0	95.00512	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
426	29	2015-12-22 20:11:44.446+00	32.0	96.63160	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
427	29	2015-12-22 20:16:46.23+00	48.0	64.96918	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
428	29	2015-12-22 20:21:48.654+00	48.0	57.84803	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
429	29	2015-12-23 14:11:33.957+00	8.0	59.62280	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
430	29	2015-12-23 14:46:49.497+00	32.0	46.40158	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
431	29	2015-12-23 14:51:52.435+00	32.0	55.47532	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
432	29	2015-12-23 14:54:15.425+00	32.0	24.64706	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
433	29	2015-12-24 17:47:27.523+00	33.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
434	29	2015-12-24 17:48:23.141+00	24.0	-61.01693	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
435	29	2015-12-24 17:48:53.189+00	48.0	64.97853	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
436	29	2015-12-24 17:49:24.14+00	12.0	58.09876	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
437	29	2015-12-24 17:49:56.329+00	32.0	2.99484	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
438	29	2015-12-24 17:50:54.167+00	48.0	65.26011	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
439	29	2015-12-24 17:51:51.283+00	28.4	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
440	29	2015-12-24 17:52:39.669+00	26.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
441	29	2015-12-25 12:35:31.714+00	22.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
442	29	2015-12-25 12:36:49.506+00	48.0	28.66817	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
443	29	2015-12-25 12:37:50.975+00	32.0	-4.76729	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
444	29	2015-12-25 12:38:50.552+00	48.0	41.59878	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
445	29	2015-12-25 12:39:47.665+00	32.0	86.95091	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
446	29	2015-12-25 12:40:48.109+00	16.0	66.32393	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
447	29	2015-12-25 12:41:18.218+00	16.0	58.59505	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
448	29	2015-12-25 12:42:15.62+00	24.0	46.49828	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
449	29	2015-12-25 12:42:46.191+00	32.0	67.85534	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
450	29	2015-12-25 12:43:18.14+00	16.0	57.02107	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
451	29	2015-12-25 12:44:15.299+00	48.0	83.80691	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
452	29	2015-12-25 12:44:47.973+00	24.0	96.44309	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
453	29	2015-12-25 12:45:45.063+00	32.0	52.93426	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
454	29	2015-12-25 12:46:16.04+00	32.0	75.86124	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
455	29	2015-12-25 12:47:13.587+00	32.0	63.52615	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
456	29	2015-12-25 12:47:44.513+00	16.0	83.49238	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
457	29	2015-12-25 12:48:46.357+00	32.0	69.47086	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
458	29	2015-12-25 12:49:45.125+00	32.0	75.41890	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
459	29	2015-12-25 12:50:16.395+00	48.0	31.37599	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
460	29	2015-12-25 12:50:48.389+00	32.0	51.64155	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
461	29	2015-12-25 12:51:48.614+00	24.0	73.57741	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
462	29	2015-12-25 12:52:48+00	24.0	34.15645	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
463	29	2015-12-25 12:53:19.153+00	24.0	68.59747	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
464	29	2015-12-26 11:10:41.908+00	30.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
465	29	2015-12-26 11:12:54.195+00	32.0	61.49048	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
466	29	2015-12-26 11:18:52.077+00	48.0	51.05518	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
467	29	2015-12-26 11:20:55.424+00	32.0	46.82989	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
468	29	2015-12-26 11:24:53.012+00	48.0	61.21843	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
469	29	2015-12-26 11:30:55.512+00	32.0	57.95098	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
470	29	2015-12-26 11:34:54.31+00	48.0	54.45792	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
471	29	2015-12-26 11:42:55.297+00	48.0	8.35631	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
472	29	2015-12-26 11:44:57.306+00	48.0	37.73977	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
473	29	2015-12-26 11:47:03.156+00	24.0	41.68557	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
474	29	2015-12-26 11:52:55.925+00	48.0	61.45026	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
475	29	2015-12-26 11:56:56.181+00	32.0	47.46818	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
476	29	2015-12-26 12:00:56.466+00	32.0	57.52032	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
477	29	2015-12-26 12:06:56.269+00	8.0	48.48909	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
478	29	2015-12-26 12:10:54.362+00	32.0	39.61931	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
479	29	2015-12-26 12:14:54.321+00	48.0	32.17470	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
480	29	2015-12-26 12:18:52.278+00	32.0	38.46262	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
481	29	2015-12-26 12:20:52.506+00	24.0	66.82124	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
482	29	2015-12-26 12:22:53.686+00	32.0	44.62138	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
483	29	2015-12-26 12:26:54.293+00	24.0	87.73309	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
484	29	2015-12-26 12:30:52.174+00	32.0	41.60340	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
485	29	2015-12-26 12:32:54.589+00	48.0	47.86173	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
486	29	2015-12-26 12:40:52.259+00	24.0	60.40864	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
487	29	2015-12-26 12:42:52.299+00	32.0	56.73466	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
488	29	2015-12-26 12:44:52.677+00	32.0	43.75743	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
489	29	2015-12-26 12:46:53.997+00	16.0	72.95448	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
490	29	2015-12-26 12:50:52.06+00	16.0	56.58908	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
491	29	2015-12-26 12:52:52.251+00	32.0	44.38452	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
492	29	2015-12-26 12:54:52.422+00	24.0	49.63868	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
493	29	2015-12-26 12:58:52.397+00	24.0	51.17323	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
494	29	2015-12-26 13:02:53.008+00	32.0	91.43155	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
495	29	2015-12-26 13:08:52.15+00	32.0	78.74835	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
496	29	2015-12-26 13:12:52.183+00	16.0	46.42150	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
497	29	2015-12-26 13:16:52.211+00	48.0	72.36871	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
498	29	2015-12-26 13:18:52.429+00	48.0	20.82112	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
499	29	2015-12-26 13:20:54.528+00	48.0	41.50605	10.7	69.95966	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
500	29	2015-12-26 13:24:52.586+00	48.0	72.64179	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
501	29	2015-12-26 13:28:55.374+00	48.0	39.97746	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
502	29	2015-12-26 13:30:57.193+00	16.0	44.70972	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
503	29	2015-12-26 13:34:56.358+00	12.0	48.06781	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
504	29	2015-12-27 18:58:34.133+00	22.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
505	29	2015-12-27 18:58:49.27+00	16.0	60.68766	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
506	29	2015-12-27 18:59:04.3+00	12.0	63.45384	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
507	29	2015-12-27 18:59:19.357+00	12.0	62.04665	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
508	29	2015-12-27 18:59:35.338+00	12.0	59.71859	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
509	29	2015-12-27 18:59:51.336+00	6.0	58.86255	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
510	29	2015-12-27 19:00:06.415+00	6.0	56.75504	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
511	29	2015-12-27 19:00:22.631+00	8.0	55.17710	2.9	37.29703	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
512	29	2015-12-27 19:00:38.233+00	12.0	52.25099	3.2	55.66007	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
513	29	2015-12-27 19:00:53.915+00	8.0	44.98589	12.9	44.96957	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
514	29	2015-12-27 19:01:10.214+00	8.0	49.85167	7.2	140.19835	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
515	29	2015-12-27 19:01:25.946+00	8.0	50.02886	9.9	160.66223	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
516	29	2015-12-27 19:01:42.58+00	12.0	50.34922	11.8	135.72716	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
517	29	2015-12-27 19:01:58.128+00	12.0	42.33200	12.8	165.12656	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
518	29	2015-12-27 19:02:13.242+00	12.0	38.89161	8.3	87.55173	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
519	29	2015-12-27 19:02:28.254+00	12.0	35.65596	14.3	75.60296	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
520	29	2015-12-27 19:02:43.331+00	8.0	44.74694	12.0	74.01862	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
521	29	2015-12-27 19:02:59.264+00	8.0	53.31741	6.9	102.88773	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
522	29	2015-12-27 19:03:15.286+00	8.0	49.78724	12.3	94.52775	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
523	29	2015-12-27 19:03:31.211+00	8.0	41.27602	10.2	47.78511	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
524	29	2015-12-27 19:03:46.948+00	12.0	39.57319	14.6	18.74424	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
525	29	2015-12-27 19:04:01.966+00	12.0	35.66655	14.3	16.37471	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
526	29	2015-12-27 19:04:17.224+00	16.0	25.47463	10.2	172.61760	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
527	29	2015-12-27 19:04:32.32+00	12.0	25.93860	18.9	131.27495	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
528	29	2015-12-27 19:04:48.311+00	12.0	23.74626	22.7	75.76370	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
529	29	2015-12-27 19:05:04.268+00	12.0	19.83653	21.9	61.59423	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
530	29	2015-12-27 19:05:20.293+00	12.0	28.74027	19.1	63.53622	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
531	29	2015-12-27 19:05:51.306+00	12.0	21.61056	15.0	98.28293	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
532	29	2015-12-27 19:06:06.335+00	8.0	27.16256	19.3	79.00328	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
533	29	2015-12-27 19:06:22.556+00	12.0	29.39015	18.5	73.39742	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
534	29	2015-12-27 19:06:38.301+00	8.0	33.49453	16.1	62.79849	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
535	29	2015-12-27 19:06:53.342+00	8.0	30.22892	15.8	50.60549	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
536	29	2015-12-27 19:07:09.29+00	6.0	28.85266	0.0	50.75093	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
537	29	2015-12-27 19:07:24.302+00	8.0	21.14451	10.9	62.42473	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
538	29	2015-12-27 19:07:40.274+00	8.0	25.86852	12.4	67.27278	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
539	29	2015-12-27 19:07:56.293+00	12.0	28.79032	14.0	35.21406	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
540	29	2015-12-27 19:08:12.297+00	8.0	28.35691	10.7	204.87569	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
541	29	2015-12-27 19:08:28.332+00	16.0	28.48543	6.0	257.91595	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
542	29	2015-12-27 19:08:44.326+00	12.0	27.40632	8.3	231.17052	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
543	29	2015-12-27 19:09:00.416+00	12.0	28.01915	4.8	226.13675	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
544	29	2015-12-27 19:09:16.287+00	8.0	27.83067	0.0	44.78188	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
545	29	2015-12-27 19:09:31.333+00	8.0	27.87499	0.0	30.24948	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
546	29	2015-12-27 19:09:47.276+00	6.0	27.88807	0.0	30.24948	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
547	29	2015-12-27 19:10:03.31+00	8.0	27.90675	0.0	30.24948	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
548	29	2015-12-27 19:10:19.279+00	16.0	28.04763	0.0	342.08610	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
549	29	2015-12-27 19:10:35.233+00	16.0	27.46269	4.7	121.69164	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
550	29	2015-12-27 19:10:50.33+00	24.0	28.07331	6.6	55.70721	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
551	29	2015-12-27 19:11:06.342+00	12.0	26.82648	3.0	63.58348	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
552	29	2015-12-27 19:11:22.325+00	12.0	25.70874	10.1	29.10553	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
553	29	2015-12-27 19:11:38.365+00	16.0	25.99204	9.6	243.23288	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
554	29	2015-12-27 19:11:54.35+00	24.0	26.99503	9.3	251.15445	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
555	29	2015-12-27 19:12:10.325+00	16.0	26.15957	0.0	239.10196	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
556	29	2015-12-27 19:12:26.196+00	16.0	25.65520	9.0	245.12622	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
557	29	2015-12-27 19:12:42.287+00	16.0	25.45186	5.1	240.38004	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
558	29	2015-12-27 19:12:57.315+00	24.0	26.10557	9.3	233.88603	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
559	29	2015-12-27 19:13:13.526+00	12.0	23.98460	0.0	203.47646	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
560	29	2015-12-27 19:13:29.167+00	24.0	27.53084	15.9	243.75533	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
561	29	2015-12-27 19:13:44.45+00	24.0	24.10330	19.8	250.48195	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
562	29	2015-12-27 19:14:00.32+00	48.0	28.44375	16.8	252.91609	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
563	29	2015-12-27 19:14:16.281+00	32.0	28.22846	7.5	235.32870	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
564	29	2015-12-27 19:14:47.156+00	32.0	30.57108	6.4	259.05948	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
565	29	2015-12-27 19:15:02.305+00	24.0	29.90948	15.8	253.28413	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
566	29	2015-12-27 19:15:18.292+00	16.0	32.19093	20.1	243.99867	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
567	29	2015-12-27 19:15:33.323+00	24.0	32.48703	20.2	244.07164	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
568	29	2015-12-27 19:15:49.284+00	24.0	35.02841	20.4	271.57272	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
569	29	2015-12-27 19:16:04.288+00	16.0	33.78060	17.0	320.37485	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
570	29	2015-12-27 19:16:20.386+00	16.0	32.49971	8.6	258.74924	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
571	29	2015-12-27 19:16:36.14+00	32.0	38.53527	14.9	198.79997	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
572	29	2015-12-27 19:16:51.32+00	16.0	46.87510	7.9	195.76926	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
573	29	2015-12-27 19:17:07.32+00	16.0	46.65443	11.8	273.37045	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
574	29	2015-12-27 19:17:23.288+00	16.0	52.38820	12.0	274.39954	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
575	29	2015-12-27 19:17:38.319+00	16.0	56.95247	11.2	270.36542	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
576	29	2015-12-27 19:17:53.34+00	24.0	56.76741	12.8	252.48685	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
577	29	2015-12-27 19:18:09.228+00	32.0	51.52308	11.8	252.65186	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
578	29	2015-12-27 19:18:24.275+00	16.0	44.47821	13.3	305.89627	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
579	29	2015-12-27 19:18:40.282+00	16.0	47.83183	11.7	8.00156	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
580	29	2015-12-27 19:18:56.256+00	48.0	55.54773	8.6	258.31003	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
581	29	2015-12-27 19:19:11.325+00	24.0	57.39480	11.9	342.92514	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
582	29	2015-12-27 19:19:27.371+00	12.0	56.66677	8.0	268.48404	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
583	29	2015-12-27 19:19:43.355+00	24.0	54.73785	12.4	235.77750	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
584	29	2015-12-27 19:19:59.215+00	12.0	53.35223	2.7	175.58206	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
585	29	2015-12-27 19:20:14.32+00	12.0	53.18863	0.0	232.65341	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
586	29	2015-12-27 19:20:30.34+00	6.0	53.13678	0.0	213.50432	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
587	29	2015-12-27 19:20:46.301+00	4.0	52.73538	0.0	213.50432	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
588	29	2015-12-27 19:21:17.23+00	6.0	52.36872	0.0	213.50432	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
589	29	2015-12-27 19:21:33.2+00	4.0	52.17041	0.0	213.50432	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
590	29	2015-12-27 19:21:48.67+00	8.0	52.16385	0.0	213.50432	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
591	29	2015-12-27 19:22:04.255+00	8.0	52.19759	0.0	213.50432	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
592	29	2015-12-27 19:22:19.395+00	8.0	52.23678	0.0	213.50432	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
593	29	2015-12-27 19:22:35.347+00	8.0	52.43679	0.0	213.50432	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
594	29	2015-12-27 19:22:51.341+00	8.0	52.54030	0.0	213.50432	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
595	29	2015-12-27 19:23:06.41+00	12.0	52.75093	0.0	213.50432	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
596	29	2015-12-27 19:23:21.505+00	8.0	52.80119	0.0	213.50432	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
597	29	2015-12-27 19:23:37.428+00	12.0	52.83962	0.0	213.50432	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
598	29	2015-12-27 19:23:53.266+00	8.0	52.82950	0.0	213.50432	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
599	29	2015-12-27 19:24:08.444+00	8.0	52.70419	0.0	213.50432	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
600	29	2015-12-27 19:24:24.211+00	12.0	52.63033	0.0	213.50432	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
601	29	2015-12-27 19:24:39.378+00	8.0	52.55034	0.0	213.50432	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
602	29	2015-12-27 19:24:55.466+00	8.0	51.67596	0.0	130.26242	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
603	29	2015-12-27 19:25:11.426+00	12.0	50.87975	0.0	174.55066	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
604	29	2015-12-27 19:25:27.386+00	12.0	51.23303	0.0	130.62035	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
605	29	2015-12-27 19:25:43.328+00	8.0	50.88473	0.0	282.67868	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
606	29	2015-12-27 19:25:58.38+00	12.0	50.60935	0.0	273.56146	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
607	29	2015-12-27 19:26:13.404+00	16.0	50.68444	0.0	128.82123	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
608	29	2015-12-27 19:26:29.311+00	32.0	50.76697	0.0	128.82123	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
609	29	2015-12-27 19:26:44.345+00	12.0	50.42823	0.0	128.82123	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
610	29	2015-12-27 19:26:59.424+00	12.0	50.05824	0.0	128.82123	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
611	29	2015-12-27 19:27:15.371+00	16.0	50.03130	0.0	128.82123	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
612	29	2015-12-27 19:27:31.39+00	12.0	50.10886	0.0	128.82123	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
613	29	2015-12-27 19:27:46.474+00	12.0	50.20060	0.0	128.82123	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
614	29	2015-12-27 19:28:02.245+00	12.0	50.01968	0.0	128.82123	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
615	29	2015-12-27 19:28:17.284+00	8.0	49.88567	0.0	128.82123	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
616	29	2015-12-27 19:28:32.399+00	8.0	49.85743	0.0	128.82123	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
617	29	2015-12-27 19:28:48.23+00	16.0	49.91802	0.0	128.82123	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
618	29	2015-12-27 19:29:03.405+00	8.0	49.89310	0.0	128.82123	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
619	29	2015-12-27 19:29:19.463+00	8.0	50.10871	0.0	128.82123	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
620	29	2015-12-27 19:29:35.426+00	8.0	50.46055	0.0	128.82123	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
621	29	2015-12-27 19:29:51.284+00	24.0	51.12246	0.0	128.82123	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
622	29	2015-12-27 19:30:06.299+00	16.0	52.20332	2.9	234.32622	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
623	29	2015-12-27 19:30:21.3+00	12.0	51.68419	2.0	177.58028	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
624	29	2015-12-27 19:30:36.321+00	24.0	43.37743	0.0	203.40420	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
625	29	2015-12-27 19:30:52.273+00	16.0	44.01061	1.8	186.66296	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
626	29	2015-12-27 19:31:07.37+00	12.0	44.03626	0.0	186.66296	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
627	29	2015-12-27 19:31:22.62+00	12.0	44.15576	0.0	186.66296	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
628	29	2015-12-27 19:31:38.353+00	12.0	44.58693	0.0	186.66296	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
629	29	2015-12-27 19:31:54.315+00	12.0	44.90333	0.0	186.66296	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
630	29	2015-12-27 19:32:09.351+00	12.0	44.93216	0.0	186.66296	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
631	29	2015-12-27 19:32:24.356+00	12.0	44.93433	0.0	186.66296	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
632	29	2015-12-27 19:32:40.147+00	16.0	45.49559	3.3	161.05066	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
633	29	2015-12-27 19:32:55.363+00	24.0	47.59728	5.5	170.79306	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
634	29	2015-12-27 19:33:11.636+00	16.0	43.35880	2.8	173.93713	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
635	29	2015-12-27 19:33:27.385+00	16.0	38.01938	0.0	168.47680	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
636	29	2015-12-27 19:33:43.35+00	16.0	37.98977	0.0	168.47680	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
637	29	2015-12-27 19:33:59.267+00	16.0	37.91713	0.0	139.15237	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
638	29	2015-12-27 19:34:14.348+00	12.0	38.69164	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
639	29	2015-12-27 19:34:30.203+00	16.0	38.78814	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
640	29	2015-12-27 19:34:45.246+00	8.0	38.94848	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
641	29	2015-12-27 19:35:00.52+00	8.0	39.12641	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
642	29	2015-12-27 19:35:16.257+00	12.0	38.94560	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
643	29	2015-12-27 19:35:31.33+00	12.0	38.86179	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
644	29	2015-12-27 19:35:47.314+00	12.0	38.69490	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
645	29	2015-12-27 19:36:03.31+00	8.0	38.84739	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
646	29	2015-12-27 19:36:19.328+00	8.0	39.13962	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
647	29	2015-12-27 19:36:34.349+00	12.0	39.41392	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
648	29	2015-12-27 19:36:50.256+00	12.0	39.49723	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
649	29	2015-12-27 19:37:05.335+00	8.0	39.60170	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
650	29	2015-12-27 19:37:21.341+00	8.0	39.71822	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
651	29	2015-12-27 19:37:36.372+00	8.0	40.13572	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
652	29	2015-12-27 19:37:52.384+00	16.0	40.35423	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
653	29	2015-12-27 19:38:08.308+00	8.0	40.77082	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
654	29	2015-12-27 19:38:23.436+00	12.0	41.39934	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
655	29	2015-12-27 19:38:39.307+00	16.0	41.89282	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
656	29	2015-12-27 19:38:54.368+00	16.0	42.40798	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
657	29	2015-12-27 19:39:10.263+00	16.0	42.79907	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
658	29	2015-12-27 19:39:26.304+00	12.0	43.33110	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
659	29	2015-12-27 19:39:41.369+00	12.0	43.45848	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
660	29	2015-12-27 19:39:57.37+00	8.0	43.96554	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
661	29	2015-12-27 19:40:12.419+00	8.0	44.79893	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
662	29	2015-12-27 19:40:28.177+00	8.0	45.68182	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
663	29	2015-12-27 19:40:43.288+00	8.0	46.31176	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
664	29	2015-12-27 19:40:58.348+00	12.0	46.86580	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
665	29	2015-12-27 19:41:14.298+00	12.0	46.90165	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
666	29	2015-12-27 19:41:29.35+00	8.0	46.85236	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
667	29	2015-12-27 19:41:45.342+00	12.0	46.50966	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
668	29	2015-12-27 19:42:00.56+00	12.0	45.74682	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
669	29	2015-12-27 19:42:16.345+00	12.0	45.02172	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
670	29	2015-12-27 19:42:32.388+00	12.0	45.04919	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
671	29	2015-12-27 19:42:48.368+00	12.0	45.34910	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
672	29	2015-12-27 19:43:03.552+00	16.0	45.86478	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
673	29	2015-12-27 19:43:19.338+00	12.0	46.16041	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
674	29	2015-12-27 19:43:34.434+00	12.0	46.71217	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
675	29	2015-12-27 19:43:50.375+00	8.0	47.07751	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
676	29	2015-12-27 19:44:05.404+00	12.0	47.55789	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
677	29	2015-12-27 19:44:21.381+00	16.0	48.41185	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
678	29	2015-12-27 19:44:37.339+00	16.0	48.72405	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
679	29	2015-12-27 19:44:52.361+00	16.0	48.87465	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
680	29	2015-12-27 19:45:07.421+00	16.0	48.75277	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
681	29	2015-12-27 19:45:22.451+00	8.0	48.70481	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
682	29	2015-12-27 19:45:38.467+00	6.0	48.48373	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
683	29	2015-12-27 19:45:53.58+00	8.0	48.07052	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
684	29	2015-12-27 19:46:09.415+00	8.0	47.48498	0.0	137.01091	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
685	29	2015-12-27 19:46:25.397+00	12.0	46.71521	0.0	351.83124	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
686	29	2015-12-27 19:46:40.595+00	12.0	49.62165	6.7	104.03716	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
687	29	2015-12-27 19:46:56.4+00	16.0	65.34327	0.0	97.43012	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
688	29	2015-12-27 19:47:11.415+00	24.0	66.46587	0.0	92.91924	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
689	29	2015-12-27 19:47:27.325+00	32.0	55.69388	25.2	316.50378	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
690	29	2015-12-27 19:47:45.491+00	48.0	96.01053	19.4	318.69420	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
691	29	2015-12-27 19:48:01.189+00	48.0	66.61261	0.0	317.03530	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
692	29	2015-12-27 19:48:16.361+00	48.0	74.72964	9.0	323.94055	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
693	29	2015-12-27 19:49:37.34+00	24.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
694	29	2015-12-28 13:03:34.778+00	32.0	43.89668	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
695	29	2015-12-28 13:05:56.517+00	48.0	47.73327	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
696	29	2015-12-28 13:09:57.725+00	32.0	22.69975	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
697	29	2015-12-28 13:11:59.296+00	32.0	-14.82987	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
698	29	2015-12-28 13:15:57.461+00	32.0	44.07845	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
699	29	2015-12-28 13:19:59.522+00	32.0	16.56501	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
700	29	2015-12-28 13:23:57.438+00	32.0	85.30985	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
701	29	2015-12-28 13:25:59.971+00	32.0	37.33904	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
702	29	2015-12-28 13:29:57.544+00	32.0	96.42571	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
703	29	2015-12-28 13:34:00.308+00	32.0	62.08532	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
704	29	2015-12-28 13:37:59.716+00	32.0	0.09263	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
705	29	2015-12-28 13:41:55.302+00	32.0	37.41966	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
706	29	2015-12-28 13:43:58.592+00	48.0	-49.38285	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
707	29	2015-12-28 13:47:56.547+00	32.0	34.11043	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
708	29	2015-12-28 13:49:57.416+00	48.0	34.06884	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
709	29	2015-12-28 13:53:58.417+00	48.0	62.67263	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
710	29	2015-12-28 14:03:57.234+00	48.0	55.82478	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
711	29	2015-12-28 14:07:55.448+00	48.0	79.32532	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
712	29	2015-12-28 14:09:58.16+00	12.0	13.75795	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
713	29	2015-12-28 14:13:55.496+00	48.0	50.23887	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
714	29	2015-12-28 14:21:55.506+00	48.0	43.02741	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
715	29	2015-12-28 14:23:58.166+00	32.0	53.03992	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
716	29	2015-12-28 14:31:58.553+00	32.0	54.99439	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
717	29	2015-12-28 14:35:59.259+00	16.0	31.03718	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
718	29	2015-12-28 14:45:59.775+00	32.0	70.35561	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
719	29	2015-12-28 14:51:57.278+00	48.0	29.25918	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
720	29	2015-12-28 14:55:58.378+00	32.0	73.13023	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
721	29	2015-12-28 15:00:01.229+00	48.0	46.37135	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
722	29	2015-12-28 15:04:01.903+00	32.0	77.80850	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
723	29	2015-12-28 15:06:03.35+00	24.0	67.17477	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
724	29	2015-12-28 15:07:17.746+00	12.0	33.30769	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
725	29	2015-12-29 10:56:12.532+00	48.0	-19.23927	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
726	29	2015-12-29 11:00:25.276+00	24.0	9.14863	19.2	175.75208	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
727	29	2015-12-29 11:04:05.408+00	16.0	22.53330	17.1	86.47602	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
728	29	2015-12-29 11:08:06.774+00	12.0	36.86933	29.1	40.41695	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
729	29	2015-12-29 11:14:05.454+00	24.0	17.36401	25.2	119.05540	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
730	29	2015-12-29 11:18:05.412+00	16.0	50.99930	28.5	159.00995	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
731	29	2015-12-29 11:20:05.415+00	24.0	100.88471	27.4	106.13985	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
732	29	2015-12-29 11:22:05.434+00	32.0	147.40341	13.9	154.09792	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
733	29	2015-12-29 11:28:05.368+00	24.0	203.69566	0.0	114.89567	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
734	29	2015-12-29 11:32:13.578+00	32.0	234.30661	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
735	29	2015-12-29 11:38:05.904+00	24.0	159.11835	3.2	64.46730	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
736	29	2015-12-29 11:40:13.521+00	48.0	77.04108	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
737	29	2015-12-29 11:44:11.299+00	64.0	47.90634	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
738	29	2015-12-29 11:48:04.901+00	48.0	75.34510	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
739	29	2015-12-29 11:51:57.211+00	16.0	58.57417	31.6	184.07329	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
740	29	2015-12-29 11:54:11.305+00	48.0	127.77965	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
741	29	2015-12-29 11:57:27.053+00	64.0	139.11833	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
742	29	2015-12-29 11:59:43.561+00	48.0	82.18646	28.3	165.35275	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
743	29	2015-12-29 12:08:22.556+00	16.0	38.81181	23.0	174.32205	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
744	29	2015-12-29 12:12:23.608+00	24.0	77.88330	26.5	276.27790	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
745	29	2015-12-31 11:32:38.92+00	24.0	38.25745	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
746	29	2015-12-31 11:35:11.323+00	48.0	86.08278	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
747	29	2015-12-31 11:39:07.496+00	32.0	61.11193	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
748	29	2015-12-31 11:43:06.881+00	32.0	63.07462	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
749	29	2015-12-31 14:01:07.389+00	32.0	32.12226	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
750	29	2015-12-31 14:03:12.16+00	32.0	67.52602	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
751	29	2015-12-31 14:07:10.709+00	32.0	34.73475	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
752	29	2015-12-31 14:23:07.321+00	48.0	63.40863	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
753	29	2015-12-31 14:29:08.109+00	48.0	53.12887	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
754	29	2015-12-31 18:02:51+00	\N	84.71484	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
755	29	2015-12-31 18:03:28+00	\N	77.93015	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
756	29	2015-12-31 18:04:07+00	\N	77.30872	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
757	29	2015-12-31 18:04:46+00	\N	104.98045	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
758	29	2015-12-31 18:05:26+00	\N	90.83052	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
759	29	2015-12-31 18:06:04+00	\N	82.58931	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
760	29	2015-12-31 18:06:44+00	\N	119.70312	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
761	29	2015-12-31 18:07:22+00	\N	48.11849	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
762	29	2015-12-31 18:07:52+00	\N	93.50633	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
763	29	2015-12-31 18:08:29+00	\N	129.78873	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
764	29	2015-12-31 18:09:11+00	\N	96.79946	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
765	29	2015-12-31 18:11:20+00	\N	81.27746	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
766	29	2015-12-31 18:12:15+00	\N	87.35889	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
767	29	2015-12-31 18:14:24+00	\N	97.62527	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
768	29	2015-12-31 18:16:30+00	\N	107.43945	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
769	29	2015-12-31 18:17:18+00	\N	77.87727	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
770	29	2015-12-31 18:22:23+00	\N	99.93629	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
771	29	2015-12-31 18:27:38+00	\N	114.63865	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
772	29	2015-12-31 18:32:42+00	\N	67.70257	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
773	29	2015-12-31 18:37:51+00	\N	136.76742	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
774	29	2015-12-31 18:42:59+00	\N	96.36082	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
775	29	2015-12-31 18:48:07+00	\N	95.98762	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
776	29	2015-12-31 18:53:14+00	\N	132.58105	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
777	29	2015-12-31 18:58:24+00	\N	120.23367	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
778	29	2015-12-31 19:03:34+00	\N	151.17033	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
779	29	2015-12-31 19:08:43+00	\N	95.35309	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
780	29	2015-12-31 19:15:17+00	\N	102.21885	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
781	29	2015-12-31 19:20:31+00	\N	86.99603	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
782	29	2015-12-31 19:25:48+00	\N	106.56925	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
783	29	2015-12-31 19:31:08+00	\N	100.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
784	29	2015-12-31 19:36:23+00	\N	94.57875	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
785	29	2015-12-31 19:42:12+00	\N	103.11874	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
786	29	2015-12-31 19:47:30+00	\N	91.06199	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
787	29	2015-12-31 19:52:50+00	\N	177.73153	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
788	29	2015-12-31 19:58:05+00	\N	113.28399	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
789	29	2015-12-31 20:03:20+00	\N	120.21846	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
790	29	2015-12-31 20:08:32+00	\N	143.60157	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
791	29	2015-12-31 20:13:42+00	\N	167.69812	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
792	29	2015-12-31 20:18:56+00	\N	97.97532	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
793	29	2015-12-31 20:24:00+00	\N	119.07131	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
794	29	2015-12-31 20:29:06+00	\N	118.99351	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
795	29	2015-12-31 20:34:21+00	\N	102.21700	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
796	29	2015-12-31 20:39:31+00	\N	68.26466	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
797	29	2016-01-01 10:13:56.259+00	23.6	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
798	29	2016-01-01 10:15:14+00	\N	103.72891	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
799	29	2016-01-01 10:16:26.256+00	64.0	54.82844	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
800	29	2016-01-01 10:18:15+00	\N	95.64636	0.7	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
801	29	2016-01-01 10:18:27.125+00	8.0	49.18659	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
802	29	2016-01-01 10:20:42.337+00	48.0	60.09279	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
803	29	2016-01-01 10:21:29+00	\N	115.20720	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
804	29	2016-01-01 10:24:43.052+00	32.0	83.31264	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
805	29	2016-01-01 10:27:02+00	\N	105.14166	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
806	29	2016-01-01 10:38:37+00	\N	88.85650	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
807	29	2016-01-01 10:38:55+00	\N	119.35534	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
808	29	2016-01-01 10:39:10+00	\N	106.23346	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
809	29	2016-01-01 10:39:25+00	\N	105.70174	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
810	29	2016-01-01 10:39:40+00	\N	105.55708	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
811	29	2016-01-01 10:39:55+00	\N	105.41982	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
812	29	2016-01-01 10:40:10+00	\N	105.18460	0.8	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
813	29	2016-01-01 10:40:25+00	\N	104.05629	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
814	29	2016-01-01 10:40:44+00	\N	105.24868	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
815	29	2016-01-01 10:41:02+00	\N	106.79251	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
816	29	2016-01-01 10:41:20+00	\N	107.32100	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
817	29	2016-01-01 10:41:39+00	\N	107.02503	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
818	29	2016-01-01 10:41:54+00	\N	104.95693	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
819	29	2016-01-01 10:42:15+00	\N	98.21052	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
820	29	2016-01-01 10:42:33+00	\N	101.56217	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
821	29	2016-01-01 10:42:51+00	\N	100.40762	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
822	29	2016-01-01 10:43:21+00	\N	97.90541	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
823	29	2016-01-01 10:43:39+00	\N	97.42490	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
824	29	2016-01-01 10:44:07+00	\N	95.40940	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
825	29	2016-01-01 10:44:25+00	\N	93.69285	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
826	29	2016-01-01 10:44:43+00	\N	94.46699	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
827	29	2016-01-01 10:45:01+00	\N	92.87899	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
828	29	2016-01-01 10:45:19+00	\N	91.58654	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
829	29	2016-01-01 10:45:37+00	\N	90.64891	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
830	29	2016-01-01 10:45:55+00	\N	87.15052	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
831	29	2016-01-01 10:46:13+00	\N	88.55298	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
832	29	2016-01-01 10:46:28+00	\N	88.36182	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
833	29	2016-01-01 10:46:43+00	\N	88.10625	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
834	29	2016-01-01 10:46:58+00	\N	88.76196	0.7	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
835	29	2016-01-01 10:47:13+00	\N	90.14410	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
836	29	2016-01-01 10:47:28+00	\N	89.66119	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
837	29	2016-01-01 10:47:43+00	\N	88.92446	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
838	29	2016-01-01 10:47:58+00	\N	87.84929	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
839	29	2016-01-01 10:48:13+00	\N	85.82938	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
840	29	2016-01-01 10:48:27+00	\N	84.25893	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
841	29	2016-01-01 10:48:42+00	\N	81.93400	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
842	29	2016-01-01 10:49:02+00	\N	84.49463	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
843	29	2016-01-01 10:49:18+00	\N	84.55841	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
844	29	2016-01-01 10:49:33+00	\N	81.79946	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
845	29	2016-01-01 10:49:48+00	\N	76.25225	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
846	29	2016-01-01 10:50:03+00	\N	74.14014	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
847	29	2016-01-01 10:50:10.06+00	12.0	26.92282	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
848	29	2016-01-01 10:50:18+00	\N	72.84532	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
849	29	2016-01-01 10:50:33+00	\N	72.28451	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
850	29	2016-01-01 10:50:48+00	\N	74.70120	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
851	29	2016-01-01 10:51:03+00	\N	74.05787	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
852	29	2016-01-01 10:51:28+00	\N	83.37496	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
853	29	2016-01-01 10:51:46+00	\N	83.10632	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
854	29	2016-01-01 10:52:01+00	\N	81.44581	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
855	29	2016-01-01 10:52:10.897+00	8.0	33.49028	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
856	29	2016-01-01 10:52:16+00	\N	79.34047	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
857	29	2016-01-01 10:52:31+00	\N	77.24599	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
858	29	2016-01-01 10:52:46+00	\N	76.30943	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
859	29	2016-01-01 10:53:01+00	\N	75.52296	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
860	29	2016-01-01 10:53:16+00	\N	74.00829	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
861	29	2016-01-01 10:53:31+00	\N	73.51501	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
862	29	2016-01-01 10:53:46+00	\N	72.15622	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
863	29	2016-01-01 10:54:01+00	\N	70.97341	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
864	29	2016-01-01 10:54:12.13+00	24.0	21.25564	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
865	29	2016-01-01 10:54:16+00	\N	68.03928	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
866	29	2016-01-01 10:54:31+00	\N	69.98235	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
867	29	2016-01-01 10:55:02+00	\N	77.59098	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
868	29	2016-01-01 10:55:19+00	\N	84.04702	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
869	29	2016-01-01 10:55:34+00	\N	87.15496	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
870	29	2016-01-01 10:55:49+00	\N	87.77798	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
871	29	2016-01-01 10:56:04+00	\N	87.55398	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
872	29	2016-01-01 10:56:12.879+00	16.0	40.94341	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
873	29	2016-01-01 10:56:19+00	\N	87.96684	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
874	29	2016-01-01 10:56:34+00	\N	88.38706	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
875	29	2016-01-01 10:56:49+00	\N	88.35222	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
876	29	2016-01-01 10:57:04+00	\N	88.76730	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
877	29	2016-01-01 10:57:19+00	\N	92.87817	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
878	29	2016-01-01 10:57:34+00	\N	97.38050	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
879	29	2016-01-01 10:57:49+00	\N	97.25747	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
880	29	2016-01-01 10:58:04+00	\N	95.89807	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
881	29	2016-01-01 10:58:13.947+00	12.0	47.75124	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
882	29	2016-01-01 10:58:19+00	\N	93.49800	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
883	29	2016-01-01 10:58:34+00	\N	90.30449	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
884	29	2016-01-01 10:58:49+00	\N	88.77781	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
885	29	2016-01-01 10:59:04+00	\N	85.43896	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
886	29	2016-01-01 10:59:19+00	\N	85.57717	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
887	29	2016-01-01 10:59:34+00	\N	85.76270	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
888	29	2016-01-01 10:59:49+00	\N	86.15657	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
889	29	2016-01-01 11:00:04+00	\N	86.27400	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
890	29	2016-01-01 11:00:14.876+00	16.0	39.28996	1.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
891	29	2016-01-01 11:00:19+00	\N	85.99360	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
892	29	2016-01-01 11:00:34+00	\N	86.65596	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
893	29	2016-01-01 11:00:49+00	\N	87.17948	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
894	29	2016-01-01 11:01:11+00	\N	88.44300	2.2	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
895	29	2016-01-01 11:01:31+00	\N	88.97601	2.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
896	29	2016-01-01 11:03:02.938+00	8.0	94.13098	0.7	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
897	29	2016-01-01 11:04:03.939+00	6.0	86.03655	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
898	29	2016-01-01 11:09:34.33+00	44.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
899	29	2016-01-01 11:09:44.924+00	8.0	55.30780	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
900	29	2016-01-01 11:09:55.933+00	8.0	41.03169	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
901	29	2016-01-01 11:10:05.935+00	8.0	39.20149	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
902	29	2016-01-01 11:10:16.884+00	8.0	39.21520	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
903	29	2016-01-01 11:10:26.898+00	8.0	39.46058	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
904	29	2016-01-01 11:10:37.906+00	8.0	40.67218	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
905	29	2016-01-01 11:10:48.869+00	6.0	40.97235	0.4	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
906	29	2016-01-01 11:10:58.973+00	8.0	41.04717	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
907	29	2016-01-01 11:11:09.872+00	8.0	41.36585	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
908	29	2016-01-01 11:11:19.918+00	8.0	42.41612	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
909	29	2016-01-01 11:11:30.017+00	12.0	43.33885	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
910	29	2016-01-01 11:11:52.877+00	6.0	43.81131	0.6	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
911	29	2016-01-01 11:12:02.882+00	8.0	43.74182	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
912	29	2016-01-01 11:12:13.883+00	12.0	43.72879	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
913	29	2016-01-01 11:12:24.888+00	8.0	43.95903	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
914	29	2016-01-01 11:12:34.896+00	8.0	44.23501	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
915	29	2016-01-01 11:13:11.892+00	8.0	44.62970	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
916	29	2016-01-01 11:13:21.955+00	8.0	45.01395	0.6	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
917	29	2016-01-01 11:13:32.925+00	6.0	45.52939	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
918	29	2016-01-01 11:13:43.906+00	8.0	45.61084	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
919	29	2016-01-01 11:13:54.895+00	12.0	46.05201	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
920	29	2016-01-01 11:14:04.91+00	8.0	46.17645	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
921	29	2016-01-01 11:14:15.911+00	8.0	46.26345	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
922	29	2016-01-01 11:14:25+00	\N	92.90170	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
923	29	2016-01-01 11:14:26.914+00	6.0	46.15984	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
924	29	2016-01-01 11:14:35+00	\N	92.79153	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
925	29	2016-01-01 11:14:37.897+00	8.0	46.06043	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
926	29	2016-01-01 11:14:45+00	\N	92.86856	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
927	29	2016-01-01 11:14:48.897+00	8.0	46.18546	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
928	29	2016-01-01 11:14:55+00	\N	92.92262	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
929	29	2016-01-01 11:14:58.916+00	8.0	46.19397	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
930	29	2016-01-01 11:15:05+00	\N	92.88761	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
931	29	2016-01-01 11:15:09.899+00	6.0	46.03903	0.5	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
932	29	2016-01-01 11:15:15+00	\N	92.73641	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
933	29	2016-01-01 11:15:20.899+00	12.0	46.20415	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
934	29	2016-01-01 11:15:25+00	\N	92.99724	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
935	29	2016-01-01 11:15:31.868+00	8.0	46.39662	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
936	29	2016-01-01 11:15:35+00	\N	93.13539	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
937	29	2016-01-01 11:15:41.879+00	12.0	46.57607	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
938	29	2016-01-01 11:15:51.975+00	8.0	46.79798	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
939	29	2016-01-01 20:14:46.875+00	12.0	63.16280	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
940	29	2016-01-01 20:14:57.77+00	8.0	62.83837	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
941	29	2016-01-01 20:15:07.775+00	16.0	62.55710	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
942	29	2016-01-04 10:31:20+00	\N	102.44797	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
943	29	2016-01-04 10:32:43.225+00	32.0	85.11007	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
944	29	2016-01-04 10:34:48+00	\N	186.31479	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
945	29	2016-01-04 10:34:51.046+00	32.0	139.59479	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
946	29	2016-01-04 10:36:48+00	\N	84.50124	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
947	29	2016-01-04 10:36:51.093+00	16.0	37.78124	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
948	29	2016-01-04 11:34:55.259+00	12.0	47.85017	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
949	29	2016-01-04 11:35:38+00	\N	98.07515	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
950	29	2016-01-04 11:37:46+00	\N	73.90377	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
951	29	2016-01-04 11:39:55+00	\N	151.91796	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
952	29	2016-01-04 11:42:02+00	\N	113.08551	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
953	29	2016-01-04 11:44:08+00	\N	134.96581	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
954	29	2016-01-04 11:46:23+00	\N	89.03582	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
955	29	2016-01-04 11:48:43+00	\N	101.91478	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
956	29	2016-01-04 11:50:58+00	\N	83.06095	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
957	29	2016-01-04 11:53:13+00	\N	42.54574	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
958	29	2016-01-04 11:55:24+00	\N	69.52161	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
959	29	2016-01-04 11:57:40+00	\N	96.51217	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
960	29	2016-01-04 12:00:04+00	\N	97.96144	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
961	29	2016-01-04 12:02:33+00	\N	52.49905	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
962	29	2016-01-04 12:07:43+00	\N	88.93618	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
963	29	2016-01-04 12:09:50+00	\N	113.76635	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
964	29	2016-01-04 12:11:56+00	\N	63.21127	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
965	29	2016-01-04 12:14:03+00	\N	100.91017	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
966	29	2016-01-04 12:16:12+00	\N	102.69606	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
967	29	2016-01-04 12:18:19+00	\N	91.63101	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
968	29	2016-01-04 12:20:24+00	\N	126.48672	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
969	29	2016-01-04 12:22:28+00	\N	81.72165	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
970	29	2016-01-04 12:24:36+00	\N	84.53339	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
971	29	2016-01-04 12:26:41+00	\N	86.35169	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
972	29	2016-01-04 12:28:49+00	\N	94.69863	24.3	190.87131	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
973	29	2016-01-04 12:30:57+00	\N	37.80397	40.2	113.92345	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
974	29	2016-01-04 12:33:04+00	\N	149.53684	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
975	29	2016-01-04 12:35:04+00	\N	70.25115	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
976	29	2016-01-04 12:38:30+00	\N	117.75079	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
977	29	2016-01-04 12:41:18+00	\N	67.92863	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
978	29	2016-01-04 12:43:24+00	\N	73.70491	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
979	29	2016-01-04 12:45:29+00	\N	59.97286	23.2	117.73526	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
980	29	2016-01-04 12:47:34+00	\N	100.62561	22.8	181.21526	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
981	29	2016-01-04 12:49:38+00	\N	137.58123	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
982	29	2016-01-04 12:51:44+00	\N	158.14335	43.5	61.22478	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
983	29	2016-01-04 12:53:46+00	\N	124.44320	19.8	97.15928	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
984	29	2016-01-04 12:55:52+00	\N	163.81118	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
985	29	2016-01-04 12:57:57+00	\N	169.54551	27.6	57.37896	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
986	29	2016-01-04 13:00:02+00	\N	224.36984	26.5	147.97006	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
987	29	2016-01-04 13:02:07+00	\N	230.46612	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
988	29	2016-01-04 13:04:12+00	\N	298.83108	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
989	29	2016-01-04 13:07:45+00	\N	226.93615	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
990	29	2016-01-04 13:09:48+00	\N	217.32303	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
991	29	2016-01-04 13:11:53+00	\N	255.23929	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
992	29	2016-01-04 13:13:55+00	\N	248.30711	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
993	29	2016-01-04 13:15:58+00	\N	249.24375	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
994	29	2016-01-04 13:18:01+00	\N	252.01648	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
995	29	2016-01-04 13:20:04+00	\N	226.69557	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
996	29	2016-01-04 13:22:06+00	\N	243.92635	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
997	29	2016-01-04 13:24:11+00	\N	305.41377	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
998	29	2016-01-04 13:26:20+00	\N	247.10500	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
999	29	2016-01-04 13:28:23+00	\N	279.99140	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1000	29	2016-01-04 13:30:29+00	\N	273.80503	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1001	29	2016-01-04 13:32:34+00	\N	264.89522	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1002	29	2016-01-04 13:34:39+00	\N	267.13610	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1003	29	2016-01-04 13:36:42+00	\N	225.33664	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1004	29	2016-01-04 13:36:42+00	\N	225.33664	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1005	29	2016-01-04 13:38:45+00	\N	227.51379	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1006	29	2016-01-04 13:40:47+00	\N	258.67123	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1007	29	2016-01-04 13:42:50+00	\N	216.51687	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1008	29	2016-01-04 13:44:54+00	\N	235.41350	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1009	29	2016-01-04 13:46:56+00	\N	286.05620	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1010	29	2016-01-04 13:49:02+00	\N	244.69718	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1011	29	2016-01-04 13:51:06+00	\N	233.72783	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1012	29	2016-01-04 13:53:08+00	\N	195.56067	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1013	29	2016-01-04 13:55:13+00	\N	282.87399	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1014	29	2016-01-04 13:57:18+00	\N	236.38981	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1015	29	2016-01-04 13:59:23+00	\N	271.54054	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1016	29	2016-01-04 14:01:27+00	\N	251.58247	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1017	29	2016-01-04 14:03:33+00	\N	233.30807	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1018	29	2016-01-04 14:05:39+00	\N	273.63668	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1019	29	2016-01-04 14:07:44+00	\N	257.12771	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1020	29	2016-01-04 14:09:49+00	\N	279.12454	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1021	29	2016-01-04 14:11:54+00	\N	244.97400	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1022	29	2016-01-04 14:13:59+00	\N	290.74574	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1023	29	2016-01-04 14:16:01+00	\N	214.17355	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1024	29	2016-01-04 14:18:04+00	\N	257.21550	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1025	29	2016-01-04 14:20:12+00	\N	275.23661	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1026	29	2016-01-04 14:22:18+00	\N	222.58593	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1027	29	2016-01-04 14:24:23+00	\N	205.49427	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1028	29	2016-01-04 14:26:25+00	\N	253.67329	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1029	29	2016-01-04 14:28:31+00	\N	247.81950	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1030	29	2016-01-04 14:30:34+00	\N	237.72348	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1031	29	2016-01-04 14:32:39+00	\N	233.65380	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1032	29	2016-01-04 14:34:42+00	\N	202.86176	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1033	29	2016-01-04 14:36:45+00	\N	214.96731	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1034	29	2016-01-04 14:38:50+00	\N	207.54488	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1035	29	2016-01-04 14:40:52+00	\N	191.94246	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1036	29	2016-01-04 14:42:56+00	\N	199.59629	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1037	29	2016-01-04 14:44:59+00	\N	220.77509	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1038	29	2016-01-04 14:47:02+00	\N	218.89741	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1039	29	2016-01-04 14:49:05+00	\N	238.73344	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1040	29	2016-01-04 14:51:08+00	\N	199.66349	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1041	29	2016-01-04 14:53:12+00	\N	262.08432	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1042	29	2016-01-04 14:55:18+00	\N	236.57222	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1043	29	2016-01-04 14:57:23+00	\N	257.06422	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1044	29	2016-01-04 14:59:26+00	\N	270.60444	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1045	29	2016-01-04 15:01:29+00	\N	231.62178	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1046	29	2016-01-04 15:03:33+00	\N	216.08794	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1047	29	2016-01-04 15:05:39+00	\N	226.26481	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1048	29	2016-01-04 15:07:41+00	\N	210.77808	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1049	29	2016-01-04 15:09:45+00	\N	230.56601	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1050	29	2016-01-04 15:11:51+00	\N	239.44472	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1051	29	2016-01-04 15:13:55+00	\N	171.69057	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1052	29	2016-01-04 15:16:00+00	\N	246.14861	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1053	29	2016-01-04 15:18:04+00	\N	237.82735	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1054	29	2016-01-04 15:20:07+00	\N	206.99433	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1055	29	2016-01-04 15:22:09+00	\N	223.15715	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1056	29	2016-01-04 15:24:12+00	\N	217.68707	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1057	29	2016-01-04 15:26:15+00	\N	230.66645	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1058	29	2016-01-04 15:28:19+00	\N	220.72351	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1059	29	2016-01-04 15:30:24+00	\N	196.67872	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1060	29	2016-01-04 15:32:29+00	\N	274.81798	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1061	29	2016-01-04 15:32:29+00	\N	274.81798	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1062	29	2016-01-04 15:34:32+00	\N	215.20088	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1063	29	2016-01-04 15:36:37+00	\N	201.44526	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1064	29	2016-01-04 15:38:40+00	\N	206.94360	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1065	29	2016-01-04 15:40:43+00	\N	190.24880	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1066	29	2016-01-04 15:42:47+00	\N	215.13023	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1067	29	2016-01-04 15:44:50+00	\N	194.43021	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1068	29	2016-01-04 15:46:52+00	\N	142.66752	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1069	29	2016-01-04 15:48:55+00	\N	151.19657	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1070	29	2016-01-04 15:50:59+00	\N	154.09112	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1071	29	2016-01-04 15:53:04+00	\N	165.13690	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1072	29	2016-01-04 15:53:04+00	\N	165.13690	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1073	29	2016-01-04 15:55:07+00	\N	147.13285	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1074	29	2016-01-04 15:57:08+00	\N	186.14003	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1075	29	2016-01-04 15:59:14+00	\N	180.83206	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1076	29	2016-01-04 16:01:16+00	\N	208.96862	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1077	29	2016-01-04 16:03:21+00	\N	244.69379	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1078	29	2016-01-04 16:05:24+00	\N	256.01325	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1079	29	2016-01-04 16:07:26+00	\N	243.18406	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1080	29	2016-01-04 16:07:26+00	\N	243.18406	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1081	29	2016-01-04 16:09:32+00	\N	207.20037	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1082	29	2016-01-04 16:11:33+00	\N	238.25050	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1083	29	2016-01-04 16:13:37+00	\N	229.47497	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1084	29	2016-01-04 16:15:40+00	\N	228.73789	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1085	29	2016-01-04 16:17:42+00	\N	249.81380	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1086	29	2016-01-04 16:19:45+00	\N	226.39725	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1087	29	2016-01-04 16:21:48+00	\N	225.74959	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1088	29	2016-01-04 16:23:50+00	\N	200.82072	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1089	29	2016-01-04 16:23:50+00	\N	200.82072	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1090	29	2016-01-04 16:25:54+00	\N	250.98892	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1091	29	2016-01-04 16:27:56+00	\N	182.84237	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1092	29	2016-01-04 16:29:59+00	\N	218.21863	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1093	29	2016-01-04 16:32:03+00	\N	192.75283	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1094	29	2016-01-04 16:34:11+00	\N	243.65528	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1095	29	2016-01-04 16:36:21+00	\N	431.24809	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1096	29	2016-01-04 16:38:26+00	\N	231.03518	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1097	29	2016-01-04 16:40:30+00	\N	255.32106	19.9	278.08167	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1098	29	2016-01-04 16:42:33+00	\N	243.57562	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1099	29	2016-01-04 16:44:38+00	\N	175.12152	23.1	20.67682	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1100	29	2016-01-04 16:46:45+00	\N	150.30129	23.1	282.78796	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1101	29	2016-01-04 16:48:49+00	\N	135.03043	43.8	242.33344	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1102	29	2016-01-04 16:50:53+00	\N	133.25389	20.9	248.24103	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1103	29	2016-01-04 16:52:56+00	\N	116.76248	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1104	29	2016-01-04 16:55:02+00	\N	63.37064	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1105	29	2016-01-04 16:57:08+00	\N	117.39612	19.3	296.69064	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1106	29	2016-01-04 16:59:13+00	\N	55.99736	31.8	267.01938	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1107	29	2016-01-04 17:01:17+00	\N	65.67040	0.0	281.45883	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1108	29	2016-01-04 17:03:25+00	\N	60.15053	13.0	221.46315	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1109	29	2016-01-04 17:05:30+00	\N	74.41574	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1110	29	2016-01-04 17:05:30+00	\N	74.41574	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1111	29	2016-01-04 17:07:36+00	\N	76.36022	26.1	351.15918	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1112	29	2016-01-04 17:09:42+00	\N	75.74526	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1113	29	2016-01-04 17:11:48+00	\N	100.62975	21.5	0.86420	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1114	29	2016-01-04 17:13:50+00	\N	89.70458	17.8	327.73724	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1115	29	2016-01-04 17:15:56+00	\N	106.17295	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1116	29	2016-01-04 17:18:31+00	\N	106.36825	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1117	29	2016-01-04 17:20:40+00	\N	75.60469	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1118	29	2016-01-07 11:50:04+00	\N	147.74690	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1119	29	2016-01-07 11:50:22+00	\N	125.58043	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1120	29	2016-01-07 11:51:54+00	\N	-4.15637	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1121	29	2016-01-07 11:53:02+00	\N	96.13438	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1122	29	2016-01-07 11:54:08+00	\N	93.72961	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1123	29	2016-01-07 11:55:14+00	\N	86.92156	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1124	29	2016-01-07 11:56:20+00	\N	125.05798	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1125	29	2016-01-07 11:57:28+00	\N	88.98485	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1126	29	2016-01-07 11:58:34+00	\N	107.24376	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1127	29	2016-01-07 11:59:36+00	\N	107.18677	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1128	29	2016-01-07 12:00:42+00	\N	97.91015	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1129	29	2016-01-07 12:01:51+00	\N	70.88727	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1130	29	2016-01-07 12:03:00+00	\N	92.11080	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1131	29	2016-01-07 12:04:14+00	\N	96.02550	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1132	29	2016-01-07 12:05:32+00	\N	85.68190	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1133	29	2016-01-07 12:06:40+00	\N	108.75128	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1134	29	2016-01-07 12:07:55+00	\N	76.94068	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1135	29	2016-01-07 12:09:09+00	\N	123.89051	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1136	29	2016-01-07 12:10:20+00	\N	100.39020	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1137	29	2016-01-07 12:11:30+00	\N	62.47655	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1138	29	2016-01-07 12:12:37+00	\N	58.58135	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1139	29	2016-01-07 12:13:49+00	\N	52.60635	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1140	29	2016-01-07 12:14:54+00	\N	69.16012	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1141	29	2016-01-07 12:15:58+00	\N	84.61882	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1142	29	2016-01-07 12:17:00+00	\N	116.57516	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1143	29	2016-01-07 12:18:15+00	\N	53.79803	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1144	29	2016-01-07 12:19:36+00	\N	80.19436	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1145	29	2016-01-07 12:23:28+00	\N	91.26908	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1146	29	2016-01-07 12:24:42+00	\N	123.42405	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1147	29	2016-01-07 12:26:06+00	\N	154.60605	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1148	29	2016-01-07 12:27:41+00	\N	100.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1149	29	2016-01-07 12:29:00+00	\N	82.53234	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1150	29	2016-01-07 12:30:16+00	\N	136.04441	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1151	29	2016-01-07 12:31:46+00	\N	99.99999	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1152	29	2016-01-07 12:33:05+00	\N	100.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1153	29	2016-01-07 12:34:22+00	\N	82.31340	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1154	29	2016-01-07 12:36:17+00	\N	77.59457	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1155	29	2016-01-07 12:37:31+00	\N	139.36145	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1156	29	2016-01-07 12:38:43+00	\N	128.16359	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1157	29	2016-01-07 12:39:58+00	\N	105.37958	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1158	29	2016-01-07 12:41:52+00	\N	81.20392	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1159	29	2016-01-07 12:50:56+00	\N	75.52187	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1160	29	2016-01-07 12:52:10+00	\N	47.26170	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1161	29	2016-01-07 12:53:24+00	\N	42.30058	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1162	29	2016-01-07 12:55:16+00	\N	84.29400	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1163	29	2016-01-07 12:56:30+00	\N	156.91299	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1164	29	2016-01-07 12:57:40+00	\N	146.88391	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1165	29	2016-01-07 12:59:08+00	\N	80.74908	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1166	29	2016-01-07 13:00:24+00	\N	5.68500	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1167	29	2016-01-07 13:01:36+00	\N	157.96519	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1168	29	2016-01-07 13:02:51+00	\N	129.83854	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1169	29	2016-01-07 13:03:59+00	\N	129.96871	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1170	29	2016-01-07 13:06:28+00	\N	81.77106	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1171	29	2016-01-07 13:07:44+00	\N	88.30156	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1172	29	2016-01-07 13:10:57+00	\N	86.37008	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1173	29	2016-01-07 13:50:50+00	\N	81.04124	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1174	29	2016-01-07 13:52:13+00	\N	70.68377	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1175	29	2016-01-07 13:53:18+00	\N	80.50749	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1176	29	2016-01-07 13:54:24+00	\N	115.34611	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1177	29	2016-01-07 13:55:33+00	\N	45.93501	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1178	29	2016-01-07 13:56:40+00	\N	54.80794	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1179	29	2016-01-07 13:57:52+00	\N	66.86456	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1180	29	2016-01-07 13:58:59+00	\N	86.61428	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1181	29	2016-01-07 14:00:06+00	\N	39.76008	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1182	29	2016-01-07 14:01:18+00	\N	0.98466	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1183	29	2016-01-07 14:02:36+00	\N	91.64072	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1184	29	2016-01-07 14:03:50+00	\N	120.98810	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1185	29	2016-01-07 14:05:02+00	\N	105.82990	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1186	29	2016-01-07 14:06:16+00	\N	161.98278	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1187	29	2016-01-07 14:07:32+00	\N	35.35733	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1188	29	2016-01-07 14:07:32+00	\N	35.35733	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1189	29	2016-01-07 14:08:55+00	\N	124.73500	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1190	29	2016-01-07 14:10:10+00	\N	60.00069	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1191	29	2016-01-07 14:11:26+00	\N	83.77897	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1192	29	2016-01-07 14:12:36+00	\N	127.60348	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1193	29	2016-01-07 14:13:42+00	\N	88.73791	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1194	29	2016-01-07 14:14:57+00	\N	168.28591	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1195	29	2016-01-07 14:18:05+00	\N	90.20344	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1196	29	2016-01-07 14:19:16+00	\N	73.63163	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1197	29	2016-01-07 14:20:28+00	\N	78.68925	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1198	29	2016-01-07 14:23:42+00	\N	59.50851	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1199	29	2016-01-07 14:24:58+00	\N	99.58352	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1200	29	2016-01-07 14:26:11+00	\N	63.85021	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1201	29	2016-01-07 14:27:28+00	\N	121.40115	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1202	29	2016-01-07 14:28:46+00	\N	169.52134	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1203	29	2016-01-07 14:29:58+00	\N	52.15126	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1204	29	2016-01-07 14:31:07+00	\N	111.84171	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1205	29	2016-01-07 14:32:23+00	\N	31.30662	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1206	29	2016-01-07 14:33:33+00	\N	127.31145	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1207	29	2016-01-07 14:34:48+00	\N	123.36702	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1208	29	2016-01-07 14:35:57+00	\N	101.13660	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1209	29	2016-01-07 14:37:09+00	\N	94.36497	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1210	29	2016-01-07 14:38:21+00	\N	108.59214	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1211	29	2016-01-07 14:39:33+00	\N	121.81434	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1212	29	2016-01-07 14:40:47+00	\N	34.19631	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1213	29	2016-01-07 14:42:00+00	\N	80.53133	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1214	29	2016-01-07 14:43:09+00	\N	72.38463	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1215	29	2016-01-07 14:44:24+00	\N	84.88668	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1216	29	2016-01-07 14:45:52+00	\N	79.89497	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1217	29	2016-01-07 14:47:31+00	\N	98.39327	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1218	29	2016-01-07 14:48:45+00	\N	154.71290	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1219	29	2016-01-07 14:49:56+00	\N	24.66419	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1220	29	2016-01-07 14:51:10+00	\N	111.27901	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1221	29	2016-02-19 10:46:31+00	\N	114.57035	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1222	29	2016-02-19 10:48:37+00	\N	65.72685	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1223	29	2016-02-19 10:50:44+00	\N	109.78337	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1224	29	2016-02-19 10:52:48+00	\N	63.26712	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1225	29	2016-02-19 10:54:54+00	\N	71.50779	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1226	29	2016-02-19 10:57:00+00	\N	67.53630	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1227	29	2016-02-19 10:59:04+00	\N	141.63606	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1228	29	2016-02-19 11:01:10+00	\N	132.09523	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1229	29	2016-02-19 11:03:42+00	\N	63.31962	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1230	29	2016-02-19 11:05:48+00	\N	103.04637	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1231	29	2016-02-19 11:12:34+00	\N	117.75251	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1232	29	2016-02-19 11:15:35+00	\N	94.04950	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1233	29	2016-02-19 11:18:11+00	\N	79.11864	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1234	29	2016-02-19 11:20:27+00	\N	141.95906	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1235	29	2016-02-19 11:23:09+00	\N	158.90621	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1236	29	2016-02-19 11:25:45+00	\N	137.41710	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1237	29	2016-02-19 11:34:05+00	\N	144.74081	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1238	29	2016-02-19 11:36:52+00	\N	241.25920	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1239	29	2016-02-19 11:39:08+00	\N	208.36707	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1240	29	2016-02-19 11:41:17+00	\N	250.44724	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1241	29	2016-02-19 11:43:27+00	\N	239.17050	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1242	29	2016-02-19 11:45:32+00	\N	207.59862	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1243	29	2016-02-19 11:47:37+00	\N	236.71580	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1244	29	2016-02-19 11:49:45+00	\N	238.54556	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1245	29	2016-02-19 11:51:54+00	\N	248.95326	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1246	29	2016-02-19 11:54:01+00	\N	250.15757	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1247	29	2016-02-19 11:56:07+00	\N	229.62757	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1248	29	2016-02-19 11:58:11+00	\N	231.15033	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1249	29	2016-02-19 12:00:23+00	\N	254.82332	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1250	29	2016-02-19 12:02:30+00	\N	254.67160	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1251	29	2016-02-19 12:04:37+00	\N	246.92173	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1252	29	2016-02-19 12:06:45+00	\N	232.80016	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1253	29	2016-02-19 12:08:57+00	\N	145.40776	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1254	29	2016-02-19 12:08:57+00	\N	145.40776	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1255	29	2016-02-19 12:11:06+00	\N	233.81307	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1256	29	2016-02-19 12:13:12+00	\N	232.61863	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1257	29	2016-02-19 12:15:20+00	\N	264.20051	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1258	29	2016-02-19 12:17:31+00	\N	263.64677	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1259	29	2016-02-19 12:19:40+00	\N	242.61455	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1260	29	2016-02-19 12:21:51+00	\N	225.64360	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1261	29	2016-02-19 12:24:04+00	\N	244.84832	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1262	29	2016-02-19 12:26:13+00	\N	233.44105	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1263	29	2016-02-19 12:28:22+00	\N	273.51968	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1264	29	2016-02-19 12:30:29+00	\N	240.87434	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1265	29	2016-02-19 12:32:37+00	\N	259.40222	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1266	29	2016-02-19 12:34:46+00	\N	259.87000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1267	29	2016-02-19 12:34:46+00	\N	259.87000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1268	29	2016-02-19 12:36:54+00	\N	240.36106	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1269	29	2016-02-19 12:39:02+00	\N	269.46737	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1270	29	2016-02-19 12:41:11+00	\N	231.60738	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1271	29	2016-02-19 12:43:18+00	\N	252.65272	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1272	29	2016-02-19 12:45:30+00	\N	245.75208	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1273	29	2016-02-19 12:47:38+00	\N	220.39484	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1274	29	2016-02-19 12:47:38+00	\N	220.39484	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1275	29	2016-02-19 12:47:38+00	\N	220.39484	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1276	29	2016-02-19 12:49:48+00	\N	261.10292	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1277	29	2016-02-19 12:51:56+00	\N	264.04856	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1278	29	2016-02-19 12:51:56+00	\N	264.04856	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1279	29	2016-02-19 12:54:02+00	\N	246.38965	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1280	29	2016-02-19 12:56:14+00	\N	295.00250	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1281	29	2016-02-19 12:58:22+00	\N	241.80717	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1282	29	2016-02-19 13:00:31+00	\N	254.67662	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1283	29	2016-02-19 13:02:38+00	\N	302.85570	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1284	29	2016-02-19 13:02:38+00	\N	302.85570	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1285	29	2016-02-19 13:02:38+00	\N	302.85570	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1286	29	2016-02-19 13:04:46+00	\N	228.85575	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1287	29	2016-02-19 13:06:55+00	\N	223.16110	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1288	29	2016-02-19 13:09:02+00	\N	247.83562	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1289	29	2016-02-19 13:11:09+00	\N	282.80042	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1290	29	2016-02-19 13:13:15+00	\N	220.84012	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1291	29	2016-02-19 13:15:21+00	\N	226.20299	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1292	29	2016-02-19 13:17:27+00	\N	222.09348	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1293	29	2016-02-19 13:19:37+00	\N	221.57114	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1294	29	2016-02-19 13:21:45+00	\N	275.48429	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1295	29	2016-02-19 13:23:53+00	\N	256.61705	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1296	29	2016-02-19 13:26:01+00	\N	262.07328	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1297	29	2016-02-19 13:28:03+00	\N	242.14316	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1298	29	2016-02-19 13:30:09+00	\N	250.30857	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1299	29	2016-02-19 13:32:13+00	\N	275.72823	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1300	29	2016-02-19 13:34:16+00	\N	255.88397	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1301	29	2016-02-19 13:36:20+00	\N	276.72394	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1302	29	2016-02-19 13:38:24+00	\N	237.59560	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1303	29	2016-02-19 13:40:28+00	\N	238.60852	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1304	29	2016-02-19 13:42:33+00	\N	278.15651	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1305	29	2016-02-19 13:44:37+00	\N	227.55302	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1306	29	2016-02-19 13:46:40+00	\N	310.06210	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1307	29	2016-02-19 13:48:42+00	\N	211.44326	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1308	29	2016-02-19 13:50:46+00	\N	287.79830	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1309	29	2016-02-19 13:52:48+00	\N	275.40186	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1310	29	2016-02-19 13:54:53+00	\N	240.54723	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1311	29	2016-02-19 13:56:58+00	\N	251.35790	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1312	29	2016-02-19 13:59:03+00	\N	229.47043	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1313	29	2016-02-19 14:01:08+00	\N	210.64084	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1314	29	2016-02-19 14:03:11+00	\N	222.17415	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1315	29	2016-02-19 14:05:14+00	\N	207.07153	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1316	29	2016-02-19 14:07:16+00	\N	171.87476	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1317	29	2016-02-19 14:09:21+00	\N	157.54076	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1318	29	2016-02-19 14:11:24+00	\N	194.57809	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1319	29	2016-02-19 14:13:27+00	\N	159.76590	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1320	29	2016-02-19 14:15:30+00	\N	190.09517	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1321	29	2016-02-19 14:17:40+00	\N	191.56645	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1322	29	2016-02-19 14:19:43+00	\N	215.02582	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1323	29	2016-02-19 14:21:46+00	\N	205.54639	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1324	29	2016-02-19 14:23:51+00	\N	214.58979	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1325	29	2016-02-19 14:25:55+00	\N	228.58027	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1326	29	2016-02-19 14:27:58+00	\N	231.97750	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1327	29	2016-02-19 14:30:01+00	\N	236.24717	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1328	29	2016-02-19 14:32:03+00	\N	206.76351	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1329	29	2016-02-19 14:34:08+00	\N	266.56486	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1330	29	2016-02-19 14:36:12+00	\N	248.64722	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1331	29	2016-02-19 14:38:17+00	\N	222.02083	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1332	29	2016-02-19 14:40:22+00	\N	221.57529	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1333	29	2016-02-19 14:42:28+00	\N	229.73587	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1334	29	2016-02-19 14:44:30+00	\N	207.01894	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1335	29	2016-02-19 14:46:35+00	\N	208.20430	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1336	29	2016-02-19 14:48:38+00	\N	204.84813	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1337	29	2016-02-19 14:48:38+00	\N	204.84813	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1338	29	2016-02-19 14:50:43+00	\N	190.82709	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1339	29	2016-02-19 14:50:43+00	\N	190.82709	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1340	29	2016-02-19 14:52:47+00	\N	177.86771	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1341	29	2016-02-19 14:54:53+00	\N	132.08363	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1342	29	2016-02-19 14:56:57+00	\N	166.15985	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1343	29	2016-02-19 14:59:01+00	\N	196.74485	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1344	29	2016-02-19 15:01:06+00	\N	203.69675	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1345	29	2016-02-19 15:03:11+00	\N	215.21655	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1346	29	2016-02-19 15:05:15+00	\N	212.99024	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1347	29	2016-02-19 15:07:19+00	\N	222.55243	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1348	29	2016-02-19 15:09:25+00	\N	211.79012	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1349	29	2016-02-19 15:11:28+00	\N	222.96631	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1350	29	2016-02-19 15:13:34+00	\N	251.47744	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1351	29	2016-02-19 15:15:37+00	\N	222.24688	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1352	29	2016-02-19 15:17:40+00	\N	231.35491	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1353	29	2016-02-19 15:19:43+00	\N	208.53613	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1354	29	2016-02-19 15:21:45+00	\N	229.44093	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1355	29	2016-02-19 15:23:51+00	\N	256.14896	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1356	29	2016-02-19 15:25:55+00	\N	256.73130	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1357	29	2016-02-19 15:27:58+00	\N	216.86961	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1358	29	2016-02-19 15:30:00+00	\N	218.33836	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1359	29	2016-02-19 15:32:03+00	\N	235.46579	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1360	29	2016-02-19 15:34:06+00	\N	201.91989	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1361	29	2016-02-19 15:36:09+00	\N	180.58161	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1362	29	2016-02-19 15:38:11+00	\N	205.13184	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1363	29	2016-02-19 15:40:15+00	\N	241.97388	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1364	29	2016-02-19 15:42:18+00	\N	174.96621	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1365	29	2016-02-19 15:44:20+00	\N	218.63867	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1366	29	2016-02-19 15:46:23+00	\N	243.10234	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1367	29	2016-02-19 15:48:25+00	\N	222.65266	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1368	29	2016-02-19 15:50:28+00	\N	235.00775	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1369	29	2016-02-19 15:52:30+00	\N	276.36246	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1370	29	2016-02-19 15:54:33+00	\N	231.87436	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1371	29	2016-02-19 15:56:35+00	\N	214.87966	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1372	29	2016-02-19 15:58:38+00	\N	265.20939	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1373	29	2016-02-19 16:00:41+00	\N	266.95782	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1374	29	2016-02-19 16:02:44+00	\N	207.24872	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1375	29	2016-02-19 16:04:51+00	\N	255.34070	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1376	29	2016-02-19 16:06:53+00	\N	223.87031	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1377	29	2016-02-19 16:08:58+00	\N	338.73064	21.8	269.34628	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1378	29	2016-02-19 16:11:02+00	\N	227.34499	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1379	29	2016-02-19 16:11:02+00	\N	227.34499	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1380	29	2016-02-19 16:13:07+00	\N	158.58727	22.8	16.63575	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1381	29	2016-02-19 16:15:10+00	\N	153.80896	29.8	272.40491	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1382	29	2016-02-19 16:17:14+00	\N	151.96810	25.2	235.29823	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1383	29	2016-02-19 16:19:16+00	\N	143.16188	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1384	29	2016-02-19 16:21:19+00	\N	151.54806	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1385	29	2016-02-19 16:23:23+00	\N	118.35828	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1386	29	2016-02-19 16:25:26+00	\N	93.07239	27.5	348.85513	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1387	29	2016-02-19 16:27:30+00	\N	65.82455	26.1	344.37808	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1388	29	2016-02-19 16:29:32+00	\N	69.16727	22.3	292.67218	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1389	29	2016-02-19 16:31:35+00	\N	80.13149	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1390	29	2016-02-19 16:33:37+00	\N	63.99849	19.5	297.77524	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1391	29	2016-02-19 16:35:42+00	\N	81.44192	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1392	29	2016-02-19 16:37:47+00	\N	89.03619	23.0	278.93558	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1393	29	2016-02-19 16:39:51+00	\N	88.58311	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1394	29	2016-02-19 16:41:54+00	\N	100.45986	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1395	29	2016-02-19 16:43:58+00	\N	106.32168	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1396	29	2016-02-19 16:46:08+00	\N	93.27480	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1397	29	2016-02-19 16:48:17+00	\N	58.96672	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1398	29	2016-02-19 16:50:23+00	\N	98.84715	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1399	29	2016-02-19 16:52:37+00	\N	130.69641	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1400	29	2016-02-19 16:54:52+00	\N	81.67397	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1401	29	2016-02-19 16:57:06+00	\N	124.20540	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1402	29	2016-02-19 16:59:15+00	\N	103.08276	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1403	29	2016-02-19 17:01:30+00	\N	6.46054	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1404	29	2016-02-19 17:03:46+00	\N	127.85283	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1405	29	2016-02-19 17:06:02+00	\N	65.49579	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1406	29	2016-02-19 17:08:12+00	\N	83.66673	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1407	29	2016-02-19 17:10:22+00	\N	95.43977	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1408	29	2016-02-19 17:12:31+00	\N	125.69916	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1409	29	2016-02-19 17:14:39+00	\N	102.07652	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1410	29	2016-02-19 17:16:49+00	\N	85.88842	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1411	29	2016-02-19 17:18:59+00	\N	81.58980	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1412	29	2016-02-19 17:21:10+00	\N	170.20714	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1413	29	2016-02-19 17:23:20+00	\N	13.72055	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1414	29	2016-02-19 17:25:29+00	\N	94.18628	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1415	29	2016-02-19 17:27:38+00	\N	48.88631	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1416	29	2016-02-19 17:29:49+00	\N	160.23621	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1417	29	2016-02-19 17:32:05+00	\N	62.13086	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1418	29	2016-02-19 17:34:14+00	\N	141.03163	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1419	29	2016-02-19 17:36:25+00	\N	79.38320	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1420	29	2016-02-19 17:38:36+00	\N	112.22670	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1421	29	2016-02-19 17:40:44+00	\N	63.14650	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1422	29	2016-02-19 17:42:57+00	\N	96.24970	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1423	29	2016-02-19 17:45:08+00	\N	104.41220	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1424	29	2016-02-19 17:47:51+00	\N	100.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1425	29	2016-02-19 17:50:06+00	\N	92.23238	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1426	29	2016-02-19 17:52:18+00	\N	123.25989	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1427	29	2016-02-19 17:54:35+00	\N	100.01967	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1428	29	2016-02-19 17:56:49+00	\N	110.07779	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1429	29	2016-02-19 17:59:07+00	\N	23.19553	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1584	3	2015-12-14 21:19:07.139+00	23.0	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1585	3	2015-12-14 10:04:58.36+00	16.0	51.09192	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1586	3	2015-12-14 10:10:06.514+00	32.0	125.56415	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1587	3	2015-12-14 10:15:10.64+00	48.0	49.37104	11.9	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1588	3	2015-12-14 10:25:08.381+00	48.0	109.73980	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1589	3	2015-12-14 10:30:09.154+00	48.0	83.58111	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1590	3	2015-12-14 10:40:11.156+00	24.0	66.52248	8.5	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1591	3	2015-12-14 10:50:06.515+00	48.0	48.34206	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1592	3	2015-12-14 11:00:03.189+00	48.0	111.46332	30.3	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1593	3	2015-12-14 11:10:03.251+00	24.0	206.32573	30.9	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1594	3	2015-12-14 11:20:00.955+00	32.0	97.54374	22.7	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1595	3	2015-12-14 11:25:04.288+00	24.0	87.00727	30.9	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1596	3	2015-12-14 11:35:01.882+00	24.0	94.24696	30.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1597	3	2015-12-14 11:40:10.616+00	32.0	170.12395	26.9	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1598	3	2015-12-14 11:50:01.38+00	48.0	17.60809	16.3	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1599	3	2015-12-14 11:55:03.442+00	16.0	16.94053	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1600	3	2015-12-14 12:05:03.349+00	32.0	11.81109	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1601	3	2015-12-14 12:10:06.537+00	32.0	19.34044	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1602	3	2015-12-14 12:20:07.55+00	16.0	32.07724	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1603	3	2015-12-14 14:10:09.334+00	24.0	23.29288	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1604	3	2015-12-14 14:20:28.425+00	64.0	17.89340	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1605	3	2015-12-14 14:43:27.46+00	64.0	20.78518	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1606	3	2015-12-14 14:48:27.82+00	32.0	24.14507	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1607	3	2015-12-14 14:53:28.792+00	24.0	21.19114	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1608	3	2015-12-14 14:58:29.3+00	12.0	21.12493	1.5	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1609	3	2015-12-14 15:03:29.92+00	12.0	14.91000	1.5	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1610	3	2015-12-14 15:08:30.416+00	16.0	14.16052	3.4	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1611	3	2015-12-14 15:13:30.629+00	16.0	31.10615	31.4	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1612	3	2015-12-14 15:18:31.649+00	16.0	46.47290	26.4	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1613	3	2015-12-14 15:23:32.52+00	24.0	178.95087	26.1	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1614	3	2015-12-14 15:28:32.988+00	24.0	123.36554	25.1	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1615	3	2015-12-14 15:33:33.173+00	16.0	72.06099	25.7	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1616	3	2015-12-14 15:38:33.696+00	24.0	50.52177	26.4	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1617	3	2015-12-14 15:43:34+00	24.0	114.15440	27.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1618	3	2015-12-14 15:48:34.876+00	32.0	91.05626	25.8	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1619	3	2015-12-14 15:53:35.945+00	24.0	172.98328	27.4	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1620	3	2015-12-14 15:58:36.853+00	24.0	224.66151	27.5	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1621	3	2015-12-14 16:08:37.654+00	24.0	117.04468	27.4	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1622	3	2015-12-14 16:18:37.77+00	32.0	91.70271	27.1	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1623	3	2015-12-14 16:23:38.264+00	48.0	37.52547	19.6	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1624	3	2015-12-14 16:28:39.234+00	12.0	41.92637	6.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1625	3	2015-12-14 16:33:50.132+00	48.0	78.80940	24.4	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1626	3	2015-12-14 16:38:50.798+00	16.0	75.52290	22.5	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1627	3	2015-12-14 16:43:51.704+00	24.0	68.09069	10.9	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1628	3	2015-12-14 16:53:52.854+00	16.0	58.24796	5.3	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1629	3	2015-12-14 16:59:58.571+00	48.0	51.63332	5.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1630	3	2015-12-14 17:04:58.702+00	24.0	40.75135	10.2	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1631	3	2015-12-14 17:09:59.035+00	8.0	36.48204	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1632	3	2015-12-14 17:14:59.739+00	8.0	38.30668	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1633	3	2015-12-14 21:20:07.444+00	28.0	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1634	3	2015-12-14 21:20:27.395+00	21.0	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1635	3	2015-12-14 21:20:32.541+00	16.0	35.29953	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1636	3	2015-12-14 21:21:41.363+00	20.0	0.00000	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1637	3	2015-12-14 21:21:52.355+00	32.0	68.84431	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1638	3	2015-12-14 21:21:57.812+00	24.0	67.74007	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1639	3	2015-12-14 21:22:03.822+00	16.0	70.75603	0.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
1640	3	2015-12-14 21:22:12.777+00	48.0	76.91284	2.0	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15233	29	2016-02-29 13:14:59+00	\N	\N	\N	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15234	29	2016-02-29 13:14:59+00	1320.0	\N	\N	\N	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15235	29	2016-02-29 13:14:59+00	1320.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15236	29	2016-02-29 13:36:32+00	1320.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15237	29	2016-02-29 14:32:50+00	1596.9	261.73477	0.0	0.37360	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15238	29	2016-04-22 12:28:38+00	22.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15239	29	2016-04-22 12:28:38+00	22.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15240	29	2016-04-22 12:28:38+00	22.0	0.00000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15241	29	2016-04-22 12:28:38+00	22.0	0.00000	0.0	0.00000	31	network	92.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15242	29	2016-04-22 13:07:46+00	40.5	0.00000	0.0	0.00000	31	network	90.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15243	29	2016-04-22 13:08:14+00	36.0	0.00000	0.0	0.00000	31	network	90.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15244	29	2016-04-22 13:08:35+00	26.0	0.00000	0.0	0.00000	31	network	90.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15245	29	2016-04-22 13:08:56+00	24.0	0.00000	0.0	0.00000	31	network	89.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15246	29	2016-04-22 13:09:13+00	9.0	109.00000	0.0	0.00000	31	gps	89.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15247	29	2016-04-22 13:09:29+00	11.0	109.00000	0.0	0.00000	31	gps	89.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15248	29	2016-04-22 13:09:53+00	33.0	0.00000	0.0	0.00000	22	network	89.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15249	29	2016-04-22 13:10:09+00	6.0	106.00000	0.0	0.00000	22	gps	89.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15250	29	2016-04-22 13:10:25+00	5.0	106.00000	0.0	0.00000	22	gps	89.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15251	29	2016-04-22 13:10:40+00	5.0	106.00000	0.0	0.00000	23	gps	89.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15252	29	2016-04-22 13:10:56+00	11.0	106.00000	0.0	0.00000	23	gps	89.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15253	29	2016-04-22 13:11:11+00	11.0	106.00000	0.0	0.00000	23	gps	89.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15254	29	2016-04-22 13:11:27+00	10.0	106.00000	0.0	0.00000	23	gps	89.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15255	29	2016-04-22 13:11:43+00	10.0	106.00000	0.0	0.00000	23	gps	89.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15256	29	2016-04-22 13:11:58+00	10.0	106.00000	0.0	0.00000	23	gps	88.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15257	29	2016-04-22 13:12:14+00	11.0	106.00000	0.0	0.00000	23	gps	88.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15258	29	2016-04-22 13:12:30+00	11.0	106.00000	0.0	0.00000	23	gps	88.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15259	29	2016-04-22 13:12:51+00	37.5	0.00000	0.0	0.00000	23	network	88.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15260	29	2016-04-22 13:13:10+00	37.5	0.00000	0.0	0.00000	23	network	88.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15261	29	2016-04-22 19:22:50+00	48.0	0.00000	0.0	0.00000	19	network	80.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15262	29	2016-04-22 19:23:09+00	24.0	0.00000	0.0	0.00000	19	network	79.0	Test note	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15263	29	2016-04-22 19:23:32+00	34.5	0.00000	0.0	0.00000	19	network	79.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15264	29	2016-04-22 19:24:29+00	39.0	0.00000	0.0	0.00000	19	network	79.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15265	29	2016-04-22 19:25:37+00	25.0	0.00000	0.0	0.00000	19	network	79.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15266	29	2016-04-22 19:26:38+00	28.0	0.00000	0.0	0.00000	19	network	79.0	A longer note than the previous one.	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15416	29	2017-01-15 13:36:26.292+00	20.0	-46.72000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15417	29	2017-01-15 13:36:57.189+00	13.0	40.28000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15418	29	2017-01-15 13:37:28.148+00	12.0	42.28000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15419	29	2017-01-15 13:40:10+00	31.0	0.00000	0.0	0.00000	5	gps	56.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15420	29	2017-01-15 13:34:28.073+00	27.2	-46.72000	38.4	43.80000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15422	29	2017-01-15 15:53:18.14+00	23.0	-46.72000	0.0	0.00000	\N	\N	\N	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15423	29	2017-01-15 15:54:44+00	46.0	74.00000	0.0	0.00000	9	gps	54.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15424	3	2017-01-15 16:05:24+00	27.0	0.00000	0.2	5.10000	6	gps	53.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15425	3	2017-01-15 16:05:38+00	17.0	59.00000	0.0	0.00000	4	gps	53.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15426	3	2017-01-15 16:11:42+00	42.0	0.00000	0.4	149.50000	9	gps	53.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15427	3	2017-01-15 16:12:03+00	43.0	63.00000	0.0	0.00000	10	gps	53.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15428	3	2017-01-15 16:31:18+00	83.0	0.00000	0.0	0.00000	10	gps	52.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15429	3	2017-01-15 16:45:15+00	12.0	62.00000	0.0	0.00000	9	gps	52.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15430	3	2017-01-15 17:04:58+00	33.0	0.00000	0.0	0.00000	8	gps	52.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15431	3	2017-01-15 18:18:49+00	20.0	0.00000	0.0	0.00000	11	gps	51.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15432	3	2017-01-15 22:12:38.323+00	27.0	0.00000	0.3	172.70000	7	gps	45.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15455	29	2017-01-18 16:44:09+00	\N	118.00000	0.0	0.00000	\N	\N	73.0	\N	0101000020E61000004260E5D0225B0240DECCC739DA6D4840
15456	29	2020-10-09 13:14:42.404+00	\N	\N	\N	\N	\N	manual	\N	Test note 01	0101000020E610000001000000FC5A02406D10D493DB6D4840
15457	29	2020-10-09 13:14:42.404+00	\N	\N	\N	\N	\N	manual	\N	Test note 02	0101000020E610000001000000FC5A02406D10D493DB6D4840
15458	29	2020-10-09 13:14:42.404+00	\N	\N	\N	\N	\N	manual	\N	Test note 03	0101000020E610000001000000FC5A02406D10D493DB6D4840
15459	29	2020-10-09 13:14:42.404+00	\N	\N	\N	\N	\N	manual	\N	Test note 04	0101000020E610000001000000FC5A02406D10D493DB6D4840
15460	29	2020-10-09 13:14:42.404+00	\N	\N	\N	\N	\N	manual	\N	Test note 05	0101000020E610000001000000FC5A02406D10D493DB6D4840
\.


--
-- Data for Name: location_sharing; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.location_sharing (shared_by_id, shared_to_id, recent_minutes, max_minutes, active) FROM stdin;
2	29	\N	\N	t
3	29	\N	\N	t
3	1	\N	\N	t
\.


--
-- Data for Name: path_color; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.path_color (key, value, html_code) FROM stdin;
Black	Black	black
White	White	white
Red	Red	red
Yellow	Yellow	yellow
Blue	Blue	blue
Magenta	Magenta	fuchsia
Cyan	Cyan	aqua
DarkRed	Dark Red	maroon
Green	Green	lime
DarkGreen	Dark Green	green
LightGray	Light Gray	silver
DarkGray	Dark Gray	gray
DarkBlue	Dark Blue	navy
DarkMagenta	Dark Magenta	purple
DarkYellow	Dark Yellow	olive
DarkCyan	Dark Cyan	teal
\.


--
-- Data for Name: role; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.role (id, name) FROM stdin;
1	Admin
2	User
\.


--
-- Data for Name: session; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.session (id, user_id, updated) FROM stdin;
\.


--
-- Data for Name: session_data; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.session_data (session_id, key, value) FROM stdin;
\.


--
-- Data for Name: spatial_ref_sys; Type: TABLE DATA; Schema: public; Owner: vagrant
--

COPY public.spatial_ref_sys (srid, auth_name, auth_srid, srtext, proj4text) FROM stdin;
\.


--
-- Data for Name: tile; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.tile (server_id, x, y, z, image, updated, expires) FROM stdin;
\.


--
-- Data for Name: tile_metric; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.tile_metric ("time", count) FROM stdin;
2020-02-24 16:09:32.054217+00	200
2020-02-24 16:11:25.025715+00	300
2020-02-24 16:25:58.135462+00	400
2020-02-24 16:26:07.54788+00	500
2020-02-24 16:26:43.756086+00	600
2020-02-24 16:28:26.308739+00	700
2020-02-24 16:29:05.929009+00	800
2020-02-24 16:31:01.948438+00	900
2020-02-24 16:33:53.512479+00	1000
\.


--
-- Data for Name: user_role; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.user_role (user_id, role_id) FROM stdin;
1	1
\.


--
-- Data for Name: usertable; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.usertable (id, firstname, lastname, email, uuid, password, nickname, tl_settings) FROM stdin;
62	oswald	smith	oswald@trip.test	d7cb7b56-f53c-4c64-a795-fdb256775b80	$2a$10$YoVIqJLcUD.AW6ZU7JxUzOoGkumJk0QZyisc0I/3LIdBK6Hq.UrTy	oswald5	\N
63	Oswald	Jones	oswald6@trip.test	7edf973d-312c-489b-9784-34aad58861d8	$2a$10$5iUvXmI0rEJKzPW26tpuQO6j3EhZwGsVd./WH6IbOIpgdrU0rNhES	oswald6	\N
30	test	test	tes99t@trip.test	f2017e90-6f0b-24a9-ee41-e6a93530a5e7	$2a$10$lHw51RHaxpsSsJzFEih5i.49zLK6LUlCrlIjw.3eDEK5jX.pJR1Uu	test997u987	\N
456	purple	purple	purple@trip.test	3ef65320-f920-4e88-a3a6-bdf36bb17532	$2a$10$YGUYdOlkdi1NamxkppzV9ekIAwrq32IhlwNyzFOU.teemJzhDAcKm	purple	\N
791	Orange	Orange	orange@trip.test	bd54bb2d-4f64-4ace-ad4a-cc0fc4152378	$2a$10$CUzhW4pxQKEPfZxA1JwnxupDP7LyxYTAj2ueobipHWivVMEuZK1ne	orange	\N
3	Fred	Test	fred@trip.test	1103c87d-d0f6-e01a-2114-27699feea78b	$2a$10$CNiaAPQX6ANmbe3SYzhSD.fzmmd4Zw.ga3j3hmbxI3tOYU7dW8Sae	Fred	\N
1	admin	admin	admin@trip.test	38de8ade-de0b-4c71-a7ff-7ec37ab5c781	$2a$10$X/L5xzu91K5/oTIXlTRuxO53mwNHp1.R2X/GvytL3oo2rBZsGQmU2	admin	\N
31	test	test	tes999t@trip.test	14c9a561-522b-8932-97e0-b6b916296c21	$2a$10$sr0pxDTRTmA9nPfm/I67LO5tLZbqtdVkrRVdKWRq.WIIXoX0/xFPW	test997u9879	\N
32	test	test	test998@trip.test	23b10128-7001-68ab-2150-f36e73a923f4	$2a$10$1LmJbfDKhmDecam19rGTDOA3Sj8XA4VLEwVnb9APKIQGodCyKgLce	tset99	\N
2	Test	Test	test2@trip.test	f68a8d21-6e39-e1f5-79f5-55dc9603b138	$2a$10$u26z37kPq5hHDFBSQe6.weD1wnjgw2S4IcZubBf2.OiSDz4AQmMGO	test2	\N
4	John	Test	john@trip.test	389561bd-1365-eab3-1e6f-3295e14491f1	$2a$10$fy1fmvCZ4T/gXLIVSmRftuMd/DoPUc1u1iJDeSMrKHdHCYXjt/f8y	John	\N
5	Jane	Test	jane@trip.test	1280186b-2d80-6f34-ae56-525d576f133f	$2a$10$8XTbrY9LooDhCClYiZ4BZOR4amciyOFpEdPtaNmL9..uizayg.wQe	Jane	\N
6	Adam	Test	adam@trip.test	45448370-02a1-aabc-0f41-c7dfb63f050d	$2a$10$/bfCvk6wGdrRm.skSmcnoOlWRDGrvTBg3xE3VowPJrf3l8E3eDa5.	Adam	\N
7	Adam	Test	adam2@trip.test	628f8e5e-a7aa-a100-e87e-04daca339255	$2a$10$xlK.3YKn2zh8duQoE2f7r.mYfovQLOS3DJ4.Fx7lqWl6.tzowgotC	Adam2	\N
9	Adam	Test	adam3@trip.test	ac039082-7574-62b7-a035-3f35e1b4c1a1	$2a$10$8fYio5H.clRBAOfqqzN4Dea9RJKhnl26H3rhDaApaHqLm.0hbPhru	Adam3	\N
10	test	test	oswald1@trip.test	789cec4d-3980-19a3-9515-a6f53f1dba86	$2a$10$Ur/yQeKkOjUX0BQnWc6ZqeXIFEkqni.3/VvB4tFCsAWU1Fu/HgZxm	oswald	\N
11	test	test	oswald2@trip.test	6830d8fb-a71c-9a41-cd11-4eaf5e58496e	$2a$10$CJkQGukvcGBoEZnWmzOh9e2nHb4BLSFWGMjptN.3Aa0DZHFOmLTqq	oswald2	\N
12	test	test	oswald3@trip.test	7ca61784-93da-db15-011f-80b71dc947d2	$2a$10$5LGcQ.mGzVRYm5noUojrJ.HL660x9/omQm5yoEpNrUFkzXbB6NdMK	oswald3	\N
13	test	test	oswald4@trip.test	af5f4dfd-dce8-95b9-fd1c-956b165a08ea	$2a$10$5OKage5jjnsH5tY6sCd7l.ulY.uGpFjERyWg3P.K.59DHK5JrqI8i	oswald4	\N
29	user	user	user@trip.test	178ef589-8cf4-4cfa-baba-a2896b5d51e9	$2a$10$isrRX95ufUijN1zu/L0diOXeYUz9pzY1KXBQFJ3mqlyiY7p86ajb2	user	\N
670	John	Smith	test@trip.test	c33aae96-050b-41b8-9304-a9779c7c6708	$2a$10$Zzxdh5kwdziJWuk64B0CKuKTY4o0SBtRCzD1qg7uyGxjnGEF/3T0S	test	\N
\.


--
-- Data for Name: waypoint_symbol; Type: TABLE DATA; Schema: public; Owner: trip
--

COPY public.waypoint_symbol (key, value) FROM stdin;
parking	Parking (ViewRanger)
lodging	Lodging (ViewRanger)
peak   	Peak (ViewRanger)
medicalfacility	Medical Facility (ViewRanger)
1	01 (ViewRanger)
2	02 (ViewRanger)
3	03 (ViewRanger)
4	04 (ViewRanger)
5	05 (ViewRanger)
6	06 (ViewRanger)
7	07 (ViewRanger)
8	08 (ViewRanger)
9	09 (ViewRanger)
10	10 (ViewRanger)
11	11 (ViewRanger)
12	12 (ViewRanger)
13	13 (ViewRanger)
14	14 (ViewRanger)
15	15 (ViewRanger)
16	16 (ViewRanger)
17	17 (ViewRanger)
18	18 (ViewRanger)
19	19 (ViewRanger)
20	20 (ViewRanger)
21	21 (ViewRanger)
22	22 (ViewRanger)
23	23 (ViewRanger)
24	24 (ViewRanger)
25	25 (ViewRanger)
26	26 (ViewRanger)
27	27 (ViewRanger)
28	28 (ViewRanger)
29	29 (ViewRanger)
30	30 (ViewRanger)
None	None (ViewRanger)
warningflag	Warning Flag (ViewRanger)
turnright	Turn right (ViewRanger)
turnleft	Turn left (ViewRanger)
steeprocks	Steep Rocks / Cliff (ViewRanger)
hutshelter	Hut / Shelter (ViewRanger)
helipad	Helipad (ViewRanger)
drinkingwater	Drinking Water (ViewRanger)
crossing	Crossing (ViewRanger)
forest	Wood / Forest (ViewRanger)
wildcamping	Wild Camping (ViewRanger)
waterfall	Waterfall (ViewRanger)
viewpoint	Viewpoint (ViewRanger)
geocache	Geocache (ViewRanger)
touristinformation	Tourist Information (ViewRanger)
shop	Shop (ViewRanger)
restaurant	Restaurant (ViewRanger)
publictoilets	Public Toilets (ViewRanger)
pub	Pub (ViewRanger)
place	Place (ViewRanger)
picnicarea	Picnic Area (ViewRanger)
poi_red	Point of Interest - red (ViewRanger)
poi_purple	Point of Interest - purple (ViewRanger)
poi_orange	Point of Interest - orange (ViewRanger)
poi_green	Point of Interest - green (ViewRanger)
outdoorswimming	Outdoor Swimming (ViewRanger)
obstacle	Stile / Obstacle (ViewRanger)
landmark	Landmark (ViewRanger)
water	Water (ViewRanger)
jetty	Jetty (ViewRanger)
flora	Flora (ViewRanger)
fauna	Fauna (ViewRanger)
farm	Farm (ViewRanger)
dot	Dot (ViewRanger)
beach	Beach (ViewRanger)
activity	Activity (ViewRanger)
camp	Camp (ViewRanger)
building	Building (ViewRanger)
bridge	Bridge (ViewRanger)
poi_yellow	Point of Interest - yellow (default) (ViewRanger)
ATV	ATV (Garmin)
Airport	Airport (Garmin)
Amusement Park	Amusement Park (Garmin)
Anchor	Anchor (Garmin)
Animal Tracks	Animal Tracks (Garmin)
Ball Park	Ball Park (Garmin)
Bank	Bank (Garmin)
Bar	Bar (Garmin)
Beach	Beach (Garmin)
Bell	Bell (Garmin)
Big Game	Big Game (Garmin)
Bike Trail	Bike Trail (Garmin)
Blind	Blind (Garmin)
Block, Blue	Block, Blue (Garmin)
Block, Green	Block, Green (Garmin)
Block, Red	Block, Red (Garmin)
Blood Trail	Blood Trail (Garmin)
Boat Ramp	Boat Ramp (Garmin)
Bowling	Bowling (Garmin)
Bridge	Bridge (Garmin)
Building	Building (Garmin)
Buoy, White	Buoy, White (Garmin)
Campground	Campground (Garmin)
Car	Car (Garmin)
Car Rental	Car Rental (Garmin)
Car Repair	Car Repair (Garmin)
Cemetery	Cemetery (Garmin)
Church	Church (Garmin)
City (Large)	City (Large) (Garmin)
City (Medium)	City (Medium) (Garmin)
City (Small)	City (Small) (Garmin)
Civil	Civil (Garmin)
Controlled Area	Controlled Area (Garmin)
Convenience Store	Convenience Store (Garmin)
Covey	Covey (Garmin)
Crossing	Crossing (Garmin)
Dam	Dam (Garmin)
Danger Area	Danger Area (Garmin)
Department Store	Department Store (Garmin)
Diver Down Flag 1	Diver Down Flag 1 (Garmin)
Diver Down Flag 2	Diver Down Flag 2 (Garmin)
Drinking Water	Drinking Water (Garmin)
Fast Food	Fast Food (Garmin)
Fishing Area	Fishing Area (Garmin)
Fishing Hot Spot Facility	Fishing Hot Spot Facility (Garmin)
Fitness Center	Fitness Center (Garmin)
Flag, Blue	Flag, Blue (Garmin)
Flag, Green	Flag, Green (Garmin)
Flag, Red	Flag, Red (Garmin)
Food Source	Food Source (Garmin)
Forest	Forest (Garmin)
Furbearer	Furbearer (Garmin)
Gas Station	Gas Station (Garmin)
Geocache	Geocache (Garmin)
Geocache Found	Geocache Found (Garmin)
Glider Area	Glider Area (Garmin)
Golf Course	Golf Course (Garmin)
Horn	Horn (Garmin)
Ice Skating	Ice Skating (Garmin)
Information	Information (Garmin)
Light	Light (Garmin)
Live Theater	Live Theater (Garmin)
Lodge	Lodge (Garmin)
Lodging	Lodging (Garmin)
Man Overboard	Man Overboard (Garmin)
Medical Facility	Medical Facility (Garmin)
Mine	Mine (Garmin)
Movie Theater	Movie Theater (Garmin)
Museum	Museum (Garmin)
Navaid, Amber	Navaid, Amber (Garmin)
Navaid, Black	Navaid, Black (Garmin)
Navaid, Blue	Navaid, Blue (Garmin)
Navaid, Green	Navaid, Green (Garmin)
Navaid, Green/Red	Navaid, Green/Red (Garmin)
Navaid, Green/White	Navaid, Green/White (Garmin)
Navaid, Orange	Navaid, Orange (Garmin)
Navaid, Red	Navaid, Red (Garmin)
Navaid, Red/Green	Navaid, Red/Green (Garmin)
Navaid, Red/White	Navaid, Red/White (Garmin)
Navaid, Violet	Navaid, Violet (Garmin)
Navaid, White	Navaid, White (Garmin)
Navaid, White/Green	Navaid, White/Green (Garmin)
Navaid, White/Red	Navaid, White/Red (Garmin)
Oil Field	Oil Field (Garmin)
Parachute Area	Parachute Area (Garmin)
Park	Park (Garmin)
Parking Area	Parking Area (Garmin)
Pharmacy	Pharmacy (Garmin)
Picnic Area	Picnic Area (Garmin)
Pin, Blue	Pin, Blue (Garmin)
Pin, Green	Pin, Green (Garmin)
Pin, Red	Pin, Red (Garmin)
Pizza	Pizza (Garmin)
Police Station	Police Station (Garmin)
Post Office	Post Office (Garmin)
RV Park	RV Park (Garmin)
Radio Beacon	Radio Beacon (Garmin)
Residence	Residence (Garmin)
Restaurant	Restaurant (Garmin)
Restricted Area	Restricted Area (Garmin)
Restroom	Restroom (Garmin)
Scales	Scales (Garmin)
Scenic Area	Scenic Area (Garmin)
School	School (Garmin)
Shipwreck	Shipwreck (Garmin)
Shopping Center	Shopping Center (Garmin)
Short Tower	Short Tower (Garmin)
Shower	Shower (Garmin)
Ski Resort	Ski Resort (Garmin)
Skiing Area	Skiing Area (Garmin)
Skull and Crossbones	Skull and Crossbones (Garmin)
Small Game	Small Game (Garmin)
Stadium	Stadium (Garmin)
Summit	Summit (Garmin)
Swimming Area	Swimming Area (Garmin)
Tall Tower	Tall Tower (Garmin)
Telephone	Telephone (Garmin)
Toll Booth	Toll Booth (Garmin)
Trail Head	Trail Head (Garmin)
Tree Stand	Tree Stand (Garmin)
Treed Quarry	Treed Quarry (Garmin)
Truck	Truck (Garmin)
Truck Stop	Truck Stop (Garmin)
Tunnel	Tunnel (Garmin)
Ultralight Area	Ultralight Area (Garmin)
Upland Game	Upland Game (Garmin)
Water Source	Water Source (Garmin)
Waterfowl	Waterfowl (Garmin)
Wrecker	Wrecker (Garmin)
Zoo	Zoo (Garmin)
\.


--
-- Name: itinerary_route_point_seq; Type: SEQUENCE SET; Schema: public; Owner: trip
--

SELECT pg_catalog.setval('public.itinerary_route_point_seq', 92568, true);


--
-- Name: itinerary_route_seq; Type: SEQUENCE SET; Schema: public; Owner: trip
--

SELECT pg_catalog.setval('public.itinerary_route_seq', 8358, true);


--
-- Name: itinerary_seq; Type: SEQUENCE SET; Schema: public; Owner: trip
--

SELECT pg_catalog.setval('public.itinerary_seq', 2442, true);


--
-- Name: itinerary_track_point_seq; Type: SEQUENCE SET; Schema: public; Owner: trip
--

SELECT pg_catalog.setval('public.itinerary_track_point_seq', 1325083, true);


--
-- Name: itinerary_track_segment_seq; Type: SEQUENCE SET; Schema: public; Owner: trip
--

SELECT pg_catalog.setval('public.itinerary_track_segment_seq', 5841, true);


--
-- Name: itinerary_track_seq; Type: SEQUENCE SET; Schema: public; Owner: trip
--

SELECT pg_catalog.setval('public.itinerary_track_seq', 1083, true);


--
-- Name: itinerary_waypoint_seq; Type: SEQUENCE SET; Schema: public; Owner: trip
--

SELECT pg_catalog.setval('public.itinerary_waypoint_seq', 10912, true);


--
-- Name: location_seq; Type: SEQUENCE SET; Schema: public; Owner: trip
--

SELECT pg_catalog.setval('public.location_seq', 15460, true);


--
-- Name: role_seq; Type: SEQUENCE SET; Schema: public; Owner: trip
--

SELECT pg_catalog.setval('public.role_seq', 2, true);


--
-- Name: tile_download_seq; Type: SEQUENCE SET; Schema: public; Owner: trip
--

SELECT pg_catalog.setval('public.tile_download_seq', 1060, true);


--
-- Name: usertable_seq; Type: SEQUENCE SET; Schema: public; Owner: trip
--

SELECT pg_catalog.setval('public.usertable_seq', 923, true);


--
-- Name: georef_format georef_format_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.georef_format
    ADD CONSTRAINT georef_format_pkey PRIMARY KEY (key);


--
-- Name: georef_format georef_format_value_key; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.georef_format
    ADD CONSTRAINT georef_format_value_key UNIQUE (value);


--
-- Name: itinerary itinerary_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary
    ADD CONSTRAINT itinerary_pkey PRIMARY KEY (id);


--
-- Name: itinerary_route itinerary_route_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_route
    ADD CONSTRAINT itinerary_route_pkey PRIMARY KEY (id);


--
-- Name: itinerary_route_point itinerary_route_point_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_route_point
    ADD CONSTRAINT itinerary_route_point_pkey PRIMARY KEY (id);


--
-- Name: itinerary_sharing itinerary_sharing_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_sharing
    ADD CONSTRAINT itinerary_sharing_pkey PRIMARY KEY (itinerary_id, shared_to_id);


--
-- Name: itinerary_track itinerary_track_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_track
    ADD CONSTRAINT itinerary_track_pkey PRIMARY KEY (id);


--
-- Name: itinerary_track_point itinerary_track_point_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_track_point
    ADD CONSTRAINT itinerary_track_point_pkey PRIMARY KEY (id);


--
-- Name: itinerary_track_segment itinerary_track_segment_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_track_segment
    ADD CONSTRAINT itinerary_track_segment_pkey PRIMARY KEY (id);


--
-- Name: itinerary_waypoint itinerary_waypoint_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_waypoint
    ADD CONSTRAINT itinerary_waypoint_pkey PRIMARY KEY (id);


--
-- Name: location location_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.location
    ADD CONSTRAINT location_pkey PRIMARY KEY (id);


--
-- Name: location_sharing location_sharing_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.location_sharing
    ADD CONSTRAINT location_sharing_pkey PRIMARY KEY (shared_by_id, shared_to_id);


--
-- Name: role role_name_key; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.role
    ADD CONSTRAINT role_name_key UNIQUE (name);


--
-- Name: role role_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.role
    ADD CONSTRAINT role_pkey PRIMARY KEY (id);


--
-- Name: session_data session_data_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.session_data
    ADD CONSTRAINT session_data_pkey PRIMARY KEY (session_id, key);


--
-- Name: session session_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.session
    ADD CONSTRAINT session_pkey PRIMARY KEY (id);


--
-- Name: tile tile_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.tile
    ADD CONSTRAINT tile_pkey PRIMARY KEY (server_id, x, y, z);


--
-- Name: path_color track_color_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.path_color
    ADD CONSTRAINT track_color_pkey PRIMARY KEY (key);


--
-- Name: path_color track_color_value_key; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.path_color
    ADD CONSTRAINT track_color_value_key UNIQUE (value);


--
-- Name: user_role user_role_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.user_role
    ADD CONSTRAINT user_role_pkey PRIMARY KEY (user_id, role_id);


--
-- Name: usertable usertable_email_key; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.usertable
    ADD CONSTRAINT usertable_email_key UNIQUE (email);


--
-- Name: usertable usertable_nickname_key; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.usertable
    ADD CONSTRAINT usertable_nickname_key UNIQUE (nickname);


--
-- Name: usertable usertable_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.usertable
    ADD CONSTRAINT usertable_pkey PRIMARY KEY (id);


--
-- Name: usertable usertable_uuid_key; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.usertable
    ADD CONSTRAINT usertable_uuid_key UNIQUE (uuid);


--
-- Name: waypoint_symbol waypoint_symbol_pkey; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.waypoint_symbol
    ADD CONSTRAINT waypoint_symbol_pkey PRIMARY KEY (key);


--
-- Name: waypoint_symbol waypoint_symbol_value_key; Type: CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.waypoint_symbol
    ADD CONSTRAINT waypoint_symbol_value_key UNIQUE (value);


--
-- Name: idx_time_inverse; Type: INDEX; Schema: public; Owner: trip
--

CREATE INDEX idx_time_inverse ON public.location USING btree (id, "time" DESC);

ALTER TABLE public.location CLUSTER ON idx_time_inverse;


--
-- Name: itineary_route_point_geog_idx; Type: INDEX; Schema: public; Owner: trip
--

CREATE INDEX itineary_route_point_geog_idx ON public.itinerary_route_point USING gist (geog);


--
-- Name: itineary_track_point_geog_idx; Type: INDEX; Schema: public; Owner: trip
--

CREATE INDEX itineary_track_point_geog_idx ON public.itinerary_track_point USING gist (geog);


--
-- Name: itinerary_waypoint_geog_idx; Type: INDEX; Schema: public; Owner: trip
--

CREATE INDEX itinerary_waypoint_geog_idx ON public.itinerary_waypoint USING gist (geog);


--
-- Name: location_geog_idx; Type: INDEX; Schema: public; Owner: trip
--

CREATE INDEX location_geog_idx ON public.location USING gist (geog);


--
-- Name: itinerary_route itinerary_route_itinerary_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_route
    ADD CONSTRAINT itinerary_route_itinerary_id_fkey FOREIGN KEY (itinerary_id) REFERENCES public.itinerary(id) ON DELETE CASCADE;


--
-- Name: itinerary_route_point itinerary_route_point_itinerary_route_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_route_point
    ADD CONSTRAINT itinerary_route_point_itinerary_route_id_fkey FOREIGN KEY (itinerary_route_id) REFERENCES public.itinerary_route(id) ON DELETE CASCADE;


--
-- Name: itinerary_sharing itinerary_sharing_itinerary_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_sharing
    ADD CONSTRAINT itinerary_sharing_itinerary_id_fkey FOREIGN KEY (itinerary_id) REFERENCES public.itinerary(id) ON DELETE CASCADE;


--
-- Name: itinerary_sharing itinerary_sharing_shared_to_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_sharing
    ADD CONSTRAINT itinerary_sharing_shared_to_id_fkey FOREIGN KEY (shared_to_id) REFERENCES public.usertable(id) ON DELETE CASCADE;


--
-- Name: itinerary_track itinerary_track_itinerary_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_track
    ADD CONSTRAINT itinerary_track_itinerary_id_fkey FOREIGN KEY (itinerary_id) REFERENCES public.itinerary(id) ON DELETE CASCADE;


--
-- Name: itinerary_track_point itinerary_track_point_itinerary_track_segment_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_track_point
    ADD CONSTRAINT itinerary_track_point_itinerary_track_segment_id_fkey FOREIGN KEY (itinerary_track_segment_id) REFERENCES public.itinerary_track_segment(id) ON DELETE CASCADE;


--
-- Name: itinerary_track_segment itinerary_track_segment_itinerary_track_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_track_segment
    ADD CONSTRAINT itinerary_track_segment_itinerary_track_id_fkey FOREIGN KEY (itinerary_track_id) REFERENCES public.itinerary_track(id) ON DELETE CASCADE;


--
-- Name: itinerary itinerary_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary
    ADD CONSTRAINT itinerary_user_id_fkey FOREIGN KEY (user_id) REFERENCES public.usertable(id);


--
-- Name: itinerary_waypoint itinerary_waypoint_itinerary_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.itinerary_waypoint
    ADD CONSTRAINT itinerary_waypoint_itinerary_id_fkey FOREIGN KEY (itinerary_id) REFERENCES public.itinerary(id) ON DELETE CASCADE;


--
-- Name: location_sharing location_sharing_shared_by_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.location_sharing
    ADD CONSTRAINT location_sharing_shared_by_id_fkey FOREIGN KEY (shared_by_id) REFERENCES public.usertable(id) ON DELETE CASCADE;


--
-- Name: location_sharing location_sharing_shared_to_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.location_sharing
    ADD CONSTRAINT location_sharing_shared_to_id_fkey FOREIGN KEY (shared_to_id) REFERENCES public.usertable(id) ON DELETE CASCADE;


--
-- Name: location location_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.location
    ADD CONSTRAINT location_user_id_fkey FOREIGN KEY (user_id) REFERENCES public.usertable(id);


--
-- Name: session_data session_data_session_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.session_data
    ADD CONSTRAINT session_data_session_id_fkey FOREIGN KEY (session_id) REFERENCES public.session(id) ON DELETE CASCADE;


--
-- Name: session session_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.session
    ADD CONSTRAINT session_user_id_fkey FOREIGN KEY (user_id) REFERENCES public.usertable(id) ON DELETE CASCADE;


--
-- Name: user_role user_role_role_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.user_role
    ADD CONSTRAINT user_role_role_id_fkey FOREIGN KEY (role_id) REFERENCES public.role(id) ON DELETE CASCADE;


--
-- Name: user_role user_role_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: trip
--

ALTER TABLE ONLY public.user_role
    ADD CONSTRAINT user_role_user_id_fkey FOREIGN KEY (user_id) REFERENCES public.usertable(id) ON DELETE CASCADE;


--
-- Name: SCHEMA public; Type: ACL; Schema: -; Owner: postgres
--

GRANT USAGE ON SCHEMA public TO trip_role;


--
-- Name: TABLE georef_format; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT ON TABLE public.georef_format TO trip_role;


--
-- Name: TABLE itinerary; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.itinerary TO trip_role;


--
-- Name: TABLE itinerary_route; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.itinerary_route TO trip_role;


--
-- Name: TABLE itinerary_route_point; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.itinerary_route_point TO trip_role;


--
-- Name: SEQUENCE itinerary_route_point_seq; Type: ACL; Schema: public; Owner: trip
--

GRANT USAGE ON SEQUENCE public.itinerary_route_point_seq TO trip_role;


--
-- Name: SEQUENCE itinerary_route_seq; Type: ACL; Schema: public; Owner: trip
--

GRANT USAGE ON SEQUENCE public.itinerary_route_seq TO trip_role;


--
-- Name: SEQUENCE itinerary_seq; Type: ACL; Schema: public; Owner: trip
--

GRANT USAGE ON SEQUENCE public.itinerary_seq TO trip_role;


--
-- Name: TABLE itinerary_sharing; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.itinerary_sharing TO trip_role;


--
-- Name: TABLE itinerary_track; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.itinerary_track TO trip_role;


--
-- Name: TABLE itinerary_track_point; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.itinerary_track_point TO trip_role;


--
-- Name: SEQUENCE itinerary_track_point_seq; Type: ACL; Schema: public; Owner: trip
--

GRANT USAGE ON SEQUENCE public.itinerary_track_point_seq TO trip_role;


--
-- Name: TABLE itinerary_track_segment; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.itinerary_track_segment TO trip_role;


--
-- Name: SEQUENCE itinerary_track_segment_seq; Type: ACL; Schema: public; Owner: trip
--

GRANT USAGE ON SEQUENCE public.itinerary_track_segment_seq TO trip_role;


--
-- Name: SEQUENCE itinerary_track_seq; Type: ACL; Schema: public; Owner: trip
--

GRANT USAGE ON SEQUENCE public.itinerary_track_seq TO trip_role;


--
-- Name: TABLE itinerary_waypoint; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.itinerary_waypoint TO trip_role;


--
-- Name: SEQUENCE itinerary_waypoint_seq; Type: ACL; Schema: public; Owner: trip
--

GRANT USAGE ON SEQUENCE public.itinerary_waypoint_seq TO trip_role;


--
-- Name: SEQUENCE location_seq; Type: ACL; Schema: public; Owner: trip
--

GRANT USAGE ON SEQUENCE public.location_seq TO trip_role;


--
-- Name: TABLE location; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT,INSERT ON TABLE public.location TO trip_role;


--
-- Name: TABLE location_sharing; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.location_sharing TO trip_role;


--
-- Name: TABLE path_color; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT ON TABLE public.path_color TO trip_role;


--
-- Name: TABLE role; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT,INSERT ON TABLE public.role TO trip_role;


--
-- Name: SEQUENCE role_seq; Type: ACL; Schema: public; Owner: trip
--

GRANT USAGE ON SEQUENCE public.role_seq TO trip_role;


--
-- Name: TABLE tile; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.tile TO trip_role;


--
-- Name: SEQUENCE tile_download_seq; Type: ACL; Schema: public; Owner: trip
--

GRANT USAGE ON SEQUENCE public.tile_download_seq TO trip_role;


--
-- Name: TABLE tile_metric; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT,INSERT ON TABLE public.tile_metric TO trip_role;


--
-- Name: TABLE user_role; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.user_role TO trip_role;


--
-- Name: SEQUENCE usertable_seq; Type: ACL; Schema: public; Owner: trip
--

GRANT USAGE ON SEQUENCE public.usertable_seq TO trip_role;


--
-- Name: TABLE usertable; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE public.usertable TO trip_role;


--
-- Name: TABLE waypoint_symbol; Type: ACL; Schema: public; Owner: trip
--

GRANT SELECT ON TABLE public.waypoint_symbol TO trip_role;


--
-- PostgreSQL database dump complete
--

